/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.JsonWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WidgetValue {
    private JsonValue json;

    public WidgetValue() {
    }

    public WidgetValue(JsonValue json) {
        if (json == null) {
            throw new IllegalArgumentException("JsonValue cannot be null.");
        }
        this.json = json;
    }

    public JsonValue getJson() {
        return this.json;
    }

    public List<String> getVariables() {
        if (!this.json.has("variables")) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>();
        JsonValue variables = this.json.get("variables");
        for (JsonValue child : variables) {
            result.add(child.name);
        }
        return result;
    }

    public JsonValue substitute(JsonValue values) {
        JsonValue variables = this.json.get("variables");
        JsonValue contents = this.json.get("contents");
        JsonValue contentCopy = new JsonReader().parse(contents.toJson(JsonWriter.OutputType.json));
        if (values != null) {
            for (JsonValue child : values) {
                String[] sAry;
                if (!variables.has(child.name)) continue;
                boolean found = true;
                JsonValue address = variables.get(child.name);
                JsonValue spotToChange = contentCopy;
                for (String s : sAry = address.asStringArray()) {
                    if (spotToChange.has(s)) {
                        spotToChange = spotToChange.get(s);
                        continue;
                    }
                    found = false;
                }
                if (found) {
                    String spotName = spotToChange.name;
                    JsonValue spotParent = spotToChange.parent();
                    assert (spotParent != null) : "You cannot merge with the root node";
                    spotParent.remove(spotName);
                    spotParent.addChild(spotName, child);
                    continue;
                }
                System.err.println("No variable found matching name " + child.name);
            }
        }
        return contentCopy;
    }

    public boolean isValid() {
        JsonValue variables = this.json.get("variables");
        JsonValue contents = this.json.get("contents");
        if (contents == null) {
            return false;
        }
        if (variables == null) {
            return true;
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (JsonValue child : variables) {
            if (child.isString()) {
                paths.add(child.asString());
                continue;
            }
            if (child.isArray()) {
                StringBuilder sb = new StringBuilder();
                for (JsonValue path : child) {
                    sb.append("/").append(path.asString());
                }
                paths.add(sb.toString());
                continue;
            }
            return false;
        }
        Collections.sort(paths, (a, b) -> Integer.compare(a.length(), b.length()));
        for (int i = 0; i < paths.size() - 1; ++i) {
            String a2 = (String)paths.get(i);
            String b2 = (String)paths.get(i + 1);
            if (!b2.startsWith(a2)) continue;
            return false;
        }
        return true;
    }
}

