/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.ObjectMap;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.assets.AssetParser;

public class DirectoryLoader
extends AsynchronousAssetLoader<AssetDirectory.Index, DirectoryLoaderParameters> {
    protected AssetDirectory.Index cachedData;
    protected Array<AssetParser<?>> parsers = new Array(false, 16);

    public DirectoryLoader() {
        this((FileHandleResolver)new InternalFileHandleResolver());
    }

    public DirectoryLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    public Array<AssetParser<?>> getParsers() {
        return this.parsers;
    }

    public void addParser(AssetParser<?> parser) {
        this.parsers.add(parser);
    }

    public void removeParser(AssetParser<?> parser) {
        this.parsers.removeValue(parser, false);
    }

    protected AssetDirectory.Index getLoadedDirectory() {
        return this.cachedData;
    }

    public void loadAsync(AssetManager manager, String fileName, FileHandle file, DirectoryLoaderParameters params) {
        JsonReader reader = new JsonReader();
        this.cachedData = new AssetDirectory.Index();
        this.cachedData.directory = reader.parse(file);
        for (AssetParser parser : this.parsers) {
            ObjectMap keys = (ObjectMap)this.cachedData.keymap.get(parser.getType(), null);
            if (keys == null) {
                keys = new ObjectMap();
                this.cachedData.keymap.put(parser.getType(), (Object)keys);
            }
            parser.reset(this.cachedData.directory);
            while (parser.hasNext()) {
                parser.processNext(manager, (ObjectMap<String, String>)keys);
            }
        }
    }

    public AssetDirectory.Index loadSync(AssetManager manager, String fileName, FileHandle file, DirectoryLoaderParameters params) {
        AssetDirectory.Index directory = this.cachedData;
        this.cachedData = null;
        return directory;
    }

    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, DirectoryLoaderParameters params) {
        return null;
    }

    public static class DirectoryLoaderParameters
    extends AssetLoaderParameters<AssetDirectory.Index> {
    }
}

