/*
 * GameObject.java
 *
 * This is a polymorphic interface for all our game models, so that we can
 * resize them if the window size changes. Not that if the window size changes,
 * the the physics units change (hence the method).
 *
 * Based on the original PhysicsDemo Lab by Don Holden, 2007
 *
 * Author:  Walker M. White
 * Version: 2/14/2025
 */
 package edu.cornell.cis3152.json;

import edu.cornell.gdiac.physics2.Obstacle;
import edu.cornell.gdiac.physics2.ObstacleSprite;

/**
 * An object to be stored in GameLevel
 */
public abstract class GameObject extends ObstacleSprite {

    /**
     * Sets the physics units for this game object.
     *
     * Setting the physics objects build the mesh for this object. This method
     * should be called whenever the window size changes to resize the meshes
     * for the new display.
     *
     * @param units The physics units for this object
     */
    public abstract void setPhysicsUnits(float units);

}
