/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.graphics.shaders;

import com.badlogic.gdx.Gdx;
import edu.cornell.gdiac.graphics.Shader;

public class SpriteShader {
    public static final String POSITION_ATTRIBUTE = "a_position";
    public static final String COLOR_ATTRIBUTE = "a_color";
    public static final String TEXCOORD_ATTRIBUTE = "a_texCoord";
    public static final String GRADCOORD_ATTRIBUTE = "a_gradCoords";
    public static final String PROJECTION_UNIFORM = "u_projTrans";
    public static final String TEXTURE_UNIFORM = "u_texture";
    public static final String DRAWTYPE_UNIFORM = "u_drawtype";
    public static final String BLURSTEP_UNIFORM = "u_blurstep";
    public static final String CONTEXT_UNIFORM = "u_context";
    public static final String[] CONTEXT_FIELDS = new String[]{"scMatrix", "scExtent", "scScale", "gdMatrix", "gdInner", "gdOuter", "gdExtent", "gdRadius", "gdFeathr"};
    public static final int[] CONTEXT_OFFSETS = new int[]{0, 48, 56, 64, 112, 128, 144, 152, 156, 160};
    public static final int[] ATTRIBUTE_OFFSET = new int[]{0, 8, 12, 20, 28};
    private static String[] vertex20 = new String[]{"////////// SHADER BEGIN /////////", "// Positions", "attribute vec4 a_position;", "varying vec2 outPosition;", "", "// Colors", "attribute  vec4 a_color;", "varying vec4 outColor;", "", "// Texture coordinates", "attribute  vec2 a_texCoord;", "varying vec2 outTexCoord;", "", "// Matrices", "uniform mat4 u_projTrans;", "", "// Transform and pass through", "void main(void) {", "    gl_Position = u_projTrans*a_position;", "    outPosition = a_position.xy; // Need untransformed for scissor", "    outColor = a_color;", "    outTexCoord = a_texCoord;", "}", "/////////// SHADER END //////////"};
    private static String[] vertex30 = new String[]{"////////// SHADER BEGIN /////////", "// Positions", "in vec4 a_position;", "out vec2 outPosition;", "", "// Colors", "in  vec4 a_color;", "out vec4 outColor;", "", "// Texture coordinates", "in  vec2 a_texCoord;", "out vec2 outTexCoord;", "", "// Gradient coordinates", "in  vec2 a_gradCoords;", "out vec2 outGradCoord;", "", "// Matrices", "uniform mat4 u_projTrans;", "", "// Transform and pass through", "void main(void) {", "    gl_Position = u_projTrans*a_position;", "    outPosition = a_position.xy; // Need untransformed for scissor", "    outColor = a_color;", "    outTexCoord = a_texCoord;", "    outGradCoord = a_gradCoords;", "}", "/////////// SHADER END //////////"};
    private static String[] fragment20 = new String[]{"////////// SHADER BEGIN /////////", "#ifdef GL_ES", "    // This one line is all the difference", "    precision mediump float;", "#endif", "", "// Bit vector for texturing and scissoring", "uniform int  u_drawtype;", "// Blur offset for simple kernel blur", "uniform vec2 u_blurstep;", "", "// The texture for sampling", "uniform sampler2D u_texture;", "", "// The inputs from the vertex shader", "varying vec2 outPosition;", "varying vec4 outColor;", "varying vec2 outTexCoord;", "", "// The scissor uniforms,", "uniform mat3 " + CONTEXT_FIELDS[0] + ";", "uniform vec2 " + CONTEXT_FIELDS[1] + ";", "uniform vec2 " + CONTEXT_FIELDS[2] + ";", "", "/**", " * Returns an alpha value for scissoring", " *", " * A pixel with value 0 is dropped, while one with value 1 is kept.", " * The scale value sets the 0 to 1 transition (which should be quick).", " *", " * Adapted from nanovg by Mikko Mononen (memon@inside.org)", " *", " * pt:  The point to test", " */", "float scissormask(vec2 pt) {", "    vec2 sc = (abs((" + CONTEXT_FIELDS[0] + " * vec3(pt,1.0)).xy) - " + CONTEXT_FIELDS[1] + ");", "    sc = vec2(0.5,0.5) - sc * " + CONTEXT_FIELDS[2] + ";", "    return clamp(sc.x,0.0,1.0) * clamp(sc.y,0.0,1.0);", "}", "", "/**", " * Returns the result of a simple kernel blur", " *", " * This function blurs the texture with a separable 256", " * element kernel. It is not meant to provide a full-feature", " * Gaussian blur. It is a high performance blur for simple", " * effects (like font blurring).", " *", " * coord: The texture coordinate to blur", " */", "vec4 blursample(vec2 coord) {", "    // Separable gaussian", "    float factor[5];", "    factor[0] = 1.0;", "    factor[1] = 4.0;", "    factor[2] = 6.0;", "    factor[3] = 4.0;", "    factor[4] = 1.0;", "", "    // Sample steps", "    float steps[5];", "    steps[0] = -1.0;", "    steps[1] = -0.5;", "    steps[2] = 0.0;", "    steps[3] = 0.5;", "    steps[4] = 1.0;", "", "    // Sample from the texture and average", "    vec4 result = vec4(0.0);", "    for(int ii = 0; ii < 5; ii++) {", "        vec4 row = vec4(0.0);", "        for(int jj = 0; jj < 5; jj++) {", "            vec2 offs = vec2(u_blurstep.x*steps[ii],u_blurstep.y*steps[jj]);", "            row += texture2D(u_texture, coord + offs)*factor[jj];", "        }", "        result += row*factor[ii];", "    }", "", "    result /= vec4(256);", "    return result;", "}", "", "/**", " * Performs the main fragment shading.", " */", "void main(void) {", "    vec4 result = outColor;", "    float fType = float(u_drawtype);", "", "    if (mod(fType, 2.0) == 1.0) {", "        // Include texture (tinted by color)", "        if (fType >= 8.0) {", "            result *= blursample(outTexCoord);", "        } else {", "            result *= texture2D(u_texture, outTexCoord);", "        }", "    }", "", "    if (mod(fType, 8.0) >= 4.0) {", "        // Apply scissor mask", "        result.w *= scissormask(outPosition);", "    }", "", "    gl_FragColor = result;", "}", "/////////// SHADER END //////////"};
    private static String[] fragment30 = new String[]{"////////// SHADER BEGIN /////////", "#ifdef GL_ES", "    precision mediump float;", "#endif", "", "// Bit vector for texturing, gradients, and scissoring", "uniform int  u_drawtype;", "// Blur offset for simple kernel blur", "uniform vec2 u_blurstep;", "", "// The texture for sampling", "uniform sampler2D u_texture;", "", "// The output color", "out vec4 frag_color;", "", "// The inputs from the vertex shader", "in vec2 outPosition;", "in vec4 outColor;", "in vec2 outTexCoord;", "in vec2 outGradCoord;", "", "// The stroke+gradient uniform block", "layout (std140) uniform u_context", "{", "    mat3 " + CONTEXT_FIELDS[0] + ";      // 48", "    vec2 " + CONTEXT_FIELDS[1] + ";      //  8", "    vec2 " + CONTEXT_FIELDS[2] + ";       //  8", "    mat3 " + CONTEXT_FIELDS[3] + ";      // 48", "    vec4 " + CONTEXT_FIELDS[4] + ";       // 16", "    vec4 " + CONTEXT_FIELDS[5] + ";       // 16", "    vec2 " + CONTEXT_FIELDS[6] + ";      //  8", "    float " + CONTEXT_FIELDS[7] + ";     //  4", "    float " + CONTEXT_FIELDS[8] + ";     //  4", "};", "", "/**", " * Returns an interpolation value for a box gradient", " *", " * The value returned is the mix parameter for the inner and", " * outer color.", " *", " * Adapted from nanovg by Mikko Mononen (memon@inside.org)", " *", " * pt:      The (transformed) point to test", " * ext:     The gradient extent", " * radius:  The gradient radius", " * feather: The gradient feather amount", " */", "float boxgradient(vec2 pt, vec2 ext, float radius, float feather) {", "    vec2 ext2 = ext - vec2(radius,radius);", "    vec2 dst = abs(pt) - ext2;", "    float m = min(max(dst.x,dst.y),0.0) + length(max(dst,0.0)) - radius;", "    return clamp((m + feather*0.5) / feather, 0.0, 1.0);", "}", "", "", "/**", " * Returns an alpha value for scissoring", " *", " * A pixel with value 0 is dropped, while one with value 1 is kept.", " * The scale value sets the 0 to 1 transition (which should be quick).", " *", " * Adapted from nanovg by Mikko Mononen (memon@inside.org)", " *", " * pt:  The point to test", " */", "float scissormask(vec2 pt) {", "    vec2 sc = (abs((" + CONTEXT_FIELDS[0] + " * vec3(pt,1.0)).xy) - " + CONTEXT_FIELDS[1] + ");", "    sc = vec2(0.5,0.5) - sc * " + CONTEXT_FIELDS[2] + ";", "    return clamp(sc.x,0.0,1.0) * clamp(sc.y,0.0,1.0);", "}", "", "/**", " * Returns the result of a simple kernel blur", " *", " * This function blurs the texture with a separable 256", " * element kernel. It is not meant to provide a full-feature", " * Gaussian blur. It is a high performance blur for simple", " * effects (like font blurring).", " *", " * coord: The texture coordinate to blur", " */", "vec4 blursample(vec2 coord) {", "    // Separable gaussian", "    float factor[5] = float[]( 1.0,  4.0, 6.0, 4.0, 1.0 );", "    // Sample steps", "    float steps[5]  = float[]( -1.0, -0.5, 0.0, 0.5, 1.0 );", "", "    // Sample from the texture and average", "    vec4 result = vec4(0.0);", "    for(int ii = 0; ii < 5; ii++) {", "        vec4 row = vec4(0.0);", "        for(int jj = 0; jj < 5; jj++) {", "            vec2 offs = vec2(u_blurstep.x*steps[ii],u_blurstep.y*steps[jj]);", "            row += texture(u_texture, coord + offs)*factor[jj];", "        }", "        result += row*factor[ii];", "    }", "", "    result /= vec4(256);", "    return result;", "}", "", "/**", " * Performs the main fragment shading.", " */", "void main(void) {", "    vec4 result;", "    if (mod(u_drawtype, 4.0) >= 2.0) {", "        // Apply a gradient color", "        mat3  cmatrix = " + CONTEXT_FIELDS[3] + ";", "        vec2  cextent = " + CONTEXT_FIELDS[6] + ";", "        float cfeathr = " + CONTEXT_FIELDS[8] + ";", "        vec2 pt = (cmatrix * vec3(outGradCoord,1.0)).xy;", "        float d = boxgradient(pt,cextent," + CONTEXT_FIELDS[7] + ",cfeathr);", "        result = mix(" + CONTEXT_FIELDS[4] + "," + CONTEXT_FIELDS[5] + ",d);", "    } else {", "        // Use a solid color", "        result = outColor;", "    }", "", "    if (mod(u_drawtype, 2.0) == 1.0) {", "        // Include texture (tinted by color or gradient)", "        if (u_drawtype >= 8.0) {", "            result *= blursample(outTexCoord);", "        } else {", "            result *= texture(u_texture, outTexCoord);", "        }", "    }", "", "    if (mod(u_drawtype, 8.0) >= 4.0) {", "        // Apply scissor mask", "        result.w *= scissormask(outPosition);", "    }", "", "    frag_color = result;", "}", "/////////// SHADER END //////////"};

    public static Shader createShader() {
        return SpriteShader.createShader(true);
    }

    public static Shader createShader(boolean ogl3) {
        String[] vertSource = vertex20;
        String[] fragSource = fragment20;
        if (ogl3) {
            vertSource = vertex30;
            fragSource = fragment30;
        }
        StringBuilder vstr = new StringBuilder();
        for (String s : vertSource) {
            vstr.append(s);
            vstr.append("\n");
        }
        String vertexShader = vstr.toString();
        StringBuilder fstr = new StringBuilder();
        for (String s : fragSource) {
            fstr.append(s);
            fstr.append("\n");
        }
        String fragmentShader = fstr.toString();
        Shader.pedantic = false;
        String vertPrefix = Shader.prependVertexCode;
        String fragPrefix = Shader.prependFragmentCode;
        if (Gdx.gl30 != null) {
            Shader.prependVertexCode = "#version 330 core\n";
            Shader.prependFragmentCode = "#version 330 core\n";
        }
        Shader spriteShader = new Shader(vertexShader, fragmentShader);
        if (Gdx.gl30 != null) {
            Shader.prependVertexCode = vertPrefix;
            Shader.prependFragmentCode = fragPrefix;
        }
        if (!spriteShader.isCompiled()) {
            throw new IllegalArgumentException("Error compiling shader: " + spriteShader.getLog());
        }
        return spriteShader;
    }
}

