/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.graphics;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;

public class Gradient {
    private Affine2 inverse;
    private Color inner;
    private Color outer;
    private Vector2 extent;
    private float radius;
    private float feather;

    public Gradient() {
        this.radius = 0.0f;
        this.feather = 0.0f;
        this.inverse = new Affine2();
        this.inner = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        this.outer = new Color(1.0f, 1.0f, 1.0f, 1.0f);
        this.extent = new Vector2();
    }

    public Gradient(Color color) {
        this();
        this.set(color);
    }

    public Gradient(Color inner, Color outer, Vector2 start, Vector2 end) {
        this();
        this.set(inner, outer, start, end);
    }

    public Gradient(Gradient grad) {
        this.inverse = grad.inverse;
        this.inner = grad.inner;
        this.outer = grad.outer;
        this.extent = grad.extent;
        this.radius = grad.radius;
        this.feather = grad.feather;
    }

    public Gradient(Color inner, Color outer, Vector2 center, float radius) {
        float r = radius * 0.5f;
        this.inverse = new Affine2();
        this.inverse.m02 = -center.x;
        this.inverse.m12 = -center.y;
        this.inner = inner;
        this.outer = outer;
        this.extent = new Vector2(r, r);
        this.radius = r;
        this.feather = radius;
    }

    public Gradient(Color inner, Color outer, Vector2 center, float iradius, float oradius) {
        this();
        this.set(inner, outer, center, iradius, oradius);
    }

    public Gradient(Color inner, Color outer, Rectangle box, float radius, float feather) {
        this();
        this.set(inner, outer, box, radius, feather);
    }

    public Gradient set(Gradient grad) {
        this.inverse.set(grad.inverse);
        this.inner.set(grad.inner);
        this.outer.set(grad.outer);
        this.extent.set(grad.extent);
        this.radius = grad.radius;
        this.feather = grad.feather;
        return this;
    }

    public Gradient set(Color color) {
        this.inverse.idt();
        this.inner.set(color);
        this.outer.set(color);
        return this;
    }

    public Gradient set(Color inner, Color outer, Vector2 start, Vector2 end) {
        float large = 100000.0f;
        float dx = end.x - start.x;
        float dy = end.y - start.y;
        float d = (float)Math.sqrt(dx * dx + dy * dy);
        if (d > 1.0E-4f) {
            dx /= d;
            dy /= d;
        } else {
            dx = 0.0f;
            dy = 1.0f;
        }
        this.inverse.m00 = dy;
        this.inverse.m10 = -dx;
        this.inverse.m01 = dx;
        this.inverse.m11 = dy;
        this.inverse.m02 = start.x - dx * large;
        this.inverse.m12 = start.y - dy * large;
        this.inverse.inv();
        this.inner.set(inner == null ? Color.WHITE : inner);
        this.outer.set(outer == null ? Color.WHITE : outer);
        this.extent.set(large, large + d * 0.5f);
        this.radius = 0.0f;
        this.feather = d;
        return this;
    }

    public Gradient set(Color inner, Color outer, Vector2 center, float radius) {
        this.inverse.idt();
        this.inverse.m02 = -center.x;
        this.inverse.m12 = -center.y;
        this.inner.set(inner == null ? Color.WHITE : inner);
        this.outer.set(outer == null ? Color.WHITE : outer);
        this.extent.set(radius, radius);
        this.radius = radius;
        this.feather = 0.0f;
        return this;
    }

    public Gradient set(Color inner, Color outer, Vector2 center, float iradius, float oradius) {
        float r = (iradius + oradius) * 0.5f;
        this.inverse.idt();
        this.inverse.m02 = -center.x;
        this.inverse.m12 = -center.y;
        this.inner.set(inner == null ? Color.WHITE : inner);
        this.outer.set(outer == null ? Color.WHITE : outer);
        this.extent.set(r, r);
        this.radius = r;
        this.feather = oradius - iradius;
        return this;
    }

    public Gradient set(Color inner, Color outer, Rectangle box, float radius, float feather) {
        this.inverse.idt();
        this.inverse.m02 = box.x + box.width * 0.5f;
        this.inverse.m12 = box.y + box.height * 0.5f;
        this.inverse.inv();
        this.inner.set(inner == null ? Color.WHITE : inner);
        this.outer.set(outer == null ? Color.WHITE : outer);
        this.extent.set(box.width * 0.5f, box.height * 0.5f);
        this.radius = radius;
        this.feather = feather;
        return this;
    }

    public Affine2 getTransform() {
        return new Affine2(this.inverse).inv();
    }

    public void setTransform(Affine2 transform) {
        this.inverse.set(transform);
        this.inverse.inv();
    }

    public void setTransform(Matrix4 transform) {
        this.inverse.set(transform);
        this.inverse.inv();
    }

    public Color getInnerColor() {
        return new Color(this.inner);
    }

    public void setInnerColor(Color color) {
        this.inner.set(color == null ? Color.WHITE : color);
    }

    public Color getOuterColor() {
        return new Color(this.outer);
    }

    public void setOuterColor(Color color) {
        this.outer.set(color == null ? Color.WHITE : color);
    }

    public Vector2 getExtent() {
        return new Vector2(this.extent);
    }

    public void setExtent(Vector2 extent) {
        this.extent.set(extent == null ? Vector2.Zero : extent);
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public float getFeather() {
        return this.feather;
    }

    public void setFeather(float feather) {
        this.feather = feather;
    }

    public Gradient rotate(float angle) {
        Affine2 temp = new Affine2();
        temp.rotate(-angle);
        this.inverse.preMul(temp);
        return this;
    }

    public Gradient scale(float value) {
        if (value == 0.0f) {
            this.inverse.m00 = 0.0f;
            this.inverse.m01 = 0.0f;
            this.inverse.m02 = 0.0f;
            this.inverse.m10 = 0.0f;
            this.inverse.m11 = 0.0f;
            this.inverse.m12 = 0.0f;
            return this;
        }
        Affine2 temp = new Affine2();
        temp.scale(1.0f / value, 1.0f / value);
        this.inverse.preMul(temp);
        return this;
    }

    public Gradient scale(Vector2 s) {
        if (s.x == 0.0f || s.y == 0.0f) {
            this.inverse.m00 = 0.0f;
            this.inverse.m01 = 0.0f;
            this.inverse.m02 = 0.0f;
            this.inverse.m10 = 0.0f;
            this.inverse.m11 = 0.0f;
            this.inverse.m12 = 0.0f;
            return this;
        }
        Affine2 temp = new Affine2();
        temp.scale(1.0f / s.x, 1.0f / s.y);
        this.inverse.preMul(temp);
        return this;
    }

    public Gradient scale(float sx, float sy) {
        if (sx == 0.0f || sy == 0.0f) {
            this.inverse.m00 = 0.0f;
            this.inverse.m01 = 0.0f;
            this.inverse.m02 = 0.0f;
            this.inverse.m10 = 0.0f;
            this.inverse.m11 = 0.0f;
            this.inverse.m12 = 0.0f;
            return this;
        }
        Affine2 temp = new Affine2();
        temp.scale(1.0f / sx, 1.0f / sy);
        this.inverse.preMul(temp);
        return this;
    }

    public Gradient translate(Vector2 t) {
        Affine2 temp = new Affine2();
        temp.translate(-t.x, -t.y);
        this.inverse.preMul(temp);
        return this;
    }

    public Gradient translate(float tx, float ty) {
        Affine2 temp = new Affine2();
        temp.translate(-tx, -ty);
        this.inverse.preMul(temp);
        return this;
    }

    public Gradient multiply(Matrix4 mat) {
        Affine2 temp = new Affine2();
        temp.set(mat);
        temp.inv();
        this.inverse.preMul(temp);
        return this;
    }

    public Gradient multiply(Affine2 aff) {
        Affine2 temp = new Affine2();
        temp.set(aff);
        temp.inv();
        this.inverse.preMul(temp);
        return this;
    }

    public float[] getData(float[] array, int offset) {
        array[offset] = this.inverse.m00;
        array[offset + 1] = this.inverse.m10;
        array[offset + 2] = 0.0f;
        array[offset + 3] = 0.0f;
        array[offset + 4] = this.inverse.m01;
        array[offset + 5] = this.inverse.m11;
        array[offset + 6] = 0.0f;
        array[offset + 7] = 0.0f;
        array[offset + 8] = this.inverse.m02;
        array[offset + 9] = this.inverse.m12;
        array[offset + 10] = 1.0f;
        array[offset + 11] = 0.0f;
        array[offset + 12] = this.inner.r;
        array[offset + 13] = this.inner.g;
        array[offset + 14] = this.inner.b;
        array[offset + 15] = this.inner.a;
        array[offset + 16] = this.outer.r;
        array[offset + 17] = this.outer.g;
        array[offset + 18] = this.outer.b;
        array[offset + 19] = this.outer.a;
        array[offset + 20] = this.extent.x;
        array[offset + 21] = this.extent.y;
        array[offset + 22] = this.radius;
        array[offset + 23] = this.feather;
        return array;
    }

    public float[] getComponents(float[] array, int offset) {
        array[offset] = this.inverse.m00;
        array[offset + 1] = this.inverse.m10;
        array[offset + 2] = 0.0f;
        array[offset + 3] = this.inverse.m01;
        array[offset + 4] = this.inverse.m11;
        array[offset + 5] = 0.0f;
        array[offset + 6] = this.inverse.m02;
        array[offset + 7] = this.inverse.m12;
        array[offset + 8] = 1.0f;
        array[offset + 9] = this.inner.r;
        array[offset + 10] = this.inner.g;
        array[offset + 11] = this.inner.b;
        array[offset + 12] = this.inner.a;
        array[offset + 13] = this.outer.r;
        array[offset + 14] = this.outer.g;
        array[offset + 15] = this.outer.b;
        array[offset + 16] = this.outer.a;
        array[offset + 17] = this.extent.x;
        array[offset + 18] = this.extent.y;
        array[offset + 19] = this.radius;
        array[offset + 20] = this.feather;
        return array;
    }

    public String toString() {
        String result = "Gradient[";
        result = result + this.inverse;
        result = result + "; ";
        result = result + this.extent;
        result = result + "; ";
        result = result + this.radius;
        result = result + "; ";
        result = result + this.feather;
        result = result + "]";
        return result;
    }
}

