/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.ParticleEffectLoader;
import com.badlogic.gdx.assets.loaders.PixmapLoader;
import com.badlogic.gdx.assets.loaders.SkinLoader;
import com.badlogic.gdx.assets.loaders.TextureAtlasLoader;
import com.badlogic.gdx.assets.loaders.TextureLoader;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.audio.Music;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.ParticleEffect;
import com.badlogic.gdx.graphics.g2d.PolygonRegion;
import com.badlogic.gdx.graphics.g2d.PolygonRegionLoader;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGeneratorLoader;
import com.badlogic.gdx.graphics.g2d.freetype.FreetypeFontLoader;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ObjectMap;
import edu.cornell.gdiac.assets.AssetParser;
import edu.cornell.gdiac.assets.AudioSourceLoader;
import edu.cornell.gdiac.assets.AudioSourceParser;
import edu.cornell.gdiac.assets.DirectoryLoader;
import edu.cornell.gdiac.assets.FreetypeFontParser;
import edu.cornell.gdiac.assets.JsonValueLoader;
import edu.cornell.gdiac.assets.JsonValueParser;
import edu.cornell.gdiac.assets.MaterialLibLoader;
import edu.cornell.gdiac.assets.MaterialLibParser;
import edu.cornell.gdiac.assets.MusicLoader;
import edu.cornell.gdiac.assets.MusicParser;
import edu.cornell.gdiac.assets.MusicQueueLoader;
import edu.cornell.gdiac.assets.MusicQueueParser;
import edu.cornell.gdiac.assets.ObjModelLoader;
import edu.cornell.gdiac.assets.ObjModelParser;
import edu.cornell.gdiac.assets.ShaderLoader;
import edu.cornell.gdiac.assets.ShaderParser;
import edu.cornell.gdiac.assets.SoundEffectLoader;
import edu.cornell.gdiac.assets.SoundEffectParser;
import edu.cornell.gdiac.assets.SoundLoader;
import edu.cornell.gdiac.assets.SoundParser;
import edu.cornell.gdiac.assets.SpriteSheetLoader;
import edu.cornell.gdiac.assets.SpriteSheetParser;
import edu.cornell.gdiac.assets.TextureParser;
import edu.cornell.gdiac.assets.TextureRegionLoader;
import edu.cornell.gdiac.assets.TextureRegionParser;
import edu.cornell.gdiac.assets.WidgetValue;
import edu.cornell.gdiac.assets.WidgetValueLoader;
import edu.cornell.gdiac.assets.WidgetValueParser;
import edu.cornell.gdiac.audio.AudioSource;
import edu.cornell.gdiac.audio.MusicQueue;
import edu.cornell.gdiac.audio.SoundEffect;
import edu.cornell.gdiac.graphics.Shader;
import edu.cornell.gdiac.graphics.SpriteSheet;
import edu.cornell.gdiac.graphics.Texture2D;
import edu.cornell.gdiac.graphics.obj.MaterialLib;
import edu.cornell.gdiac.graphics.obj.Model;

public class AssetDirectory
extends AssetManager {
    protected FileHandleResolver resolver;
    protected String filename;
    protected Index contents;
    protected DirectoryLoader topLoader;
    private float progress;
    private AssetLoaderParameters.LoadedCallback callback = new AssetLoaderParameters.LoadedCallback(){

        public void finishedLoading(AssetManager manager, String fileName, Class type) {
            AssetDirectory.this.contents = (Index)manager.get(fileName, Index.class);
        }
    };

    public AssetDirectory(String directory) {
        this(directory, (FileHandleResolver)new InternalFileHandleResolver());
    }

    public AssetDirectory(String directory, FileHandleResolver resolver) {
        super(resolver, false);
        this.filename = directory;
        this.resolver = resolver;
        this.topLoader = new DirectoryLoader(resolver);
        this.setLoader(Index.class, (AssetLoader)this.topLoader);
        FreeTypeFontGeneratorLoader y = new FreeTypeFontGeneratorLoader(resolver);
        this.setLoader(FreeTypeFontGenerator.class, (AssetLoader)new FreeTypeFontGeneratorLoader(resolver));
        FreetypeFontLoader x = new FreetypeFontLoader(resolver);
        this.setLoader(BitmapFont.class, ".ttf", (AssetLoader)new FreetypeFontLoader(resolver));
        this.setLoader(AudioSource.class, (AssetLoader)new AudioSourceLoader(resolver));
        this.setLoader(Sound.class, (AssetLoader)new SoundLoader(resolver));
        this.setLoader(Music.class, (AssetLoader)new MusicLoader(resolver));
        this.setLoader(SoundEffect.class, (AssetLoader)new SoundEffectLoader(resolver));
        this.setLoader(MusicQueue.class, (AssetLoader)new MusicQueueLoader(resolver));
        this.setLoader(Pixmap.class, (AssetLoader)new PixmapLoader(resolver));
        this.setLoader(Texture.class, (AssetLoader)new TextureLoader(resolver));
        this.setLoader(TextureAtlas.class, (AssetLoader)new TextureAtlasLoader(resolver));
        this.setLoader(TextureRegion.class, (AssetLoader)new TextureRegionLoader(resolver));
        this.setLoader(SpriteSheet.class, (AssetLoader)new SpriteSheetLoader(resolver));
        this.setLoader(JsonValue.class, (AssetLoader)new JsonValueLoader(resolver));
        this.setLoader(WidgetValue.class, (AssetLoader)new WidgetValueLoader(resolver));
        this.setLoader(MaterialLib.class, (AssetLoader)new MaterialLibLoader(resolver));
        this.setLoader(Model.class, (AssetLoader)new ObjModelLoader(resolver));
        this.setLoader(Shader.class, (AssetLoader)new ShaderLoader(resolver));
        this.setLoader(Skin.class, (AssetLoader)new SkinLoader(resolver));
        this.setLoader(ParticleEffect.class, (AssetLoader)new ParticleEffectLoader(resolver));
        this.setLoader(PolygonRegion.class, (AssetLoader)new PolygonRegionLoader(resolver));
        this.topLoader.addParser(new ShaderParser());
        this.topLoader.addParser(new JsonValueParser());
        this.topLoader.addParser(new TextureParser());
        this.topLoader.addParser(new TextureRegionParser());
        this.topLoader.addParser(new SpriteSheetParser());
        this.topLoader.addParser(new FreetypeFontParser());
        this.topLoader.addParser(new SoundParser());
        this.topLoader.addParser(new MusicParser());
        this.topLoader.addParser(new SoundEffectParser());
        this.topLoader.addParser(new MusicQueueParser());
        this.topLoader.addParser(new AudioSourceParser());
        this.topLoader.addParser(new WidgetValueParser());
        this.topLoader.addParser(new ObjModelParser());
        this.topLoader.addParser(new MaterialLibParser());
        Texture2D.getBlank();
        this.progress = 0.0f;
    }

    public synchronized float getProgress() {
        float total = this.getLoadedAssets() + this.getQueuedAssets();
        float current = this.getLoadedAssets();
        if (current == 0.0f) {
            return 0.0f;
        }
        this.progress = Math.max(current / total, this.progress);
        return this.progress;
    }

    public String getDirectory() {
        return this.filename;
    }

    public void loadAssets() {
        DirectoryLoader.DirectoryLoaderParameters params = new DirectoryLoader.DirectoryLoaderParameters();
        params.loadedCallback = this.callback;
        this.progress = 0.0f;
        this.load(this.filename, Index.class, params);
    }

    public void unloadAssets() {
        if (this.contents == null) {
            return;
        }
        for (ObjectMap category : this.contents.keymap.values()) {
            for (String filename : category.values()) {
                this.unload(filename);
            }
        }
        this.contents = null;
    }

    public Array<AssetParser<?>> getParsers() {
        return this.topLoader.getParsers();
    }

    public void addParser(AssetParser<?> parser) {
        this.topLoader.addParser(parser);
    }

    public void removeParser(AssetParser<?> parser) {
        this.topLoader.removeParser(parser);
    }

    public <T> T getEntry(String key, Class<T> type) {
        ObjectMap keys = (ObjectMap)this.contents.keymap.get(type, null);
        if (keys == null) {
            return null;
        }
        String filename = (String)keys.get((Object)key, null);
        if (filename == null) {
            return null;
        }
        return (T)this.get(filename, type);
    }

    public <T> boolean hasEntry(String key, Class<T> type) {
        ObjectMap keys = (ObjectMap)this.contents.keymap.get(type, null);
        if (keys == null) {
            return false;
        }
        String filename = (String)keys.get((Object)key, null);
        if (filename == null) {
            return false;
        }
        return this.contains(filename, type);
    }

    public synchronized <T> void addEntry(String key, Class<T> type, T asset) {
        ObjectMap keys = (ObjectMap)this.contents.keymap.get(type, null);
        keys.put((Object)key, (Object)key);
        this.addAsset(key, type, asset);
    }

    public <T> String getFileName(String key, Class<T> type) {
        ObjectMap keys = (ObjectMap)this.contents.keymap.get(type, null);
        if (keys == null) {
            return null;
        }
        return (String)keys.get((Object)key, null);
    }

    public static class Index {
        ObjectMap<Class<?>, ObjectMap<String, String>> keymap = new ObjectMap();
        JsonValue directory;
    }
}

