//  2DTextureShader.vsh
//  Vertex shader to apply texture to a 2D shape. 
//  Supports projection and modelview matrices.
//
//  Created by Walker White on 5/22/12.
//  Copyright (c) 2012 Cornell University. All rights reserved.

// Inputs values
attribute vec4 position; 
attribute vec4 sourceColor; 

// Output color
varying vec4 destinationColor; 

// Matrices
uniform mat4 projection;
uniform mat4 modelview;

// Texture coordinates
attribute vec2 texCoordIn;  
varying   vec2 texCoordOut; 

void main(void) {
    destinationColor = sourceColor; 
    gl_Position = projection * modelview * position;
    texCoordOut = texCoordIn;
}