//  2DTextureShader.vsh
//  Fragment shader to apply texture to a 2D shape. 
//  Simply composites color and texture pixels.
//
//  Created by Walker White on 5/22/12.
//  Copyright (c) 2012 Cornell University. All rights reserved.

// Color result from vertex shader
varying vec4 destinationColor;

// Texture result from vertex shader
varying vec2 texCoordOut; 

// Texture map
uniform sampler2D texture; 
 
void main(void) {
    gl_FragColor = texture2D(texture, texCoordOut);
}