/*
 * Decompiled with CFR 0.152.
 */
package potential;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import potential.Constants;
import potential.DrawingContext;
import potential.Terrain;
import potential.Vector3d;

public class TerrainPanel
extends JPanel
implements Constants {
    public static final Color BACK_COLOR = new Color(0.9f, 0.9f, 0.6f);
    public static final Color FORE_COLOR = Color.black;
    private Terrain terrain;
    private DrawingContext context;
    private Rectangle window;
    private BufferedImage buffer;
    private Graphics2D graphics;
    private ComponentListener listener = new ComponentAdapter(){

        public void componentResized(ComponentEvent componentEvent) {
            TerrainPanel.this.window = componentEvent.getComponent().getBounds();
            TerrainPanel.this.createBuffer();
        }
    };

    public TerrainPanel() {
        this.context = new DrawingContext(20.0f);
        this.addComponentListener(this.listener);
        this.window = this.getBounds();
        this.createBuffer();
    }

    public void setTerrain(Terrain terrain) {
        this.terrain = terrain;
    }

    public Terrain getTerrain() {
        return this.terrain;
    }

    public void setScale(float f) {
        this.context.setScale(f);
    }

    public float getScale() {
        return this.context.getScale();
    }

    public DrawingContext getContext() {
        return this.context;
    }

    private void createBuffer() {
        if (this.buffer != null) {
            this.buffer.flush();
            this.buffer = null;
            this.graphics = null;
        }
        if (this.window.width != 0) {
            this.buffer = new BufferedImage(this.window.width, this.window.height, 2);
            this.graphics = (Graphics2D)this.buffer.getGraphics();
        }
        this.window.x = 0;
        this.window.y = 0;
        --this.window.width;
        --this.window.height;
    }

    public void paint(Graphics graphics) {
        if (this.graphics == null) {
            return;
        }
        this.graphics.setColor(BACK_COLOR);
        this.graphics.fill(this.window);
        if (this.terrain != null) {
            this.terrain.draw(this.graphics, this.context);
        }
        this.graphics.setColor(FORE_COLOR);
        this.graphics.draw(this.window);
        graphics.drawImage(this.buffer, 0, 0, this);
    }

    public Vector3d getPosition(Point point) {
        return this.getPosition(point.x, point.y);
    }

    public Vector3d getPosition(int n, int n2) {
        return new Vector3d((float)n / this.context.getScale(), (float)n2 / this.context.getScale(), 0.0f);
    }
}

