/*
 * Decompiled with CFR 0.152.
 */
package potential;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import potential.TabComponent;
import potential.TargetPanelController;
import potential.Vector3d;

public class TargetPanel
extends TabComponent {
    private TargetPanelController controller;
    JTextField xCoordinateField;
    JTextField yCoordinateField;
    JButton deleteButton;
    private JSlider attractionChargeSlider;
    private JSlider maximumAttractionSlider;
    private JSlider breakingDistanceSlider;

    public TargetPanel() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentX(0.0f);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 5));
        JLabel jLabel = new JLabel("Target Location: ");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setAlignmentX(0.0f);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.xCoordinateField = this.addField("x  ", 3, jPanel2);
        this.xCoordinateField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TargetPanel.this.controller != null) {
                    try {
                        float f = Float.valueOf(TargetPanel.this.xCoordinateField.getText()).floatValue();
                        TargetPanel.this.xCoordinateField.setText(String.format("%.2f", Float.valueOf(f)));
                        TargetPanel.this.recalculatePosition();
                    }
                    catch (NumberFormatException numberFormatException) {
                        Vector3d vector3d = TargetPanel.this.controller.getAttractionPosition();
                        TargetPanel.this.xCoordinateField.setText(vector3d == null ? "" : String.format("%.2f", Float.valueOf(vector3d.x)));
                    }
                }
            }
        });
        this.yCoordinateField = this.addField("y  ", 3, jPanel2);
        this.yCoordinateField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TargetPanel.this.controller != null) {
                    try {
                        float f = Float.valueOf(TargetPanel.this.yCoordinateField.getText()).floatValue();
                        TargetPanel.this.yCoordinateField.setText(String.format("%.2f", Float.valueOf(f)));
                        TargetPanel.this.recalculatePosition();
                    }
                    catch (NumberFormatException numberFormatException) {
                        Vector3d vector3d = TargetPanel.this.controller.getAttractionPosition();
                        TargetPanel.this.yCoordinateField.setText(vector3d == null ? "" : String.format("%.2f", Float.valueOf(vector3d.y)));
                    }
                }
            }
        });
        this.deleteButton = new JButton("Clear");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (TargetPanel.this.controller != null) {
                    TargetPanel.this.controller.setAttractionPosition(null);
                    TargetPanel.this.xCoordinateField.setText("");
                    TargetPanel.this.yCoordinateField.setText("");
                }
            }
        });
        jPanel2.add(this.deleteButton);
        jPanel.add(jLabel);
        jPanel.add(jPanel2);
        this.add((Component)jPanel, "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        this.attractionChargeSlider = this.addSlider("Target Charge: ", this.doubleToTick(0.25, 0.0, 1.0), jPanel3);
        this.attractionChargeSlider.setLabelTable(this.createLabels(0.0, 1.0));
        this.attractionChargeSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (TargetPanel.this.controller != null) {
                    TargetPanel.this.controller.setAttractionCharge(TargetPanel.this.tickToDouble(TargetPanel.this.attractionChargeSlider.getValue(), 0.0, 1.0));
                }
            }
        });
        this.maximumAttractionSlider = this.addSlider("Maximum Attraction Factor: ", this.doubleToTick(0.36787944117144233, 0.0, 1.0), jPanel3);
        this.maximumAttractionSlider.setLabelTable(this.createLabels(0.0, 1.0));
        this.maximumAttractionSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (TargetPanel.this.controller != null) {
                    TargetPanel.this.controller.setAttractionMaximum(TargetPanel.this.tickToDouble(TargetPanel.this.maximumAttractionSlider.getValue(), 0.0, 1.0));
                }
            }
        });
        this.breakingDistanceSlider = this.addSlider("Breaking Distance: ", this.doubleToTick(2.0, 0.0, 5.0), jPanel3);
        this.breakingDistanceSlider.setLabelTable(this.createLabels(0.0, 5.0));
        this.breakingDistanceSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (TargetPanel.this.controller != null) {
                    TargetPanel.this.controller.setAttractionBreaking(TargetPanel.this.tickToDouble(TargetPanel.this.breakingDistanceSlider.getValue(), 0.0, 5.0));
                }
            }
        });
        this.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        JTextArea jTextArea = this.addArea("Instructions: ", 8, 10, jPanel4);
        jTextArea.setText("To create an attractive charge, either\nenter an x and y coordinate above, or\nclick within the panel to the left.\nUse the sliders to adjust the values\nof the attractive charge.\n\nThere is no more than one attractive\nforce at a time.");
        jTextArea.setEditable(false);
        jTextArea.setEnabled(false);
        jTextArea.setDisabledTextColor(Color.black);
        this.add((Component)jPanel4, "South");
    }

    public void update() {
        if (this.controller != null) {
            this.attractionChargeSlider.setValue(this.doubleToTick(this.controller.getAttractionCharge(), 0.0, 1.0));
            this.maximumAttractionSlider.setValue(this.doubleToTick(this.controller.getAttractionMaximum(), 0.0, 1.0));
            this.breakingDistanceSlider.setValue(this.doubleToTick(this.controller.getAttractionBreaking(), 0.0, 5.0));
            Vector3d vector3d = this.controller.getAttractionPosition();
            if (vector3d == null) {
                this.xCoordinateField.setText("");
                this.yCoordinateField.setText("");
            } else {
                this.xCoordinateField.setText(String.format("%.2f", Float.valueOf(vector3d.x)));
                this.yCoordinateField.setText(String.format("%.2f", Float.valueOf(vector3d.y)));
            }
        }
    }

    public void setController(TargetPanelController targetPanelController) {
        this.controller = targetPanelController;
        this.update();
    }

    public TargetPanelController getController() {
        return this.controller;
    }

    private void recalculatePosition() {
        try {
            float f = Float.valueOf(this.xCoordinateField.getText()).floatValue();
            float f2 = Float.valueOf(this.yCoordinateField.getText()).floatValue();
            this.controller.setAttractionPosition(new Vector3d(f, f2, 0.0f));
        }
        catch (NumberFormatException numberFormatException) {
            this.controller.setAttractionPosition(null);
        }
    }
}

