/*
 * Decompiled with CFR 0.152.
 */
package potential;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import potential.SettingsPanelController;
import potential.TabComponent;

public class SettingsPanel
extends TabComponent {
    private SettingsPanelController controller;
    private JRadioButton resumeButton;
    private JRadioButton pauseButton;
    private JSlider animationSpeedSlider;
    private JSlider drawingScaleSlider;
    private JSlider avoidCoefficientSlider;
    private JSlider avoidSeparationSlider;
    private JSlider avoidEpsilonSlider;

    public SettingsPanel() {
        this.setLayout(new BorderLayout());
        this.resumeButton = new JRadioButton("Resume");
        this.resumeButton.setMnemonic(82);
        this.resumeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SettingsPanel.this.controller != null) {
                    SettingsPanel.this.controller.setAnimated(true);
                }
            }
        });
        this.pauseButton = new JRadioButton("Pause");
        this.pauseButton.setMnemonic(80);
        this.pauseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SettingsPanel.this.controller != null) {
                    SettingsPanel.this.controller.setAnimated(false);
                }
            }
        });
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.resumeButton);
        buttonGroup.add(this.pauseButton);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentX(0.0f);
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel2.add(this.resumeButton);
        jPanel3.add(this.pauseButton);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)jPanel, "North");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        this.animationSpeedSlider = this.addSlider("Frames Per Second: ", this.doubleToTick(25.0, 0.0, 100.0), jPanel4);
        this.animationSpeedSlider.setLabelTable(this.createLabels(0.0, 100.0));
        this.animationSpeedSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (SettingsPanel.this.controller != null) {
                    SettingsPanel.this.controller.setFrameRate(SettingsPanel.this.tickToDouble(SettingsPanel.this.animationSpeedSlider.getValue(), 0.0, 100.0));
                }
            }
        });
        this.drawingScaleSlider = this.addSlider("Drawing Scale: ", this.floatToTick(20.0f, 0.0f, 50.0f), jPanel4);
        this.drawingScaleSlider.setLabelTable(this.createLabels(0.0f, 50.0f));
        this.drawingScaleSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (SettingsPanel.this.controller != null) {
                    SettingsPanel.this.controller.setDrawingScale(SettingsPanel.this.tickToFloat(SettingsPanel.this.drawingScaleSlider.getValue(), 0.0f, 50.0f));
                }
            }
        });
        this.avoidCoefficientSlider = this.addSlider("Avoidance Coefficient: ", this.doubleToTick(0.1, 0.0, 1.0), jPanel4);
        this.avoidCoefficientSlider.setLabelTable(this.createLabels(0.0, 1.0));
        this.avoidCoefficientSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (SettingsPanel.this.controller != null) {
                    SettingsPanel.this.controller.setAvoidanceCoefficient(SettingsPanel.this.tickToDouble(SettingsPanel.this.avoidCoefficientSlider.getValue(), 0.0, 1.0));
                }
            }
        });
        this.avoidSeparationSlider = this.addSlider("Avoidance Separation: ", this.doubleToTick(0.95, 0.0, 1.0), jPanel4);
        this.avoidSeparationSlider.setLabelTable(this.createLabels(0.0, 1.0));
        this.avoidSeparationSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (SettingsPanel.this.controller != null) {
                    SettingsPanel.this.controller.setAvoidanceSeparation(SettingsPanel.this.tickToDouble(SettingsPanel.this.avoidSeparationSlider.getValue(), 0.0, 1.0));
                }
            }
        });
        this.avoidEpsilonSlider = this.addSlider("Avoidance Epsilon: ", this.doubleToTick(-64.0, -127.0, -1.0), jPanel4);
        this.avoidEpsilonSlider.setLabelTable(this.createLabels((byte)-127, (byte)-1, "e", ""));
        this.avoidEpsilonSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (SettingsPanel.this.controller != null) {
                    SettingsPanel.this.controller.setAvoidanceEpsilon(SettingsPanel.this.tickToByte(SettingsPanel.this.avoidEpsilonSlider.getValue(), -127, -1));
                }
            }
        });
        this.add((Component)jPanel4, "Center");
    }

    public void update() {
        if (this.controller != null) {
            this.animationSpeedSlider.setValue(this.doubleToTick(this.controller.getFrameRate(), 0.0, 100.0));
            this.drawingScaleSlider.setValue(this.doubleToTick(this.controller.getDrawingScale(), 0.0, 50.0));
            this.avoidCoefficientSlider.setValue(this.doubleToTick(this.controller.getAvoidanceCoefficient(), 0.0, 1.0));
            this.avoidSeparationSlider.setValue(this.doubleToTick(this.controller.getAvoidanceSeparation(), 0.0, 1.0));
            this.avoidEpsilonSlider.setValue(this.byteToTick(this.controller.getAvoidanceEpsilon(), (byte)-127, (byte)-1));
            if (this.controller.isAnimated()) {
                this.resumeButton.setSelected(true);
            } else {
                this.pauseButton.setSelected(true);
            }
        }
    }

    public void setController(SettingsPanelController settingsPanelController) {
        this.controller = settingsPanelController;
        this.update();
    }

    public SettingsPanelController getController() {
        return this.controller;
    }
}

