/*
 * Decompiled with CFR 0.152.
 */
package potential;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import potential.Vector3d;

public class DrawingContext {
    private BasicStroke stroke = new BasicStroke(1.0f);
    private float scale;
    private Vector3d vectorCache = new Vector3d();
    private Line2D.Float lineCache = new Line2D.Float();
    private Ellipse2D.Float ovalCache = new Ellipse2D.Float();
    private Rectangle2D.Float rectCache = new Rectangle2D.Float();
    private RoundRectangle2D.Float roundCache = new RoundRectangle2D.Float();
    private int[] xCache = new int[4];
    private int[] yCache = new int[4];
    private boolean toggle = false;

    public DrawingContext() {
        this(1.0f);
    }

    public DrawingContext(float f) {
        this.scale = f;
    }

    public void setScale(float f) {
        this.scale = f;
    }

    public float getScale() {
        return this.scale;
    }

    public void setWeight(float f) {
        this.stroke = new BasicStroke(f);
    }

    public float getWeight() {
        return this.stroke.getLineWidth();
    }

    public void setToggle(boolean bl) {
        this.toggle = bl;
    }

    public boolean getToggle() {
        return this.toggle;
    }

    public void print(String string) {
        if (this.toggle) {
            System.out.print(string);
        }
    }

    public void println(String string) {
        if (this.toggle) {
            System.out.println(string);
        }
    }

    public void drawVector(Graphics2D graphics2D, Vector3d vector3d, Vector3d vector3d2, float f, Color color) {
        this.vectorCache.setScale(f, vector3d);
        this.vectorCache.setSum(vector3d2, this.vectorCache);
        this.drawLine(graphics2D, vector3d2, this.vectorCache, color);
    }

    public void drawLine(Graphics2D graphics2D, Vector3d vector3d, Vector3d vector3d2, Color color) {
        this.lineCache.setLine(this.scale * vector3d.x, this.scale * vector3d.y, this.scale * vector3d2.x, this.scale * vector3d2.y);
        graphics2D.setColor(color);
        graphics2D.draw(this.lineCache);
    }

    public void drawWideLine(Graphics2D graphics2D, Vector3d vector3d, Vector3d vector3d2, Color color, float f) {
        this.vectorCache.setDifference(vector3d, vector3d2);
        this.vectorCache.setNormalized();
        float f2 = -this.vectorCache.x;
        this.vectorCache.x = this.vectorCache.y;
        this.vectorCache.y = f2;
        this.vectorCache.setScale(f / 2.0f, this.vectorCache);
        this.xCache[0] = (int)(this.scale * (vector3d.x + this.vectorCache.x) + 0.5f);
        this.xCache[1] = (int)(this.scale * (vector3d.x - this.vectorCache.x) + 0.5f);
        this.xCache[2] = (int)(this.scale * (vector3d2.x - this.vectorCache.x) + 0.5f);
        this.xCache[3] = (int)(this.scale * (vector3d2.x + this.vectorCache.x) + 0.5f);
        this.yCache[0] = (int)(this.scale * (vector3d.y + this.vectorCache.y) + 0.5f);
        this.yCache[1] = (int)(this.scale * (vector3d.y - this.vectorCache.y) + 0.5f);
        this.yCache[2] = (int)(this.scale * (vector3d2.y - this.vectorCache.y) + 0.5f);
        this.yCache[3] = (int)(this.scale * (vector3d2.y + this.vectorCache.y) + 0.5f);
        graphics2D.setColor(color);
        graphics2D.setStroke(this.stroke);
        graphics2D.fillPolygon(this.xCache, this.yCache, 4);
    }

    public void drawCircle(Graphics2D graphics2D, Vector3d vector3d, float f, Color color) {
        float f2 = this.scale * f;
        graphics2D.setColor(color);
        graphics2D.setStroke(this.stroke);
        this.ovalCache.setFrame(this.scale * vector3d.x - f2, this.scale * vector3d.y - f2, f2 * 2.0f, f2 * 2.0f);
        graphics2D.draw(this.ovalCache);
    }

    public void fillCircle(Graphics2D graphics2D, Vector3d vector3d, float f, Color color) {
        float f2 = this.scale * f;
        graphics2D.setColor(color);
        graphics2D.setStroke(this.stroke);
        this.ovalCache.setFrame(this.scale * vector3d.x - f2, this.scale * vector3d.y - f2, f2 * 2.0f, f2 * 2.0f);
        graphics2D.fill(this.ovalCache);
    }

    public void outlineCircle(Graphics2D graphics2D, Vector3d vector3d, float f, Color color, Color color2) {
        float f2 = this.scale * f;
        this.ovalCache.setFrame(this.scale * vector3d.x - f2, this.scale * vector3d.y - f2, f2 * 2.0f, f2 * 2.0f);
        graphics2D.setStroke(this.stroke);
        graphics2D.setColor(color);
        graphics2D.fill(this.ovalCache);
        graphics2D.setColor(color2);
        graphics2D.draw(this.ovalCache);
    }

    public void drawTarget(Graphics2D graphics2D, Vector3d vector3d, Color color) {
        float f = 0.5f * this.scale;
        float f2 = this.scale * vector3d.x;
        float f3 = this.scale * vector3d.y;
        graphics2D.setColor(color);
        graphics2D.setStroke(this.stroke);
        this.ovalCache.setFrame(f2 - f, f3 - f, this.scale, this.scale);
        graphics2D.draw(this.ovalCache);
        this.lineCache.setLine(f2 + this.scale, f3, f2 - this.scale, f3);
        graphics2D.draw(this.lineCache);
        this.lineCache.setLine(f2, f3 + this.scale, f2, f3 - this.scale);
        graphics2D.draw(this.lineCache);
    }

    private void setRect(float f, float f2, float f3, float f4) {
        float f5;
        float f6;
        if (f < f3) {
            f6 = f;
            f5 = f3;
        } else {
            f6 = f3;
            f5 = f;
        }
        if (f2 < f4) {
            this.rectCache.setFrame(this.scale * f6, this.scale * f2, this.scale * (f5 - f6), this.scale * (f4 - f2));
        } else {
            this.rectCache.setFrame(this.scale * f6, this.scale * f4, this.scale * (f5 - f6), this.scale * (f2 - f4));
        }
    }

    public void drawRect(Graphics2D graphics2D, float f, float f2, float f3, float f4, Color color) {
        this.setRect(f, f2, f3, f4);
        graphics2D.setColor(color);
        graphics2D.setStroke(this.stroke);
        graphics2D.draw(this.rectCache);
    }

    public void fillRect(Graphics2D graphics2D, float f, float f2, float f3, float f4, Color color) {
        this.setRect(f, f2, f3, f4);
        graphics2D.setColor(color);
        graphics2D.setStroke(this.stroke);
        graphics2D.fill(this.rectCache);
    }

    public void outlineRect(Graphics2D graphics2D, float f, float f2, float f3, float f4, Color color, Color color2) {
        this.setRect(f, f2, f3, f4);
        graphics2D.setStroke(this.stroke);
        graphics2D.setColor(color);
        graphics2D.fill(this.rectCache);
        graphics2D.setColor(color2);
        graphics2D.draw(this.rectCache);
    }

    private void setRoundRect(float f, float f2, float f3, float f4, float f5) {
        float f6;
        float f7;
        if (f < f3) {
            f7 = f;
            f6 = f3;
        } else {
            f7 = f3;
            f6 = f;
        }
        if (f2 < f4) {
            this.roundCache.setRoundRect(this.scale * f7, this.scale * f2, this.scale * (f6 - f7), this.scale * (f4 - f2), this.scale * f5 * 2.0f, this.scale * f5 * 2.0f);
        } else {
            this.roundCache.setRoundRect(this.scale * f7, this.scale * f4, this.scale * (f6 - f7), this.scale * (f2 - f4), this.scale * f5 * 2.0f, this.scale * f5 * 2.0f);
        }
    }

    public void drawRoundRect(Graphics2D graphics2D, float f, float f2, float f3, float f4, float f5, Color color) {
        this.setRoundRect(f, f2, f3, f4, f5);
        graphics2D.setColor(color);
        graphics2D.setStroke(this.stroke);
        graphics2D.draw(this.roundCache);
    }

    public void fillRoundRect(Graphics2D graphics2D, float f, float f2, float f3, float f4, float f5, Color color) {
        this.setRoundRect(f, f2, f3, f4, f5);
        graphics2D.setColor(color);
        graphics2D.setStroke(this.stroke);
        graphics2D.fill(this.roundCache);
    }

    public void outlineRoundRect(Graphics2D graphics2D, float f, float f2, float f3, float f4, float f5, Color color, Color color2) {
        this.setRoundRect(f, f2, f3, f4, f5);
        graphics2D.setStroke(this.stroke);
        graphics2D.setColor(color);
        graphics2D.fill(this.roundCache);
        graphics2D.setColor(color2);
        graphics2D.draw(this.roundCache);
    }
}

