/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.bezier;

public class RootSolver {
    static final int MAX_ITERATIONS = 50;
    static final int MAX_ATTEMPTS = 10;

    public static void divide(float[] numerator, int noffset, int nlength, float[] result, int roffset, float[] denominator, int doffset, int dlength) {
        for (int ii = 0; ii < nlength; ++ii) {
            result[roffset + ii] = numerator[noffset + ii];
            for (int jj = 0; jj <= ii && jj < dlength; ++jj) {
                int n = roffset + ii;
                result[n] = result[n] - denominator[doffset + jj] * (ii == jj ? 1.0f : result[roffset + (ii - jj - 1)]);
            }
        }
    }

    public static boolean inRange(float x, float epsilon) {
        return x < epsilon && -x < epsilon;
    }

    public static boolean bairstowFactor(float[] poly, int poffset, int plength, float[] result, int roffset, float[] quad, int qoffset, float epsilon) {
        float[] temp = new float[plength - 1];
        float dp = 2.0f * epsilon;
        float dq = 2.0f * epsilon;
        for (int ii = 0; ii < 50; ++ii) {
            RootSolver.divide(poly, poffset, plength, result, roffset, quad, qoffset, 2);
            RootSolver.divide(result, roffset, plength - 1, temp, 0, quad, qoffset, 2);
            float b5 = result[roffset + plength - 1];
            float b4 = result[roffset + plength - 2];
            float b3 = result[roffset + plength - 3];
            float c4 = temp[plength - 2];
            float c3 = temp[plength - 3];
            float c2 = plength > 3 ? temp[plength - 4] : 1.0f;
            dp = -(b5 * c2 - b4 * c3) / (c3 * c3 - c2 * (c4 - b4));
            dq = -(b4 * (c4 - b4) - b5 * c3) / (c3 * c3 - c2 * (c4 - b4));
            if (RootSolver.inRange(dp, epsilon) && RootSolver.inRange(dq, epsilon)) break;
            quad[0] = quad[0] + dp;
            quad[1] = quad[1] + dq;
        }
        return RootSolver.inRange(dp, epsilon) && RootSolver.inRange(dq, epsilon);
    }

    public static void solveRoots(float[] poly, int poffset, int plength, float[] roots, int roffset, float epsilon) {
        int degree = plength;
        int rmark = roffset;
        float[] result1 = new float[degree];
        float[] result2 = new float[degree];
        float[] quad = new float[2];
        System.arraycopy(poly, poffset, result1, 0, degree);
        int attempts = 0;
        while (degree > 2) {
            float a = (float)Math.random();
            float b = (float)Math.random();
            quad[0] = -a - b;
            quad[1] = a * b;
            if (RootSolver.bairstowFactor(result1, 0, degree, result2, 0, quad, 0, epsilon) || attempts >= 10) {
                RootSolver.solveQuadratic(quad, 0, roots, rmark);
                rmark += 2;
                attempts = 0;
                System.arraycopy(result2, 0, result1, 0, degree -= 2);
                continue;
            }
            ++attempts;
        }
        if (degree == 2) {
            RootSolver.solveQuadratic(result1, 0, roots, rmark);
        } else if (degree == 1) {
            roots[rmark] = -result1[0];
        }
    }

    public static void solveQuadratic(float[] quad, int qoffset, float[] roots, int roffset) {
        float det = quad[qoffset] * quad[qoffset] - 4.0f * quad[qoffset + 1];
        if (det < 0.0f) {
            roots[roffset] = Float.NaN;
            roots[roffset + 1] = Float.NaN;
        } else {
            det = (float)Math.sqrt(det);
            roots[roffset] = (-quad[qoffset] + det) / 2.0f;
            roots[roffset + 1] = (-quad[qoffset] - det) / 2.0f;
        }
    }

    public static void printPoly(float[] poly, int offset, int length) {
        if (length > 1) {
            System.out.print("x^" + length);
        } else if (length > 0) {
            System.out.print("x");
        } else {
            System.out.print("1");
        }
        for (int ii = 0; ii < length; ++ii) {
            if (poly[offset + ii] > 0.0f) {
                System.out.print("+");
            }
            System.out.print(poly[offset + ii]);
            if (ii < length - 2) {
                System.out.print("x^");
                System.out.print(length - ii - 1);
                continue;
            }
            if (ii >= length - 1) continue;
            System.out.print("x");
        }
    }

    public static void printArray(float[] poly, int offset, int length) {
        System.out.print("{");
        for (int ii = 0; ii < length; ++ii) {
            System.out.print(poly[offset + ii]);
            if (ii >= length - 1) continue;
            System.out.print(", ");
        }
        System.out.print("}");
    }

    public static void main(String[] args) {
        float[] numerator = new float[]{1.0f, -1.0f, 2.0f};
        float[] denominator = new float[]{-1.0f, 1.0f};
        float[] result = new float[3];
        RootSolver.printPoly(numerator, 0, 3);
        System.out.print("/");
        RootSolver.printPoly(denominator, 0, 2);
        System.out.print("=");
        RootSolver.divide(numerator, 0, 3, result, 0, denominator, 0, 2);
        RootSolver.printPoly(result, 0, 1);
        System.out.println();
        RootSolver.printArray(result, 0, 3);
        System.out.println();
        float[] attempt = new float[]{-0.5f, 0.0f};
        RootSolver.bairstowFactor(numerator, 0, 3, result, 0, attempt, 0, 0.001f);
        RootSolver.printPoly(result, 0, 1);
        System.out.println();
        RootSolver.printArray(result, 0, 3);
        System.out.println();
        System.out.print("Solution to ");
        RootSolver.printPoly(denominator, 0, 2);
        System.out.print(" is ");
        RootSolver.solveQuadratic(denominator, 0, result, 0);
        RootSolver.printArray(result, 0, 2);
        System.out.println();
        denominator[0] = 2.0f;
        denominator[1] = 1.0f;
        System.out.print("Solution to ");
        RootSolver.printPoly(denominator, 0, 2);
        System.out.print(" is ");
        RootSolver.solveQuadratic(denominator, 0, result, 0);
        RootSolver.printArray(result, 0, 2);
        System.out.println();
        float[] complex = new float[]{-3.0f, 3.0f, -3.0f, 1.0f};
        float[] roots = new float[5];
        RootSolver.solveRoots(complex, 0, 4, roots, 0, 1.0E-4f);
        RootSolver.printArray(roots, 0, 5);
        System.out.println();
    }
}

