/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.bezier;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Mesh;
import edu.cornell.gdiac.g2d.ColorShader;

public class GLQuad {
    public float x = 60.0f;
    public float y = 20.0f;
    private float[] vertices;
    private short[] indices;
    ColorShader shader;
    Mesh mesh;
    private static final float RADIUS = 10.0f;

    public GLQuad(ColorShader shader) {
        this.shader = shader;
        this.mesh = shader.createMesh(4, 6);
        this.vertices = new float[12];
        Color blue = new Color(0.0f, 0.0f, 1.0f, 1.0f);
        for (int ii = 0; ii < 4; ++ii) {
            this.vertices[3 * ii + 0] = 0.0f;
            this.vertices[3 * ii + 1] = 0.0f;
            this.vertices[3 * ii + 2] = blue.toFloatBits();
        }
        this.indices = new short[6];
        this.indices[0] = 0;
        this.indices[1] = 1;
        this.indices[2] = 2;
        this.indices[3] = 2;
        this.indices[4] = 1;
        this.indices[5] = 3;
        this.recalculate();
    }

    private void recalculate() {
        this.vertices[0] = this.x - 10.0f;
        this.vertices[1] = this.y - 10.0f;
        this.vertices[3] = this.x + 10.0f;
        this.vertices[4] = this.y - 10.0f;
        this.vertices[6] = this.x - 10.0f;
        this.vertices[7] = this.y + 10.0f;
        this.vertices[9] = this.x + 10.0f;
        this.vertices[10] = this.y + 10.0f;
    }

    public void translate(float dx, float dy) {
        this.x += dx;
        this.y += dy;
        this.recalculate();
    }

    public void draw() {
        this.mesh.setVertices(this.vertices);
        this.mesh.setIndices(this.indices);
        this.mesh.render(this.shader, 4, 0, 6);
    }
}

