/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.bezier;

import com.badlogic.gdx.graphics.Mesh;
import edu.cornell.gdiac.bezier.Spline;
import edu.cornell.gdiac.g2d.UniformShader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class GLBezier
extends Spline {
    private FloatBuffer vertexBuffer;
    private FloatBuffer normalBuffer;
    private FloatBuffer shadowBuffer;
    private FloatBuffer penumbraBuffer;
    private Mesh splineMesh;
    private Mesh normalMesh;
    private Mesh handleMesh;
    private Mesh shadowMesh;
    private Mesh penumbMesh;
    private float[] splineVertices;
    private short[] splineIndices;
    private float[] normalVertices;
    private short[] normalIndices;
    private float[] handleVertices;
    private short[] handleIndices;
    private float[] shadowVertices;
    private short[] shadowIndices;
    private float[] penumbVertices;
    private short[] penumbIndices;
    private float[] color;
    private int count;
    private int psize;
    private UniformShader shader;

    public GLBezier(UniformShader shader) {
        super(new float[]{20.0f, 20.0f, 20.0f, 140.0f, 100.0f, 220.0f, 220.0f, 220.0f, 340.0f, 220.0f, 420.0f, 140.0f, 420.0f, 20.0f}, 0, 14);
        this.smooth[1] = true;
        this.color = new float[]{1.0f, 0.0f, 0.0f, 1.0f};
        this.shader = shader;
        this.recalculate();
    }

    public static FloatBuffer makeFloatBuffer(int size) {
        ByteBuffer bb = ByteBuffer.allocateDirect(size * 4);
        bb.order(ByteOrder.nativeOrder());
        return bb.asFloatBuffer();
    }

    private void recalculate() {
        int ii;
        int ii2;
        this.count = this.countPoints();
        this.vertexBuffer = GLBezier.makeFloatBuffer(this.count * 4);
        this.generateVertices(this.vertexBuffer, 5.0f);
        this.splineVertices = new float[this.count * 4];
        this.vertexBuffer.get(this.splineVertices, 0, this.splineVertices.length);
        this.splineIndices = new short[this.count * 2];
        for (ii2 = 0; ii2 < 2 * this.count; ++ii2) {
            this.splineIndices[ii2] = (short)ii2;
        }
        this.splineMesh = this.shader.createMesh(this.count * 4, this.count * 2);
        this.splineMesh.setVertices(this.splineVertices);
        this.splineMesh.setIndices(this.splineIndices);
        this.normalBuffer = GLBezier.makeFloatBuffer(this.count * 4);
        this.generateNormals(this.normalBuffer, 20.0f);
        this.normalVertices = new float[this.count * 4];
        this.normalBuffer.get(this.normalVertices, 0, this.normalVertices.length);
        this.normalIndices = new short[this.count * 2];
        for (ii2 = 0; ii2 < 2 * this.count; ++ii2) {
            this.normalIndices[ii2] = (short)ii2;
        }
        this.normalMesh = this.shader.createMesh(this.count * 4, this.count * 2);
        this.normalMesh.setVertices(this.normalVertices);
        this.normalMesh.setIndices(this.normalIndices);
        this.psize = 6 * this.size + 2;
        float radius = 5.0f;
        this.handleVertices = new float[this.psize * 8];
        this.handleIndices = new short[this.psize * 6];
        for (ii = 0; ii < this.psize; ii += 2) {
            this.handleVertices[4 * ii + 0] = this.points[ii + 0] - radius;
            this.handleVertices[4 * ii + 1] = this.points[ii + 1] - radius;
            this.handleVertices[4 * ii + 2] = this.points[ii + 0] - radius;
            this.handleVertices[4 * ii + 3] = this.points[ii + 1] + radius;
            this.handleVertices[4 * ii + 4] = this.points[ii + 0] + radius;
            this.handleVertices[4 * ii + 5] = this.points[ii + 1] + radius;
            this.handleVertices[4 * ii + 6] = this.points[ii + 0] + radius;
            this.handleVertices[4 * ii + 7] = this.points[ii + 1] - radius;
            this.handleIndices[3 * ii + 0] = (short)(4 * ii + 0);
            this.handleIndices[3 * ii + 1] = (short)(4 * ii + 1);
            this.handleIndices[3 * ii + 2] = (short)(4 * ii + 2);
            this.handleIndices[3 * ii + 3] = (short)(4 * ii + 2);
            this.handleIndices[3 * ii + 4] = (short)(4 * ii + 3);
            this.handleIndices[3 * ii + 5] = (short)(4 * ii + 0);
        }
        this.handleMesh = this.shader.createMesh(this.psize * 8, this.psize * 6);
        this.handleMesh.setVertices(this.handleVertices);
        this.handleMesh.setIndices(this.handleIndices);
        this.shadowBuffer = GLBezier.makeFloatBuffer(this.count * 4);
        this.shadowBuffer.position(0);
        this.shadowVertices = new float[this.count * 4];
        this.shadowIndices = new short[this.count * 4];
        for (ii = 0; ii < this.count * 4; ++ii) {
            this.shadowIndices[ii] = (short)ii;
        }
        this.shadowMesh = this.shader.createMesh(this.count * 4, this.count * 4);
        this.shadowMesh.setIndices(this.shadowIndices);
        this.shadowMesh.setVertices(this.shadowVertices);
        this.penumbraBuffer = GLBezier.makeFloatBuffer(this.count * 6);
        this.penumbVertices = new float[this.count * 6];
        this.penumbIndices = new short[this.count * 6];
        for (ii = 0; ii < this.count * 6; ++ii) {
            this.penumbIndices[ii] = (short)ii;
        }
        this.penumbMesh = this.shader.createMesh(this.count * 6, this.count * 6);
        this.penumbMesh.setIndices(this.penumbIndices);
        this.penumbMesh.setVertices(this.penumbVertices);
    }

    public void draw() {
        this.shader.setColor(new float[]{0.0f, 0.0f, 0.0f, 1.0f});
        this.normalMesh.render(this.shader, 1, 0, this.count * 2);
        this.shader.setColor(this.color);
        this.splineMesh.render(this.shader, 5, 0, this.count * 2);
        this.shader.setColor(new float[]{0.0f, 1.0f, 1.0f, 1.0f});
        this.handleMesh.render(this.shader, 4, 0, this.psize * 3);
    }

    public void drawShadow(float x, float y) {
        this.generatePenumbra(this.penumbraBuffer, x, y, 10.0f, 800.0f);
        this.generateShadow(this.shadowBuffer, x, y, 800.0f);
        this.shader.setColor(new float[]{0.0f, 1.0f, 1.0f, 1.0f});
        this.penumbraBuffer.get(this.penumbVertices, 0, this.penumbVertices.length);
        this.penumbraBuffer.position(0);
        this.penumbMesh.setVertices(this.penumbVertices);
        this.penumbMesh.render(this.shader, 4, 0, this.count * 3);
        this.shader.setColor(new float[]{0.0f, 0.0f, 0.0f, 1.0f});
        this.shadowBuffer.get(this.shadowVertices, 0, this.shadowVertices.length);
        this.shadowBuffer.position(0);
        this.shadowMesh.setVertices(this.shadowVertices);
        this.shadowMesh.render(this.shader, 5, 0, this.count * 2);
    }

    @Override
    public int addAnchor(float px, float py) {
        int result = super.addAnchor(px, py, px, py);
        this.recalculate();
        return result;
    }

    @Override
    public int addAnchor(float px, float py, float tx, float ty) {
        int result = super.addAnchor(px, py, tx, ty);
        this.recalculate();
        return result;
    }

    @Override
    public void deleteAnchor(int index) {
        super.deleteAnchor(index);
        this.recalculate();
    }

    @Override
    public void insertAnchor(float param) {
        super.insertAnchor(param);
        this.recalculate();
    }

    @Override
    public void setAnchor(int index, float px, float py) {
        super.setAnchor(index, px, py);
        this.recalculate();
    }

    @Override
    public void setTangent(int index, float tx, float ty, boolean symmetric) {
        super.setTangent(index, tx, ty, symmetric);
        this.recalculate();
    }
}

