/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.bezier;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.math.Matrix4;
import edu.cornell.gdiac.bezier.GLBezier;
import edu.cornell.gdiac.bezier.GLQuad;
import edu.cornell.gdiac.g2d.ColorShader;
import edu.cornell.gdiac.g2d.UniformShader;

public class GDXRoot
extends ApplicationAdapter
implements InputProcessor {
    ColorShader colorShader;
    UniformShader uniformShader;
    GLBezier bezier;
    GLQuad block;
    Mesh mouseLine;
    float[] lineVertices;
    short[] lineIndices;
    Matrix4 projection;
    Matrix4 modelview;
    public static final float STEP = 4.0f;
    float height;
    float dx = 0.0f;
    float dy = 0.0f;
    boolean isAnchor = false;
    int index = -1;
    boolean active = false;
    boolean altDown = false;
    boolean metaDown = false;

    @Override
    public void create() {
        this.colorShader = new ColorShader();
        this.uniformShader = new UniformShader();
        this.bezier = new GLBezier(this.uniformShader);
        this.block = new GLQuad(this.colorShader);
        this.lineVertices = new float[4];
        this.lineIndices = new short[2];
        this.lineIndices[0] = 0;
        this.lineIndices[1] = 1;
        this.mouseLine = this.uniformShader.createMesh(4, 2);
        this.modelview = new Matrix4();
        this.projection = new Matrix4();
        Gdx.gl.glDisable(2884);
        Gdx.gl.glEnable(3042);
        Gdx.gl.glClearColor(0.8f, 0.8f, 0.5f, 1.0f);
        Gdx.gl.glClearStencil(0);
        Gdx.gl.glClearDepthf(1.0f);
        Gdx.gl.glDepthFunc(515);
        Gdx.gl.glBlendFunc(1, 771);
        Gdx.input.setInputProcessor(this);
    }

    @Override
    public void render() {
        this.update();
        this.draw();
    }

    @Override
    public void resize(int width, int height) {
        this.height = height;
        this.projection.setToOrtho2D(0.0f, 0.0f, width, height, -10.0f, 10.0f);
    }

    @Override
    public void dispose() {
        this.colorShader.dispose();
        this.uniformShader.dispose();
    }

    public void update() {
        this.block.translate(this.dx, this.dy);
    }

    public void draw() {
        Gdx.gl.glClearColor(0.8f, 0.8f, 0.5f, 1.0f);
        Gdx.gl.glClear(0x4500 | (Gdx.graphics.getBufferFormat().coverageSampling ? 32768 : 0));
        this.uniformShader.begin();
        this.uniformShader.setModelview(this.modelview);
        this.uniformShader.setProjection(this.projection);
        this.bezier.draw();
        if (this.active) {
            this.uniformShader.setColor(new float[]{0.0f, 0.5f, 0.0f, 1.0f});
            this.mouseLine.render(this.uniformShader, 1, 0, 2);
        }
        this.bezier.drawShadow(this.block.x, this.block.y);
        this.uniformShader.end();
        this.colorShader.begin();
        this.colorShader.setModelview(this.modelview);
        this.colorShader.setProjection(this.projection);
        this.block.draw();
        this.colorShader.end();
    }

    private void recalculateLine(float x, float y) {
        float p1 = this.bezier.getProjection(x, y);
        this.bezier.getPoint(p1, this.lineVertices, 0);
        this.lineVertices[2] = x;
        this.lineVertices[3] = y;
        this.mouseLine.setVertices(this.lineVertices);
        this.mouseLine.setIndices(this.lineIndices);
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        if (this.altDown) {
            float param = this.bezier.getProjection(screenX, this.height - (float)screenY);
            if (param != (float)((int)param)) {
                this.bezier.insertAnchor(param);
            }
        } else if (this.metaDown) {
            this.active = true;
            this.recalculateLine(screenX, this.height - (float)screenY);
        } else {
            this.isAnchor = true;
            this.index = this.bezier.nearestAnchor(screenX, this.height - (float)screenY, 25.0f);
            if (this.index == -1) {
                this.index = this.bezier.nearestTangent(screenX, this.height - (float)screenY, 25.0f);
                this.isAnchor = false;
            }
        }
        return true;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        if (this.index != -1) {
            if (this.isAnchor) {
                this.bezier.setAnchor(this.index, screenX, this.height - (float)screenY);
            } else {
                this.bezier.setTangent(this.index, screenX, this.height - (float)screenY, false);
            }
        }
        if (this.active) {
            this.recalculateLine(screenX, this.height - (float)screenY);
        }
        return true;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        this.index = -1;
        this.active = false;
        return true;
    }

    @Override
    public boolean keyDown(int keycode) {
        switch (keycode) {
            case 19: {
                this.dy += 4.0f;
                break;
            }
            case 20: {
                this.dy -= 4.0f;
                break;
            }
            case 21: {
                this.dx -= 4.0f;
                break;
            }
            case 22: {
                this.dx += 4.0f;
                break;
            }
            case 63: {
                this.metaDown = true;
                break;
            }
            case 131: {
                System.exit(0);
            }
        }
        return true;
    }

    @Override
    public boolean keyUp(int keycode) {
        switch (keycode) {
            case 19: {
                this.dy -= 4.0f;
                break;
            }
            case 20: {
                this.dy += 4.0f;
                break;
            }
            case 21: {
                this.dx += 4.0f;
                break;
            }
            case 22: {
                this.dx -= 4.0f;
                break;
            }
            case 63: {
                this.metaDown = false;
            }
        }
        return false;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean scrolled(int amount) {
        return false;
    }
}

