/*
 * Decompiled with CFR 0.152.
 */
package playingfields.map;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import playingfields.map.MapObject;

public class Token
extends MapObject {
    private Point goal;
    private BufferedImage image;
    private BufferedImage origin;
    private BufferedImage target;
    public static final int ANCHOR_TOP_LEFT = 0;
    public static final int ANCHOR_TOP_CENTER = 1;
    public static final int ANCHOR_TOP_RIGHT = 2;
    public static final int ANCHOR_CENTER_LEFT = 3;
    public static final int ANCHOR_CENTER_RIGHT = 4;
    public static final int ANCHOR_BOTTOM_LEFT = 5;
    public static final int ANCHOR_BOTTOM_CENTER = 6;
    public static final int ANCHOR_BOTTOM_RIGHT = 7;
    public static final int ANCHOR_MOVE = 8;
    private static final int INCREMENT = 64;

    public Token() {
        this(null);
    }

    public Token(BufferedImage bufferedImage) {
        this.setImage(bufferedImage);
    }

    public void setImage(BufferedImage bufferedImage) {
        if (this.bounds.width == 0 || this.bounds.height == 0) {
            return;
        }
        try {
            int n;
            if (this.origin != null) {
                this.origin.flush();
                this.origin = null;
                this.target.flush();
                this.target = null;
            }
            this.image = bufferedImage;
            Rectangle rectangle = new Rectangle();
            rectangle.x = 1;
            rectangle.y = 1;
            rectangle.width = this.bounds.width;
            rectangle.height = this.bounds.height;
            this.origin = new BufferedImage(this.bounds.width, this.bounds.height, 2);
            this.target = new BufferedImage(this.bounds.width, this.bounds.height, 2);
            Graphics2D graphics2D = this.origin.createGraphics();
            graphics2D.setColor(this.background);
            graphics2D.fill(rectangle);
            if (bufferedImage != null) {
                int n2 = bufferedImage.getWidth(null);
                n = bufferedImage.getHeight(null);
                AffineTransform affineTransform = AffineTransform.getScaleInstance((float)(this.bounds.width - 7) / (float)n2, (float)(this.bounds.height - 7) / (float)n);
                affineTransform.preConcatenate(AffineTransform.getTranslateInstance(4.0, 4.0));
                graphics2D.drawImage(bufferedImage, affineTransform, null);
            }
            graphics2D.setColor(this.adjustColor(this.foreground, 2));
            graphics2D.drawLine(1, 1, 1, rectangle.height - 2);
            graphics2D.drawLine(2, 1, rectangle.width - 2, 1);
            graphics2D.setColor(this.adjustColor(this.foreground, 1));
            graphics2D.drawLine(2, 2, 2, rectangle.height - 3);
            graphics2D.drawLine(3, 2, rectangle.width - 3, 2);
            graphics2D.setColor(this.adjustColor(this.foreground, -2));
            graphics2D.drawLine(1, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
            graphics2D.drawLine(rectangle.width - 1, 1, rectangle.width - 1, rectangle.height - 2);
            graphics2D.setColor(this.adjustColor(this.foreground, -1));
            graphics2D.drawLine(2, rectangle.height - 2, rectangle.width - 2, rectangle.height - 2);
            graphics2D.drawLine(rectangle.width - 2, 2, rectangle.width - 2, rectangle.height - 3);
            graphics2D.setColor(this.foreground);
            graphics2D.drawLine(3, 3, 3, rectangle.height - 3);
            graphics2D.drawLine(rectangle.width - 3, 3, rectangle.width - 3, rectangle.height - 3);
            graphics2D.drawLine(3, 3, rectangle.width - 3, 3);
            graphics2D.drawLine(3, rectangle.height - 3, rectangle.width - 3, rectangle.height - 3);
            int[] nArray = new int[this.bounds.width * this.bounds.height];
            this.origin.getRGB(0, 0, this.bounds.width, this.bounds.height, nArray, 0, this.bounds.width);
            for (n = 0; n < this.bounds.width * this.bounds.height; ++n) {
                int n3 = nArray[n] >> 24 & 0xFF;
                n3 = (int)((float)n3 * 0.5f);
                nArray[n] = n3 << 24 | nArray[n] & 0xFFFFFF;
            }
            this.target.setRGB(0, 0, this.bounds.width, this.bounds.height, nArray, 0, this.bounds.width);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.setImage(this.image);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.setImage(this.image);
    }

    private Color adjustColor(Color color, int n) {
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        n2 = Math.min(Math.max(n2 + n * 64, 0), 255);
        n3 = Math.min(Math.max(n3 + n * 64, 0), 255);
        n4 = Math.min(Math.max(n4 + n * 64, 0), 255);
        return new Color(n2, n3, n4);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.setImage(this.image);
    }

    public Point getCenter() {
        return new Point(this.bounds.x + this.bounds.width / 2, this.bounds.y + this.bounds.height / 2);
    }

    public void setCenter(int n, int n2) {
        this.translate(n - this.bounds.x - this.bounds.width / 2, n2 - this.bounds.y - this.bounds.height / 2);
    }

    public synchronized void translate(int n, int n2) {
        super.translate(n, n2);
        if (this.goal != null) {
            this.goal.translate(n, n2);
        }
    }

    public boolean contains(int n, int n2) {
        return this.bounds.contains(n, n2);
    }

    public synchronized void draw(Graphics graphics, AffineTransform affineTransform) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.goal != null) {
            Point2D.Float float_ = new Point2D.Float(this.goal.x, this.goal.y);
            affineTransform.preConcatenate(AffineTransform.getTranslateInstance(float_.x - (float)(this.bounds.width / 2), float_.y - (float)(this.bounds.height / 2)));
            graphics2D.drawImage(this.target, affineTransform, null);
            affineTransform.preConcatenate(AffineTransform.getTranslateInstance(-float_.x + (float)(this.bounds.width / 2), -float_.y + (float)(this.bounds.height / 2)));
        }
        affineTransform.preConcatenate(AffineTransform.getTranslateInstance(this.bounds.x, this.bounds.y));
        graphics2D.drawImage(this.origin, affineTransform, null);
        affineTransform.preConcatenate(AffineTransform.getTranslateInstance(-this.bounds.x, -this.bounds.y));
    }

    public void moveto(int n, int n2) {
        if (this.goal == null) {
            this.goal = new Point(this.bounds.x + this.bounds.width / 2, this.bounds.y + this.bounds.width / 2);
        }
        this.goal.translate(n, n2);
    }

    public void commit() {
        if (this.goal == null) {
            return;
        }
        this.setCenter(this.goal.x, this.goal.y);
        this.goal = null;
    }

    public void abort() {
        this.goal = null;
    }
}

