/*
 * Decompiled with CFR 0.152.
 */
package playingfields.map;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.GeneralPath;
import java.awt.geom.RectangularShape;
import java.util.LinkedList;
import java.util.Vector;
import javax.imageio.ImageIO;
import playingfields.Constants;
import playingfields.map.Grid;
import playingfields.map.MapCanvas;
import playingfields.map.Token;
import playingfields.map.Wall;

public class ObjectLayer
implements Constants {
    public static final int RADIUS_STEP = 50;
    private static final long serialVersionUID = 1130857614807583471L;
    private Token player;
    private Vector<Wall> walls = new Vector();
    private Area visible;
    private Area visited;
    private int radius;
    private int lastUpdate = 1;
    private int lastRedraw = 0;
    private boolean moving = false;
    private MapCanvas parent;
    private static final double EPSILON = 1.0E-4;
    private Object sightLock = new Object();
    private FogProcessor fogProcessor = null;

    public ObjectLayer(MapCanvas mapCanvas) {
        this.parent = mapCanvas;
        this.player = new Token();
        this.player.setCenter(275, 275);
        this.player.setBackground(Color.cyan);
        this.player.setForeground(Color.darkGray);
        try {
            this.player.setImage(ImageIO.read(this.getClass().getResource("images/gnome_male.gif")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.radius = 450;
        Color color = new Color(128, 64, 64);
        Wall wall = new Wall();
        wall.setOrigin(new Point(50, 50));
        wall.setTarget(new Point(50, 250));
        wall.setBackground(color);
        wall.setForeground(color);
        this.walls.add(wall);
        wall = new Wall();
        wall.setOrigin(new Point(50, 50));
        wall.setTarget(new Point(250, 50));
        wall.setBackground(color);
        wall.setForeground(color);
        this.walls.add(wall);
        wall = new Wall();
        wall.setOrigin(new Point(50, 250));
        wall.setTarget(new Point(250, 250));
        wall.setBackground(color);
        wall.setForeground(color);
        this.walls.add(wall);
        wall = new Wall();
        wall.setOrigin(new Point(250, 50));
        wall.setTarget(new Point(250, 100));
        wall.setBackground(color);
        wall.setForeground(color);
        this.walls.add(wall);
        wall = new Wall();
        wall.setOrigin(new Point(250, 200));
        wall.setTarget(new Point(250, 250));
        wall.setBackground(color);
        wall.setForeground(color);
        this.walls.add(wall);
        wall = new Wall();
        wall.setOrigin(new Point(300, 450));
        wall.setTarget(new Point(700, 100));
        wall.setBackground(color);
        wall.setForeground(color);
        this.walls.add(wall);
        this.fogProcessor = new FogProcessor();
    }

    public void incrementRadius() {
        this.radius += 50;
        ++this.lastUpdate;
    }

    public void decrementRadius() {
        this.radius -= 50;
        if (this.radius < 0) {
            this.radius = 0;
        }
        ++this.lastUpdate;
    }

    public void setMoving(boolean bl) {
        this.moving = bl;
    }

    public boolean isMoving() {
        return this.moving;
    }

    public boolean isPlayer(int n, int n2) {
        return this.player.contains(n, n2);
    }

    public void dragPlayer(int n, int n2) {
        if (this.moving) {
            this.player.moveto(n, n2);
        }
    }

    public void dropPlayer(Grid grid) {
        if (this.moving) {
            this.player.commit();
            grid.snap(this.player);
            this.updateSight();
        }
        this.moving = false;
    }

    public void drawWalls(Graphics graphics) {
        this.drawWalls(graphics, IDENTITY_TRANSFORM);
    }

    public void drawWalls(Graphics graphics, AffineTransform affineTransform) {
        for (Wall wall : this.walls) {
            wall.draw(graphics, affineTransform);
        }
    }

    public void drawPlayer(Graphics graphics) {
        this.drawPlayer(graphics, IDENTITY_TRANSFORM);
    }

    public void drawPlayer(Graphics graphics, AffineTransform affineTransform) {
        this.player.draw(graphics, affineTransform);
    }

    public Area getVisibleArea() {
        if (this.lastUpdate != this.lastRedraw) {
            this.updateSight();
        }
        return this.visible;
    }

    public Area getVisibleArea(AffineTransform affineTransform) {
        if (this.lastUpdate != this.lastRedraw) {
            this.updateSight();
        }
        return this.visible == null ? null : this.visible.createTransformedArea(affineTransform);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Area getVisitedArea() {
        if (this.lastUpdate != this.lastRedraw) {
            this.updateSight();
        }
        Object object = this.sightLock;
        synchronized (object) {
            return this.visited;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Area getVisitedArea(AffineTransform affineTransform) {
        if (this.lastUpdate != this.lastRedraw) {
            this.updateSight();
        }
        Object object = this.sightLock;
        synchronized (object) {
            return this.visited == null ? null : this.visited.createTransformedArea(affineTransform);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearVisibility() {
        Area area = this.computeVisible();
        if (area != null) {
            Object object = this.sightLock;
            synchronized (object) {
                this.visible = area;
                this.visited = new Area();
            }
            this.fogProcessor.process(area);
        } else {
            Object object = this.sightLock;
            synchronized (object) {
                this.visible = null;
                this.visited = null;
            }
        }
        this.lastRedraw = this.lastUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSight() {
        Area area = this.computeVisible();
        if (area != null) {
            Object object = this.sightLock;
            synchronized (object) {
                this.visible = area;
            }
            this.fogProcessor.process(area);
        } else {
            Object object = this.sightLock;
            synchronized (object) {
                this.visible = null;
                this.visited = null;
            }
        }
        this.lastRedraw = this.lastUpdate;
    }

    private final Area computeVisible() {
        Point point = this.player.getCenter();
        Ellipse2D.Float float_ = new Ellipse2D.Float(point.x - this.radius / 2, point.y - this.radius / 2, this.radius, this.radius);
        GeneralPath generalPath = new GeneralPath();
        generalPath.append(new FlatteningPathIterator(float_.getPathIterator(IDENTITY_TRANSFORM), 1.0, 8), false);
        Area area = new Area(generalPath);
        for (Wall wall : this.walls) {
            if (!float_.intersects(wall.getBounds().getBounds2D())) continue;
            area.subtract(wall.getObstruction(point.x, point.y));
        }
        return area;
    }

    private class FogProcessor
    implements Runnable {
        private static final int BUFFER_SIZE = 10;
        private boolean alive = true;
        private boolean notify = true;
        private LinkedList<Area> queue = new LinkedList();
        private Area addition = null;

        public FogProcessor() {
            Thread thread = new Thread(this);
            thread.setPriority(1);
            thread.start();
        }

        public synchronized void dispose() {
            this.alive = false;
            this.queue.clear();
            this.notifyAll();
        }

        public synchronized boolean doesNotify() {
            return this.notify;
        }

        public synchronized void setNotify(boolean bl) {
            this.notify = bl;
        }

        public synchronized void process(Area area) {
            while (this.queue.size() > 10) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.queue.addLast(area);
            this.notifyAll();
        }

        public synchronized void gobble() {
            while (this.queue.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.addition = this.queue.removeFirst();
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void generateFog() {
            Area area;
            Object object = ObjectLayer.this.sightLock;
            synchronized (object) {
                if (this.addition == null) {
                    ObjectLayer.this.visited = null;
                    return;
                }
                if (ObjectLayer.this.visited == null) {
                    ObjectLayer.this.visited = (Area)this.addition.clone();
                    return;
                }
                area = (Area)ObjectLayer.this.visited.clone();
            }
            object = this.addition.getBounds2D();
            double d = ((RectangularShape)object).getCenterX();
            double d2 = ((RectangularShape)object).getCenterY();
            double d3 = 0.9999;
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(-d, -d2);
            affineTransform.scale(d3, d3);
            affineTransform.translate(d, d2);
            Area area2 = this.addition.createTransformedArea(affineTransform);
            area2.subtract(area);
            if (area2.isEmpty()) {
                return;
            }
            area.add(this.addition);
            Object object2 = ObjectLayer.this.sightLock;
            synchronized (object2) {
                ObjectLayer.this.visited = area;
            }
            ObjectLayer.this.parent.repaint();
        }

        public void run() {
            while (this.alive) {
                this.gobble();
                if (!this.alive) {
                    return;
                }
                this.generateFog();
            }
        }
    }
}

