/*
 * Decompiled with CFR 0.152.
 */
package playingfields.map;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import playingfields.Constants;

public abstract class MapObject
implements Constants {
    private static final long serialVersionUID = 8524965459876234556L;
    protected static Rectangle corner = new Rectangle(0, 0, 6, 6);
    protected static final Color CLEAR = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    protected Color foreground;
    protected Color background;
    protected Rectangle bounds = new Rectangle(0, 0, 50, 50);

    public MapObject() {
        this.setForeground(null);
        this.setBackground(null);
    }

    public void setForeground(Color color) {
        this.foreground = color == null ? Color.black : color;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setBackground(Color color) {
        this.background = color == null ? CLEAR : color;
    }

    public Color getBackground() {
        return this.background;
    }

    public Rectangle getBounds() {
        return (Rectangle)this.bounds.clone();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.bounds = new Rectangle(n, n2, n3, n4);
    }

    public void setBounds(Rectangle rectangle) {
        this.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public int getX() {
        return this.bounds.x;
    }

    public int getY() {
        return this.bounds.y;
    }

    public int getWidth() {
        return this.bounds.width;
    }

    public int getHeight() {
        return this.bounds.height;
    }

    public void moveTo(int n, int n2) {
        this.setBounds(n, n2, this.bounds.width, this.bounds.height);
    }

    public boolean contains(int n, int n2) {
        return this.bounds.contains(n, n2);
    }

    public void translate(int n, int n2) {
        this.bounds.x += n;
        this.bounds.y += n2;
    }

    public void setSize(int n, int n2) {
        this.setBounds(this.bounds.x, this.bounds.y, n, n2);
    }

    public void draw(Graphics graphics) {
        this.draw(graphics, IDENTITY_TRANSFORM);
    }

    protected abstract void draw(Graphics var1, AffineTransform var2);
}

