/*
 * Decompiled with CFR 0.152.
 */
package playingfields.map;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import playingfields.Constants;
import playingfields.map.Grid;
import playingfields.map.ObjectLayer;

public class MapCanvas
extends JPanel
implements Constants {
    private static Color CLEAR_COLOR = new Color(0, true);
    private ObjectLayer objectLayer;
    private Grid grid;
    private MediaTracker media;
    private BufferedImage moveBuffer;
    private BufferedImage viewBuffer;
    private BufferedImage portBuffer;
    private BufferedImage greyBuffer;
    private Graphics2D moveGraphics;
    private Graphics2D viewGraphics;
    private Graphics2D portGraphics;
    private Graphics2D greyGraphics;
    private Area visibleCache;
    private Rectangle window = new Rectangle();
    private AffineTransform forward;

    public MapCanvas() {
        this((BufferedImage)null);
    }

    public MapCanvas(BufferedImage bufferedImage) {
        this.setBackground(MAP_BACKGROUND_COLOR);
        this.objectLayer = new ObjectLayer(this);
        this.media = new MediaTracker(this);
        this.grid = new Grid();
        this.window = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        this.forward = new AffineTransform();
        this.adjustSize(new Dimension(796, 596));
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                MapCanvas.this.window = new Rectangle(0, 0, MapCanvas.this.getWidth(), MapCanvas.this.getHeight());
                MapCanvas.this.generateImageBuffers(MapCanvas.this.window);
            }
        });
    }

    public synchronized void adjustSize(Dimension dimension) {
        this.setPreferredSize(dimension);
        this.setSize(dimension);
        this.window.width = (int)dimension.getWidth();
        this.window.height = (int)dimension.getHeight();
    }

    public synchronized Grid getGrid() {
        return this.grid;
    }

    public synchronized ObjectLayer getObjects() {
        return this.objectLayer;
    }

    private void generateImageBuffers(Rectangle rectangle) {
        if (this.viewBuffer != null) {
            this.viewBuffer.flush();
            this.viewBuffer = null;
            this.portBuffer.flush();
            this.portBuffer = null;
            this.greyBuffer.flush();
            this.greyBuffer = null;
            this.moveBuffer.flush();
            this.moveBuffer = null;
        }
        if (rectangle.width > 0 && rectangle.height > 0) {
            this.viewBuffer = new BufferedImage(rectangle.width, rectangle.height, 2);
            this.portBuffer = new BufferedImage(rectangle.width, rectangle.height, 2);
            this.greyBuffer = new BufferedImage(rectangle.width, rectangle.height, 10);
            this.moveBuffer = new BufferedImage(rectangle.width, rectangle.height, 2);
            this.viewGraphics = this.viewBuffer.createGraphics();
            this.portGraphics = this.portBuffer.createGraphics();
            this.greyGraphics = this.greyBuffer.createGraphics();
            this.moveGraphics = this.moveBuffer.createGraphics();
            this.portGraphics.setComposite(AlphaComposite.Src);
            this.moveGraphics.setComposite(AlphaComposite.Src);
        } else {
            this.viewBuffer = null;
            this.portBuffer = null;
            this.greyBuffer = null;
            this.moveBuffer = null;
        }
    }

    public synchronized void paint(Graphics graphics) {
        try {
            Shape shape;
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.viewBuffer == null) {
                shape = this.getBounds();
                if (this.window.width != shape.width || this.window.height != shape.height) {
                    this.window.width = shape.width;
                    this.window.height = shape.height;
                }
                this.window = shape;
                this.generateImageBuffers(this.window);
            }
            this.forward.setToTranslation(-this.window.x, -this.window.y);
            shape = this.objectLayer.getVisitedArea(this.forward);
            Area area = this.objectLayer.getVisibleArea(this.forward);
            this.portGraphics.setClip(null);
            this.portGraphics.setColor(Color.black);
            this.portGraphics.fill(this.window);
            if (shape != null) {
                this.portGraphics.setClip(shape);
                this.portGraphics.setColor(CLEAR_COLOR);
                this.portGraphics.fill(this.window);
                this.greyGraphics.setClip(null);
                this.greyGraphics.setColor(this.getBackground());
                this.greyGraphics.fill(this.window);
                this.objectLayer.drawWalls(this.greyGraphics, this.forward);
                this.greyGraphics.drawImage(this.portBuffer, null, 0, 0);
                this.portGraphics.drawImage(this.greyBuffer, null, 0, 0);
                this.portGraphics.setClip(null);
            }
            this.portGraphics.setStroke(STROKE_MEDIUM);
            if (shape != null) {
                this.portGraphics.setColor(VISITED_BOUNDARY_COLOR);
                this.portGraphics.draw(shape);
            }
            if (area != null) {
                this.portGraphics.setColor(VISIBLE_BOUNDARY_COLOR);
                this.portGraphics.draw(area);
            }
            this.portGraphics.setStroke(STROKE_THIN);
            this.portGraphics.setColor(this.grid.getColor());
            int n = (int)this.grid.getIncrement();
            int n2 = this.window.x % n;
            int n3 = this.window.y % n;
            int n4 = this.grid.nextX(-1);
            while (n4 < this.window.width + n2) {
                this.portGraphics.drawLine(n4 - n2, 0, n4 - n2, this.window.height);
                n4 = this.grid.nextX(n4);
            }
            n4 = this.grid.nextY(-1);
            while (n4 < this.window.height + n3) {
                this.portGraphics.drawLine(0, n4 - n3, this.window.width, n4 - n3);
                n4 = this.grid.nextY(n4);
            }
            this.portGraphics.setClip(area);
            this.portGraphics.setColor(CLEAR_COLOR);
            this.portGraphics.fill(this.window);
            this.viewGraphics.setColor(this.getBackground());
            this.viewGraphics.fill(this.window);
            this.viewGraphics.setStroke(STROKE_THIN);
            this.viewGraphics.setColor(this.grid.getColor());
            n = (int)this.grid.getIncrement();
            n2 = this.window.x % n;
            n3 = this.window.y % n;
            n4 = this.grid.nextX(-1);
            while (n4 < this.window.width + n2) {
                this.viewGraphics.drawLine(n4 - n2, 0, n4 - n2, this.window.height);
                n4 = this.grid.nextX(n4);
            }
            n4 = this.grid.nextY(-1);
            while (n4 < this.window.height + n3) {
                this.viewGraphics.drawLine(0, n4 - n3, this.window.width, n4 - n3);
                n4 = this.grid.nextY(n4);
            }
            graphics2D.setClip(this.window);
            graphics2D.drawImage(this.viewBuffer, null, this.window.x, this.window.y);
            this.objectLayer.drawWalls(graphics2D, IDENTITY_TRANSFORM);
            graphics2D.drawImage(this.portBuffer, null, this.window.x, this.window.y);
            this.moveGraphics.setClip(null);
            this.moveGraphics.setColor(CLEAR_COLOR);
            this.moveGraphics.fill(this.window);
            this.moveGraphics.setClip(area);
            this.moveGraphics.setColor(CLEAR_COLOR);
            this.moveGraphics.fill(this.window);
            graphics2D.drawImage(this.moveBuffer, null, this.window.x, this.window.y);
            this.objectLayer.drawPlayer(graphics2D, this.forward);
            this.forward.setToTranslation(this.window.x, this.window.y);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

