/*
 * Decompiled with CFR 0.152.
 */
package playingfields.map;

import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Point2D;
import playingfields.Constants;
import playingfields.map.MapObject;
import playingfields.map.Token;
import playingfields.map.Wall;

public class Grid
implements Constants {
    public static final int UNIT_NONE = -1;
    public static final int UNIT_PIXEL = 0;
    public static final int UNIT_INCH = 1;
    public static final int UNIT_CM = 2;
    private static final long serialVersionUID = 6531297865145123L;
    private Point2D.Float origin = new Point2D.Float();
    private float increment = 50.0f;
    private int unit = 0;
    private boolean snap = true;
    private boolean hide = false;
    private Color color = GRID_LINE_COLOR;
    private boolean modified = true;

    public Grid() {
        this(0.0f, 0.0f, 50.0f);
    }

    public Grid(float f, float f2, float f3) {
        this.origin.x = f;
        this.origin.y = f2;
        this.setIncrement(f3);
    }

    public void setIncrement(float f) {
        this.modified = true;
        this.increment = f <= 0.0f ? 5.0f : f;
    }

    public float getIncrement() {
        return this.increment;
    }

    public void setOrigin(float f, float f2) {
        this.modified = true;
        this.origin = new Point2D.Float(f, f2);
    }

    public Point2D getOrigin() {
        return this.origin;
    }

    public float getX() {
        return this.origin.x;
    }

    public float getY() {
        return this.origin.y;
    }

    public void setSnap(boolean bl) {
        this.modified = true;
        this.snap = bl;
    }

    public boolean getSnap() {
        return this.snap;
    }

    public void setColor(Color color) {
        this.modified = true;
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public Point2D.Float screenToGrid(Point point) {
        return this.screenToGrid(point.x, point.y);
    }

    public Point2D.Float screenToGrid(int n, int n2) {
        float f = 1.0f;
        return new Point2D.Float((float)n / f - this.origin.x, (float)n2 / f - this.origin.y);
    }

    public Point gridToScreen(Point2D.Float float_) {
        return this.gridToScreen(float_.x, float_.y);
    }

    public Point gridToScreen(float f, float f2) {
        float f3 = 1.0f;
        return new Point(Math.round((f + this.origin.x) * f3), Math.round((f2 + this.origin.y) * f3));
    }

    public int nextX(int n) {
        float f = 1.0f;
        float f2 = (float)Math.floor(((float)n / f - this.origin.x) / this.increment);
        return Math.round((this.origin.x + (f2 + 1.0f) * this.increment) * f);
    }

    public int nextY(int n) {
        float f = 1.0f;
        float f2 = (float)Math.floor(((float)n / f - this.origin.y) / this.increment);
        return Math.round((this.origin.y + (f2 + 1.0f) * this.increment) * f);
    }

    private int getNearestCenterX(int n) {
        float f = 1.0f;
        float f2 = (float)n / f - this.origin.x;
        int n2 = (int)Math.floor(f2 / this.increment);
        float f3 = this.origin.x + this.increment * ((float)n2 + 0.5f);
        return Math.round(f3 * f);
    }

    private int getNearestGridX(int n) {
        float f = 1.0f;
        float f2 = (float)n / f - this.origin.x;
        int n2 = Math.round(f2 / this.increment);
        float f3 = this.origin.x + this.increment * (float)n2;
        return Math.round(f3 * f);
    }

    private int getNearestCenterY(int n) {
        float f = 1.0f;
        float f2 = (float)n / f - this.origin.y;
        int n2 = (int)Math.floor(f2 / this.increment);
        float f3 = this.origin.y + this.increment * ((float)n2 + 0.5f);
        return Math.round(f3 * f);
    }

    private int getNearestGridY(int n) {
        float f = 1.0f;
        float f2 = (float)n / f - this.origin.y;
        int n2 = Math.round(f2 / this.increment);
        float f3 = this.origin.y + this.increment * (float)n2;
        return Math.round(f3 * f);
    }

    private void snapGrid(Point point) {
        point.x = this.getNearestGridX(point.x);
        point.y = this.getNearestGridY(point.y);
    }

    private void snapCenter(Point point) {
        point.x = this.getNearestCenterX(point.x);
        point.y = this.getNearestCenterY(point.y);
    }

    public void snap(MapObject mapObject) {
        if (mapObject instanceof Wall) {
            this.snapWall((Wall)mapObject);
        } else if (mapObject instanceof Token) {
            this.snapToken((Token)mapObject);
        }
    }

    private void snapWall(Wall wall) {
        Point point = wall.getOrigin();
        Point point2 = wall.getTarget();
        this.snapGrid(point);
        this.snapGrid(point2);
        wall.setOrigin(point);
        wall.setTarget(point2);
    }

    private void snapToken(Token token) {
        int n = Math.round((float)token.getWidth() / this.increment);
        int n2 = Math.round((float)token.getHeight() / this.increment);
        if (n % 2 == 0 && n2 % 2 == 0) {
            Point point = token.getCenter();
            this.snapGrid(point);
            token.setCenter(point.x, point.y);
        } else if (n % 2 == 0 && n2 % 2 != 0) {
            Point point = token.getCenter();
            point.x = this.getNearestGridX(point.x);
            point.y = this.getNearestCenterY(point.y);
            token.setCenter(point.x, point.y);
        } else if (n % 2 != 0 && n2 % 2 == 0) {
            Point point = token.getCenter();
            point.x = this.getNearestCenterX(point.x);
            point.y = this.getNearestGridY(point.y);
            token.setCenter(point.x, point.y);
        } else {
            Point point = token.getCenter();
            this.snapCenter(point);
            token.setCenter(point.x, point.y);
        }
    }
}

