/*
 * Decompiled with CFR 0.152.
 */
package playingfields;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import playingfields.Constants;
import playingfields.map.MapCanvas;
import playingfields.map.ObjectLayer;

public class Main
extends JFrame
implements Constants {
    public static final int INITIAL_STATE = 0;
    public static final int BROWSER_STATE = 1;
    public static final int CLIENT_STATE = 2;
    public static final int SERVER_STATE = 3;
    private static final int WINDOW_WIDTH = 800;
    private static final int WINDOW_HEIGHT = 640;
    private static final int BUTTON_SIZE = 64;
    private String name = "Visibility Prototype";
    private MapCanvas canvas;
    private JMenuBar menuBar;
    private JMenu menu;
    private JMenuItem incrmItem;
    private JMenuItem decrmItem;
    private JMenuItem resetItem;
    private JMenuItem quitItem;

    public Main() {
        this.initializeMenuBar();
        this.initializeLayout();
        this.initializeControllers();
        this.pack();
    }

    public void refresh() {
        this.canvas.repaint();
    }

    private void initializeLayout() {
        this.canvas = new MapCanvas();
        this.canvas.setPreferredSize(new Dimension(796, 596));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.canvas, "Center");
        this.setDefaultCloseOperation(3);
        this.setTitle(this.name);
    }

    private void initializeMenuBar() {
        this.menuBar = new JMenuBar();
        this.menu = new JMenu("Visibility");
        this.incrmItem = new JMenuItem("Increment");
        this.decrmItem = new JMenuItem("Decrement");
        this.resetItem = new JMenuItem("Reset");
        this.quitItem = new JMenuItem("Quit");
        this.incrmItem.setAccelerator(KeyStroke.getKeyStroke(73, 4));
        this.incrmItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.canvas.getObjects().incrementRadius();
                Main.this.canvas.repaint();
            }
        });
        this.decrmItem.setAccelerator(KeyStroke.getKeyStroke(68, 4));
        this.decrmItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.canvas.getObjects().decrementRadius();
                Main.this.canvas.repaint();
            }
        });
        this.resetItem.setAccelerator(KeyStroke.getKeyStroke(82, 4));
        this.resetItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Main.this.canvas.getObjects().clearVisibility();
                Main.this.canvas.repaint();
            }
        });
        this.quitItem.setAccelerator(KeyStroke.getKeyStroke(81, 4));
        this.quitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(1);
            }
        });
        this.menu.add(this.incrmItem);
        this.menu.add(this.decrmItem);
        this.menu.add(this.resetItem);
        this.menu.add(new JSeparator());
        this.menu.add(this.quitItem);
        this.menuBar.add(this.menu);
        this.setJMenuBar(this.menuBar);
    }

    private void initializeControllers() {
        MapMouseListener mapMouseListener = new MapMouseListener();
        this.canvas.addMouseListener(mapMouseListener);
        this.canvas.addMouseMotionListener(mapMouseListener);
    }

    public static void main(String[] stringArray) {
        new Main().setVisible(true);
    }

    private class MapMouseListener
    implements MouseListener,
    MouseMotionListener {
        private Point origin = new Point();
        private Point previous = new Point();

        public void mousePressed(MouseEvent mouseEvent) {
            ObjectLayer objectLayer = Main.this.canvas.getObjects();
            Point point = mouseEvent.getPoint();
            if (objectLayer.isPlayer(point.x, point.y)) {
                objectLayer.setMoving(true);
            }
            this.previous.x = mouseEvent.getX();
            this.previous.y = mouseEvent.getY();
            this.origin.x = this.previous.x;
            this.origin.y = this.previous.y;
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            ObjectLayer objectLayer = Main.this.canvas.getObjects();
            if (!objectLayer.isMoving()) {
                return;
            }
            Point point = mouseEvent.getPoint();
            if (Math.abs(this.origin.x - point.x) + Math.abs(this.origin.y - point.y) > 1) {
                int n = point.x - this.previous.x;
                int n2 = point.y - this.previous.y;
                objectLayer.dragPlayer(n, n2);
            }
            objectLayer.dropPlayer(Main.this.canvas.getGrid());
            Main.this.canvas.repaint();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            ObjectLayer objectLayer = Main.this.canvas.getObjects();
            if (!objectLayer.isMoving()) {
                return;
            }
            Point point = mouseEvent.getPoint();
            int n = point.x - this.previous.x;
            int n2 = point.y - this.previous.y;
            objectLayer.dragPlayer(n, n2);
            this.previous.x = point.x;
            this.previous.y = point.y;
            Main.this.canvas.repaint();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

