/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.util;

import com.badlogic.gdx.utils.Array;
import java.util.Random;

public class RandomGenerator {
    private static Random generator = new Random(0L);
    private static double NV_MAGICCONST = 4.0 * Math.exp(-0.5) / Math.sqrt(2.0);
    private static double SG_MAGICCONST = 1.0 + Math.log(4.5);

    public static void seed(int seed) {
        generator = new Random(seed);
    }

    public static int getInt() {
        return generator.nextInt();
    }

    public static int getInt(int min, int max) {
        return generator.nextInt(max - min + 1) + min;
    }

    public static long getLong() {
        return generator.nextLong();
    }

    public static float getFloat() {
        return generator.nextFloat();
    }

    public static float getFloat(float min, float max) {
        return generator.nextFloat() * (max - min) + min;
    }

    public static double getDouble() {
        return generator.nextDouble();
    }

    public static double getDouble(double min, double max) {
        return generator.nextDouble() * (max - min) + min;
    }

    public static boolean getBoolean() {
        return generator.nextBoolean();
    }

    public static <T> T getChoice(T[] data) {
        if (data.length == 0) {
            throw new IllegalArgumentException("Data cannot be empty");
        }
        int pos = generator.nextInt(data.length);
        return data[pos];
    }

    public static <T> T getChoice(Array<T> data) {
        if (data.size == 0) {
            throw new IllegalArgumentException("Data cannot be empty");
        }
        int pos = generator.nextInt(data.size);
        return data.get(pos);
    }

    public static <T> void shuffle(T[] data) {
        RandomGenerator.shuffle(data, 0, data.length);
    }

    public static <T> void shuffle(T[] data, int offset, int count) {
        for (int ii = count - 1; ii >= 1; --ii) {
            int pos = generator.nextInt() % (ii + 1);
            if (ii == pos) continue;
            T temp = data[offset + pos];
            data[offset + pos] = data[offset + ii];
            data[offset + ii] = temp;
        }
    }

    public static double getNormal(double mu, double sigma) {
        double z = 0.0;
        boolean compute = true;
        while (compute) {
            double u2;
            double u1 = generator.nextDouble();
            z = NV_MAGICCONST * (u1 - 0.5) / (u2 = 1.0 - generator.nextDouble());
            double zz = z * z / 4.0;
            if (!(zz <= -Math.log(u2))) continue;
            compute = false;
        }
        return mu + z * sigma;
    }

    public static double getLogNorm(double mu, double sigma) {
        return Math.exp(RandomGenerator.getNormal(mu, sigma));
    }

    public static double getExp(double mu) {
        double lambda = 1.0 / mu;
        return -Math.log(1.0 - RandomGenerator.getDouble()) / lambda;
    }

    public static double getGamma(double alpha, double beta) {
        if (alpha <= 0.0 || beta <= 0.0) {
            throw new IllegalArgumentException("Gamma distribution: alpha and beta must be > 0.0");
        }
        if (alpha > 1.0) {
            double x;
            double ainv = Math.sqrt(2.0 * alpha - 1.0);
            double bbb = alpha - Math.log(4.0);
            double ccc = alpha + ainv;
            boolean compute = true;
            while (true) {
                double z;
                double u1;
                if (!((u1 = RandomGenerator.getDouble()) > 1.0E-7) || !(u1 < 0.9999999)) {
                    continue;
                }
                double u2 = 1.0 - RandomGenerator.getDouble();
                double v = Math.log(u1 / (1.0 - u1)) / ainv;
                double r = bbb + ccc * v - (x = alpha * Math.exp(v));
                if (r + SG_MAGICCONST - 4.5 * (z = u1 * u1 * u2) >= 0.0 || r >= Math.log(z)) break;
            }
            return x / beta;
        }
        if (alpha == 1.0) {
            return -Math.log(1.0 - RandomGenerator.getDouble()) / beta;
        }
        double x = 0.0;
        boolean compute = true;
        while (compute) {
            double b = (Math.E + alpha) / Math.E;
            double u = RandomGenerator.getDouble();
            double p = b * u;
            x = p <= 1.0 ? Math.pow(p, 1.0 / alpha) : -Math.log((b - p) / alpha);
            double u1 = RandomGenerator.getDouble();
            if (p > 1.0) {
                if (!(u1 <= Math.pow(x, alpha - 1.0))) continue;
                compute = false;
                continue;
            }
            if (!(u1 < Math.exp(-x))) continue;
            compute = false;
        }
        return x / beta;
    }

    double getBeta(double alpha, double beta) {
        double y = RandomGenerator.getGamma(alpha, 1.0);
        if (y != 0.0) {
            return y / (y + RandomGenerator.getGamma(beta, 1.0));
        }
        return 0.0;
    }

    public static double getPareto(double xm, double alpha) {
        double u = 1.0 - RandomGenerator.getDouble();
        return Math.pow(u, -1.0 / alpha) * xm;
    }

    public static double getWeibull(double k, double lambda) {
        double u = 1.0 - RandomGenerator.getDouble();
        return lambda * Math.pow(-Math.log(u), 1.0 / k);
    }
}

