/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.scene2;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.graphics.Texture2D;
import edu.cornell.gdiac.scene2.PolygonNode;
import edu.cornell.gdiac.scene2.SceneNode;
import edu.cornell.gdiac.scene2.layout.Layout;

public class ProgressBar
extends SceneNode {
    protected float progress;
    protected Vector2 foresize;
    protected PolygonNode background;
    protected PolygonNode foreground;
    protected PolygonNode begincap;
    protected PolygonNode finalcap;
    private final Rectangle rectangleCache = new Rectangle();
    private final Vector2 vectorCache = new Vector2();

    public ProgressBar() {
        this.progress = 1.0f;
    }

    public boolean init() {
        assert (false) : "This node does not support the empty initializer";
        return false;
    }

    public ProgressBar(Vector2 size) {
        this(null, null, null, null, size);
    }

    public ProgressBar(TextureRegion background) {
        this(background, null, null, null);
    }

    public ProgressBar(TextureRegion background, Vector2 size) {
        this(background, null, null, null, size);
    }

    public ProgressBar(TextureRegion background, TextureRegion foreground) {
        this(background, foreground, null, null);
    }

    public ProgressBar(TextureRegion background, TextureRegion foreground, Vector2 size) {
        this(background, foreground, null, null, size);
    }

    public ProgressBar(TextureRegion background, TextureRegion foreground, TextureRegion beginCap, TextureRegion finalCap) {
        this(background, foreground, beginCap, finalCap, new Vector2(background.getRegionWidth(), background.getRegionHeight()));
    }

    public ProgressBar(TextureRegion background, TextureRegion foreground, TextureRegion beginCap, TextureRegion finalCap, Vector2 size) {
        super(size);
        Rectangle boundingBox;
        TextureRegion temp = background == null ? new TextureRegion(Texture2D.getBlank()) : background;
        Vector2 scale = new Vector2(size.x / (float)temp.getRegionWidth(), size.y / (float)temp.getRegionHeight());
        this.background = new PolygonNode(new TextureRegion(temp));
        this.background.setAnchor(Layout.ANCHOR_BOTTOM_LEFT);
        this.background.setPosition(0.0f, 0.0f);
        this.background.setScale(scale);
        this.background.setName("background");
        this.addChild(this.background);
        this.progress = 0.0f;
        this.foresize = new Vector2(size);
        if (beginCap != null) {
            scale = new Vector2(size.x / (float)beginCap.getRegionWidth(), size.y / (float)beginCap.getRegionHeight());
            scale.x = 1.0f;
            this.begincap = new PolygonNode(beginCap);
            this.begincap.setScale(scale);
            this.begincap.setAnchor(Layout.ANCHOR_BOTTOM_LEFT);
            this.begincap.setPosition(0.0f, 0.0f);
            this.begincap.setName("begincap");
            this.addChild(this.begincap);
            this.foresize.x -= (float)beginCap.getRegionWidth();
        }
        if (finalCap != null) {
            scale = new Vector2(size.x / (float)finalCap.getRegionWidth(), size.y / (float)finalCap.getRegionHeight());
            scale.x = 1.0f;
            this.finalcap = new PolygonNode(finalCap);
            this.finalcap.setScale(scale);
            this.finalcap.setAnchor(Layout.ANCHOR_BOTTOM_LEFT);
            this.finalcap.setName("finalcap");
            if (this.begincap == null) {
                this.finalcap.setPosition(0.0f, 0.0f);
            } else {
                boundingBox = this.begincap.getBoundingBox(this.rectangleCache);
                this.finalcap.setPosition(boundingBox.width < 0.0f ? boundingBox.x : boundingBox.x + boundingBox.width, 0.0f);
            }
            this.addChild(this.finalcap);
            this.foresize.x -= (float)finalCap.getRegionWidth();
        }
        if (foreground != null) {
            scale = new Vector2(size.x / (float)foreground.getRegionWidth(), size.y / (float)foreground.getRegionHeight());
            scale.x = 1.0f;
            this.foreground = new PolygonNode(foreground);
            this.foreground.setScale(scale);
            this.foresize.y /= scale.y;
        } else {
            temp = new TextureRegion(Texture2D.getBlank());
            scale = new Vector2(size.x / (float)temp.getRegionWidth(), size.y / (float)temp.getRegionHeight());
            scale.x = 1.0f;
            this.foreground = new PolygonNode(new TextureRegion(temp));
            this.foreground.setColor(Color.RED);
            this.foreground.setScale(scale);
            this.foresize.y /= scale.y;
        }
        this.foreground.setPolygon(new Rectangle(0.0f, 0.0f, 0.0f, this.foresize.y));
        this.foreground.setContentSize(new Vector2(0.0f, this.foresize.y));
        this.foreground.setAnchor(Layout.ANCHOR_BOTTOM_LEFT);
        this.foreground.setName("foreground");
        if (this.begincap == null) {
            this.foreground.setPosition(0.0f, 0.0f);
        } else {
            boundingBox = this.begincap.getBoundingBox(this.rectangleCache);
            this.foreground.setPosition(boundingBox.width < 0.0f ? boundingBox.x : boundingBox.x + boundingBox.width, 0.0f);
        }
        this.addChild(this.foreground);
    }

    public ProgressBar(AssetDirectory manager, JsonValue data) {
        super(manager, data);
        TextureRegion foreground;
        TextureRegion finalCap;
        Vector2 size;
        Vector2 coord = new Vector2(this.getPosition());
        String temp = data.getString("background", "<unknown>");
        TextureRegion background = manager.getEntry(temp, TextureRegion.class);
        if (background == null) {
            background = new TextureRegion(Texture2D.getBlank());
        }
        if (data.has("size")) {
            JsonValue sdata = data.get("size");
            size = new Vector2(sdata.get(0).asFloat(), sdata.get(1).asFloat());
        } else {
            size = new Vector2(background.getRegionWidth(), background.getRegionHeight());
        }
        this.setContentSize(size);
        Vector2 scale = new Vector2(size.x / (float)background.getRegionWidth(), size.y / (float)background.getRegionHeight());
        this.background = new PolygonNode(new TextureRegion(background));
        this.background.setAnchor(Layout.ANCHOR_BOTTOM_LEFT);
        this.background.setPosition(0.0f, 0.0f);
        this.background.setScale(scale);
        this.background.setName("background");
        this.addChild(this.background);
        this.progress = 0.0f;
        this.foresize = new Vector2(size);
        temp = data.getString("left_cap", "<unknown>");
        TextureRegion beginCap = manager.getEntry(temp, TextureRegion.class);
        if (beginCap != null) {
            scale = new Vector2(size.x / (float)beginCap.getRegionWidth(), size.y / (float)beginCap.getRegionHeight());
            scale.x = 1.0f;
            this.begincap = new PolygonNode(beginCap);
            this.begincap.setScale(scale);
            this.begincap.setAnchor(Layout.ANCHOR_BOTTOM_LEFT);
            this.begincap.setPosition(0.0f, 0.0f);
            this.begincap.setName("begincap");
            this.addChild(this.begincap);
            this.foresize.x -= (float)beginCap.getRegionWidth();
        }
        if ((finalCap = manager.getEntry(temp = data.getString("right_cap", "<unknown>"), TextureRegion.class)) != null) {
            scale = new Vector2(size.x / (float)finalCap.getRegionWidth(), size.y / (float)finalCap.getRegionHeight());
            scale.x = 1.0f;
            this.finalcap = new PolygonNode(finalCap);
            this.finalcap.setScale(scale);
            this.finalcap.setAnchor(Layout.ANCHOR_BOTTOM_LEFT);
            this.finalcap.setName("finalcap");
            if (this.begincap == null) {
                this.finalcap.setPosition(0.0f, 0.0f);
            } else {
                Rectangle boundingBox = this.begincap.getBoundingBox(this.rectangleCache);
                this.finalcap.setPosition(boundingBox.width < 0.0f ? boundingBox.x : boundingBox.x + boundingBox.width, 0.0f);
            }
            this.addChild(this.finalcap);
            this.foresize.x -= (float)finalCap.getRegionWidth();
        }
        if ((foreground = manager.getEntry(temp = data.getString("foreground", "<unknown>"), TextureRegion.class)) != null) {
            scale = new Vector2(size.x / (float)foreground.getRegionWidth(), size.y / (float)foreground.getRegionHeight());
            scale.x = 1.0f;
            this.foreground = new PolygonNode(foreground);
            this.foreground.setScale(scale);
            this.foresize.y /= scale.y;
        } else {
            TextureRegion temptexture = new TextureRegion(Texture2D.getBlank());
            scale = new Vector2(size.x / (float)temptexture.getRegionWidth(), size.y / (float)temptexture.getRegionHeight());
            scale.x = 1.0f;
            this.foreground = new PolygonNode(temptexture);
            this.foreground.setColor(Color.RED);
            this.foreground.setScale(scale);
            this.foresize.y /= scale.y;
        }
        this.foreground.setPolygon(new Rectangle(0.0f, 0.0f, 0.0f, this.foresize.y));
        this.foreground.setContentSize(new Vector2(0.0f, this.foresize.y));
        this.foreground.setAnchor(Layout.ANCHOR_BOTTOM_LEFT);
        this.foreground.setName("foreground");
        if (this.begincap == null) {
            this.foreground.setPosition(0.0f, 0.0f);
        } else {
            Rectangle boundingBox = this.begincap.getBoundingBox(this.rectangleCache);
            this.foreground.setPosition(boundingBox.width < 0.0f ? boundingBox.x : boundingBox.x + boundingBox.width, 0.0f);
        }
        this.addChild(this.foreground);
        this.setPosition(coord);
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        this.progress = progress;
        this.foreground.setPolygon(this.rectangleCache.set(0.0f, 0.0f, progress * this.foresize.x, this.foresize.y));
        this.foreground.setContentSize(this.vectorCache.set(progress * this.foresize.x, this.foresize.y));
        if (this.finalcap != null) {
            Rectangle boundingBox = this.rectangleCache.set(this.begincap.getBoundingBox(this.rectangleCache));
            this.finalcap.setPosition(boundingBox.width < 0.0f ? boundingBox.x : boundingBox.x + boundingBox.width, 0.0f);
        }
    }

    public Color getBackgroundColor() {
        return this.background.getColor();
    }

    public void setBackgroundColor(Color color) {
        this.background.setColor(color);
    }

    public Color getForegroundColor() {
        return this.foreground.getColor();
    }

    public void setForegroundColor(Color color) {
        this.foreground.setColor(color);
        if (this.begincap != null) {
            this.begincap.setColor(color);
        }
        if (this.finalcap != null) {
            this.finalcap.setColor(color);
        }
    }
}

