/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.scene2;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

public final class CameraHelper {
    private static final Rectangle cacheViewport = new Rectangle();

    private CameraHelper() {
    }

    public static Vector2 windowToScreenCoords(Vector3 windowCoords, Vector2 screenCoords) {
        cacheViewport.set(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        return CameraHelper.windowToScreenCoords(windowCoords, cacheViewport, screenCoords);
    }

    public static Vector2 windowToScreenCoords(Vector3 windowCoords, Rectangle viewport, Vector2 screenCoords) {
        screenCoords.set(windowCoords.x, windowCoords.x);
        screenCoords.y = viewport.getHeight() - screenCoords.y - 1.0f;
        return screenCoords;
    }

    public static Vector3 screenToWindowCoords(Vector2 screenCoords, Vector3 windowCoords) {
        cacheViewport.set(0.0f, 0.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        return CameraHelper.screenToWindowCoords(screenCoords, cacheViewport, windowCoords);
    }

    public static Vector3 screenToWindowCoords(Vector2 screenCoords, Rectangle viewport, Vector3 windowCoords) {
        windowCoords.set(screenCoords.x, screenCoords.y, 0.0f);
        windowCoords.y = viewport.getHeight() - windowCoords.y - 1.0f;
        return windowCoords;
    }
}

