/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.math;

import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.IntIntMap;
import edu.cornell.gdiac.math.Path2;
import edu.cornell.gdiac.math.Poly2;
import edu.cornell.gdiac.math.Spline2;

public class SplinePather {
    private Spline2 spline;
    private FloatArray pointBuff;
    private FloatArray paramBuff;
    private IntIntMap anchorPts;
    private boolean closed;
    private boolean calculated;
    private float tolerance;
    private float[] vertBuff;
    private short[] indBuff;
    private final float SMOOTH_TOLERANCE = 1.0E-4f;
    private final float DEFAULT_FLATNESS = 0.5f;

    public SplinePather() {
        this.spline = null;
        this.calculated = false;
        this.tolerance = 0.5f;
    }

    public SplinePather(Spline2 spline) {
        this.spline = spline;
        this.calculated = false;
        this.tolerance = 0.5f;
    }

    public void set(Spline2 spline) {
        this.reset();
        this.spline = spline;
    }

    public void reset() {
        this.calculated = false;
        this.pointBuff = new FloatArray();
        this.paramBuff = new FloatArray();
        this.anchorPts = new IntIntMap();
    }

    public void clear() {
        this.reset();
        this.spline = null;
    }

    public void calculate() {
        this.reset();
        if (this.spline == null) {
            return;
        }
        int size = this.spline.size();
        if (size <= 0) {
            return;
        }
        FloatArray points = this.spline.getControlPoints();
        for (int i = 0; i < size; ++i) {
            this.anchorPts.put(this.pointBuff.size / 2, i);
            this.generate(i, points.items[6 * i], points.items[6 * i + 1], points.items[6 * i + 2], points.items[6 * i + 3], points.items[6 * i + 4], points.items[6 * i + 5], points.items[6 * i + 6], points.items[6 * i + 7], 0);
        }
        this.anchorPts.put(this.pointBuff.size / 2, size);
        this.pointBuff.add(points.items[6 * size]);
        this.pointBuff.add(points.items[6 * size + 1]);
        this.paramBuff.add(size);
        this.closed = this.spline.isClosed();
        this.calculated = true;
    }

    private int generate(float t, float p0x, float p0y, float p1x, float p1y, float p2x, float p2y, float p3x, float p3y, int depth) {
        boolean terminate = false;
        if (depth >= 8) {
            terminate = true;
        } else if (p0x == p1x && p0y == p1y && p2x == p3x && p2y == p3y) {
            terminate = true;
        } else {
            float dx = p3x - p0x;
            float dy = p3y - p0y;
            float d2 = (p1x - p3x) * dy - (p1y - p3y) * dx;
            float d3 = (p2x - p3x) * dy - (p2y - p3y) * dx;
            d2 = d2 > 0.0f ? d2 : -d2;
            float f = d3 = d3 > 0.0f ? d3 : -d3;
            if ((d2 + d3) * (d2 + d3) < this.tolerance * (dx * dx + dy * dy)) {
                terminate = true;
            }
        }
        int result = 0;
        if (terminate) {
            this.paramBuff.add(t);
            this.pointBuff.add(p0x);
            this.pointBuff.add(p0y);
            this.pointBuff.add(p1x);
            this.pointBuff.add(p1y);
            this.pointBuff.add(p2x);
            this.pointBuff.add(p2y);
            return 1;
        }
        float hx = (p1x + p2x) * 0.5f;
        float hy = (p1y + p2y) * 0.5f;
        float l1x = (p0x + p1x) * 0.5f;
        float l1y = (p0y + p1y) * 0.5f;
        float l2x = (l1x + hx) * 0.5f;
        float l2y = (l1y + hy) * 0.5f;
        float r2x = (p2x + p3x) * 0.5f;
        float r2y = (p2y + p3y) * 0.5f;
        float r1x = (r2x + hx) * 0.5f;
        float r1y = (r2y + hy) * 0.5f;
        float cx = (l2x + r1x) * 0.5f;
        float cy = (l2y + r1y) * 0.5f;
        float s = t + 1.0f / (float)(1 << depth + 1);
        result = this.generate(t, p0x, p0y, l1x, l1y, l2x, l2y, cx, cy, depth + 1);
        return result += this.generate(s, cx, cy, r1x, r1y, r2x, r2y, p3x, p3y, depth + 1);
    }

    public Path2 getPath() {
        FloatArray points = this.getActivePoints();
        if (points == null) {
            return new Path2();
        }
        Path2 path = new Path2();
        int size = points.size / 2;
        int limit = this.isClosed() ? size - 4 : size - 1;
        int cap = (int)(Math.floor(limit / 3) + 1.0) * 2;
        path.vertices.ensureCapacity(cap);
        int ind = 0;
        int i = 0;
        while (i * 3 <= limit) {
            path.vertices.items[ind] = points.items[6 * i];
            path.vertices.items[ind + 1] = points.items[6 * i + 1];
            ind += 2;
            for (IntIntMap.Entry cur : this.anchorPts) {
                if (cur.key % 3 != 0 || this.spline.smooth.items[cur.value]) continue;
                path.corners.add(cur.key / 3);
            }
            ++i;
        }
        path.vertices.size = cap;
        path.closed = this.isClosed();
        return path;
    }

    public float[] getParameters() {
        float[] result;
        if (this.calculated) {
            result = new float[this.paramBuff.size];
            for (int i = 0; i < this.paramBuff.size; ++i) {
                result[i] = this.paramBuff.items[i];
            }
        } else if (this.spline != null) {
            result = new float[this.spline.size() + 1];
            for (int i = 0; i <= this.spline.size(); ++i) {
                result[i] = i;
            }
        } else {
            result = new float[]{};
        }
        return result;
    }

    public FloatArray getTangents() {
        FloatArray points = this.getActivePoints();
        FloatArray result = new FloatArray();
        if (points == null) {
            return result;
        }
        int size = points.size / 2;
        int cap = (int)(Math.floor((size - 1) / 3) * 4.0 + 2.0);
        result.ensureCapacity(cap);
        int ind = 0;
        int i = 0;
        while (3 * i < size - 1) {
            result.items[ind] = points.items[6 * i + 2] - points.items[6 * i];
            result.items[ind + 1] = points.items[6 * i + 3] - points.items[6 * i + 1];
            result.items[ind + 2] = points.items[6 * i + 4] - points.items[6 * i + 6];
            result.items[ind + 3] = points.items[6 * i + 5] - points.items[6 * i + 7];
            ind += 4;
            ++i;
        }
        result.items[ind] = points.items[(size - 2) * 2] - points.items[(size - 1) * 2];
        result.items[ind + 1] = points.items[(size - 2) * 2 + 1] - points.items[(size - 1) * 2 + 1];
        result.size = ind + 2;
        return result;
    }

    public FloatArray getNormals() {
        float t;
        float ty;
        float tx;
        FloatArray points = this.getActivePoints();
        FloatArray result = new FloatArray();
        if (points == null) {
            return result;
        }
        int size = points.size / 2;
        int cap = (int)(Math.floor((size - 1) / 3) * 2.0 + 2.0);
        result.ensureCapacity(cap);
        int ind = 0;
        int i = 0;
        while (3 * i < size - 1) {
            tx = points.items[(3 * i + 1) * 2] - points.items[3 * i * 2];
            ty = points.items[(3 * i + 1) * 2 + 1] - points.items[3 * i * 2 + 1];
            t = tx;
            tx = -ty;
            ty = t;
            result.items[ind] = tx;
            result.items[ind + 1] = ty;
            ind += 2;
            ++i;
        }
        tx = points.items[(size - 1) * 2] - points.items[(size - 2) * 2];
        ty = points.items[(size - 1) * 2 + 1] - points.items[(size - 2) * 2 + 1];
        t = tx;
        tx = -ty;
        ty = t;
        result.items[ind] = tx;
        result.items[ind + 1] = ty;
        result.size = ind + 2;
        return result;
    }

    private void fillHandle(float px, float py, float radius, int segments) {
        int offset = this.vertBuff.length / 2;
        float[] newV = new float[this.vertBuff.length + 4 + segments * 2];
        System.arraycopy(this.vertBuff, 0, newV, 0, this.vertBuff.length);
        newV[this.vertBuff.length] = px;
        newV[this.vertBuff.length + 1] = py;
        float coef = (float)(Math.PI * 2 / (double)segments);
        for (int i = 0; i <= segments * 2; i += 2) {
            float rads = (float)i * coef;
            float tx = (float)((double)(0.5f * radius) * Math.cos(rads));
            float ty = (float)((double)(0.5f * radius) * Math.sin(rads));
            newV[this.vertBuff.length + 2 + i] = tx;
            newV[this.vertBuff.length + 2 + i + 1] = ty;
        }
        this.vertBuff = newV;
        short[] newI = new short[this.indBuff.length + 3 * segments];
        System.arraycopy(this.indBuff, 0, newI, 0, this.indBuff.length);
        for (int i = 0; i < segments * 3; i += 3) {
            newI[this.indBuff.length + i] = (short)offset;
            newI[this.indBuff.length + i + 1] = (short)(offset + i + 1);
            newI[this.indBuff.length + i + 2] = (short)(offset + i + 2);
        }
        this.indBuff = newI;
    }

    public Poly2 getAnchors(float radius, int segments) {
        FloatArray points = this.getActivePoints();
        if (points == null) {
            return new Poly2();
        }
        int size = points.size / 2;
        int last = this.closed ? (size - 4) / 3 : (size - 1) / 3;
        this.vertBuff = new float[0];
        this.indBuff = new short[0];
        for (int i = 0; i <= last; ++i) {
            this.fillHandle(points.items[6 * i], points.items[6 * i + 1], radius, segments);
        }
        return new Poly2(this.vertBuff, this.indBuff);
    }

    public Poly2 getAnchors(float radius) {
        return this.getAnchors(radius, 4);
    }

    public Poly2 getHandle(float radius, int segments) {
        FloatArray points = this.getActivePoints();
        if (points == null) {
            return new Poly2(new float[0]);
        }
        int size = points.size / 2;
        this.vertBuff = new float[0];
        this.indBuff = new short[0];
        int i = 0;
        while (3 * i < size) {
            this.fillHandle(points.items[(3 * i + 1) * 2], points.items[(3 * i + 1) * 2 + 1], radius, segments);
            this.fillHandle(points.items[(3 * i + 2) * 2], points.items[(3 * i + 2) * 2 + 1], radius, segments);
            ++i;
        }
        return new Poly2(this.vertBuff, this.indBuff);
    }

    public Poly2 getHandle(float radius) {
        return this.getHandle(radius, 4);
    }

    public Spline2 getRefinement() {
        FloatArray points = this.getActivePoints();
        if (points == null) {
            return new Spline2();
        }
        Spline2 result = new Spline2(points.items, 0, points.size);
        result.setClosed(this.isClosed());
        return result;
    }

    private FloatArray getActivePoints() {
        if (this.calculated) {
            FloatArray result = new FloatArray(this.pointBuff.size);
            for (int i = 0; i < this.pointBuff.size; ++i) {
                result.items[i] = this.pointBuff.items[i];
            }
            result.size = this.pointBuff.size;
            return result;
        }
        if (this.spline != null) {
            return this.spline.getControlPoints();
        }
        return null;
    }

    private boolean isClosed() {
        return this.calculated ? this.closed : this.spline != null && this.spline.isClosed();
    }

    private boolean isAnchor(int pos) {
        return !this.calculated || this.anchorPts.containsKey(pos);
    }
}

