/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.graphics;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import edu.cornell.gdiac.graphics.SpriteMesh;
import edu.cornell.gdiac.math.Path2;
import edu.cornell.gdiac.math.Poly2;

public class TexturedMesh
extends SpriteMesh {
    private TextureRegion texture;

    public TexturedMesh() {
        this.texture = new TextureRegion();
    }

    public TexturedMesh(Texture texture) {
        super(new Rectangle(0.0f, 0.0f, texture.getWidth(), texture.getHeight()));
        this.texture = new TextureRegion(texture);
    }

    public TexturedMesh(TextureRegion region) {
        super(new Rectangle(0.0f, 0.0f, region.getRegionWidth(), region.getRegionHeight()));
        this.texture = new TextureRegion(this.texture);
    }

    public TexturedMesh(float[] vertices) {
        super(vertices);
        this.texture = new TextureRegion();
    }

    public TexturedMesh(float[] vertices, int voffset, int vlength) {
        super(vertices, voffset, vlength);
        this.texture = new TextureRegion();
    }

    public TexturedMesh(float[] vertices, short[] indices) {
        super(vertices, indices);
        this.texture = new TextureRegion();
    }

    public TexturedMesh(Poly2 poly) {
        super(poly);
        this.texture = new TextureRegion();
    }

    public TexturedMesh(Poly2 poly, Texture texture) {
        super(poly, texture != null ? (float)texture.getWidth() : 0.0f, texture != null ? (float)texture.getHeight() : 0.0f);
        this.texture = new TextureRegion(texture);
    }

    public TexturedMesh(Poly2 poly, TextureRegion region) {
        super(poly, region != null ? (float)region.getRegionWidth() : 0.0f, region != null ? (float)region.getRegionHeight() : 0.0f);
        this.texture = new TextureRegion(region);
    }

    public TexturedMesh(Path2 path) {
        super(path);
        this.texture = new TextureRegion();
    }

    public TexturedMesh(Path2 path, Texture texture) {
        super(path, texture != null ? (float)texture.getWidth() : 0.0f, texture != null ? (float)texture.getHeight() : 0.0f);
        this.texture = new TextureRegion(texture);
    }

    public TexturedMesh(Path2 path, TextureRegion region) {
        super(path, region != null ? (float)region.getRegionWidth() : 0.0f, region != null ? (float)region.getRegionHeight() : 0.0f);
        this.texture = new TextureRegion(region);
    }

    public TexturedMesh(SpriteMesh mesh) {
        super(mesh);
        if (mesh instanceof TexturedMesh) {
            TexturedMesh tmesh = (TexturedMesh)mesh;
            this.texture = new TextureRegion(tmesh.texture);
        }
    }

    public TexturedMesh(Rectangle rect) {
        super(rect);
        this.texture = new TextureRegion();
    }

    public TexturedMesh set(Poly2 poly, Texture texture) {
        int w = 0;
        int h = 0;
        if (texture != null) {
            w = texture.getWidth();
            h = texture.getHeight();
        }
        super.set(poly, (float)w, (float)h);
        this.texture.setTexture(texture);
        return this;
    }

    public TexturedMesh set(Poly2 poly, TextureRegion region) {
        int w = 0;
        int h = 0;
        if (this.texture != null) {
            w = this.texture.getRegionWidth();
            h = this.texture.getRegionHeight();
        }
        super.set(poly, (float)w, (float)h);
        this.setTextureRegion(region);
        return this;
    }

    public TexturedMesh set(Path2 path, Texture texture) {
        int w = 0;
        int h = 0;
        if (texture != null) {
            w = texture.getWidth();
            h = texture.getHeight();
        }
        super.set(path, (float)w, (float)h);
        this.texture.setTexture(texture);
        return this;
    }

    public TexturedMesh set(Path2 path, TextureRegion region) {
        int w = 0;
        int h = 0;
        if (this.texture != null) {
            w = this.texture.getRegionWidth();
            h = this.texture.getRegionHeight();
        }
        super.set(path, (float)w, (float)h);
        this.setTextureRegion(region);
        return this;
    }

    @Override
    public TexturedMesh set(SpriteMesh mesh) {
        super.set(mesh);
        if (mesh instanceof TexturedMesh) {
            this.setTextureRegion(((TexturedMesh)mesh).texture);
        }
        return this;
    }

    public TextureRegion getTextureRegion() {
        return this.texture;
    }

    public void setTexture(Texture texture) {
        this.texture.setTexture(texture);
    }

    public void setTextureRegion(TextureRegion region) {
        if (region == null) {
            this.texture.setTexture(null);
        } else {
            this.texture.setRegion(region);
        }
    }
}

