/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.graphics;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.TextureData;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import edu.cornell.gdiac.graphics.GLDebug;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;

public class Texture2D
extends Texture {
    private static byte[] cu_2x2_white_image = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    private GL20 gl;
    private static Texture2D BLANK = null;
    private PixelFormat pixelFormat;
    private String name;
    private int bindpoint;
    private IntBuffer query = BufferUtils.newByteBuffer(64).asIntBuffer();

    public Texture2D(String internalPath) {
        super(internalPath);
        this.pixelFormat = PixelFormat.gl30Format(this.getTextureData().getFormat());
        this.name = internalPath;
        this.gl = Gdx.gl30;
        if (this.gl == null) {
            this.gl = Gdx.gl20;
        }
    }

    public Texture2D(FileHandle file) {
        super(file);
        this.pixelFormat = PixelFormat.gl30Format(this.getTextureData().getFormat());
        this.name = file.toString();
        this.gl = Gdx.gl30;
        if (this.gl == null) {
            this.gl = Gdx.gl20;
        }
    }

    public Texture2D(FileHandle file, boolean mipMaps) {
        super(file, mipMaps);
        this.pixelFormat = PixelFormat.gl30Format(this.getTextureData().getFormat());
        this.name = file.toString();
        this.gl = Gdx.gl30;
        if (this.gl == null) {
            this.gl = Gdx.gl20;
        }
    }

    public Texture2D(Pixmap pixmap) {
        super(pixmap);
        this.pixelFormat = PixelFormat.gl30Format(this.getTextureData().getFormat());
        this.name = pixmap.toString();
        this.gl = Gdx.gl30;
        if (this.gl == null) {
            this.gl = Gdx.gl20;
        }
    }

    public Texture2D(Pixmap pixmap, boolean mipMaps) {
        super(pixmap, mipMaps);
        this.pixelFormat = PixelFormat.gl30Format(this.getTextureData().getFormat());
        this.name = pixmap.toString();
        this.gl = Gdx.gl30;
        if (this.gl == null) {
            this.gl = Gdx.gl20;
        }
    }

    public Texture2D(int width, int height) {
        this(null, width, height, PixelFormat.RGBA, false);
    }

    public Texture2D(int width, int height, PixelFormat format) {
        this(null, width, height, format, false);
    }

    public Texture2D(Buffer data, int width, int height) {
        this(data, width, height, PixelFormat.RGBA, false);
    }

    public Texture2D(Buffer data, int width, int height, PixelFormat format) {
        this(data, width, height, format, false);
    }

    public Texture2D(Buffer data, int width, int height, PixelFormat format, boolean mipMaps) {
        super(new GL30Data(data, width, height, format, mipMaps));
        this.pixelFormat = format;
        this.gl = Gdx.gl30;
        if (this.gl == null) {
            this.gl = Gdx.gl20;
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public static Texture2D getBlank() {
        if (BLANK == null) {
            ByteBuffer buffer = BufferUtils.newByteBuffer(cu_2x2_white_image.length);
            BufferUtils.copy(cu_2x2_white_image, 0, (Buffer)buffer, cu_2x2_white_image.length);
            BLANK = new Texture2D(buffer, 2, 2);
            BLANK.setWrap(Texture.TextureWrap.Repeat, Texture.TextureWrap.Repeat);
        }
        return BLANK;
    }

    public Texture2D setContents(Buffer data) {
        if (this.getTextureData().isManaged() || this.pixelFormat == PixelFormat.UNSUPPORTED) {
            throw new GdxRuntimeException("Texture does not support direct writes");
        }
        this.bind();
        int glFormat = this.pixelFormat.glFormat();
        int internal = this.pixelFormat.internalFormat();
        int datatype = this.pixelFormat.formatType();
        this.gl.glTexImage2D(3553, 0, glFormat, this.getWidth(), this.getHeight(), 0, internal, datatype, data);
        return this;
    }

    public static void setContents(Texture2D texture, Buffer data) {
        PixelFormat format = PixelFormat.gl30Format(texture.getTextureData().getFormat());
        if (texture.getTextureData().isManaged() || format == PixelFormat.UNSUPPORTED) {
            throw new GdxRuntimeException("Texture does not support direct writes");
        }
        GL20 gl = Gdx.gl30;
        if (gl == null) {
            gl = Gdx.gl20;
        }
        texture.bind();
        int glFormat = format.glFormat();
        int internal = format.internalFormat();
        int datatype = format.formatType();
        gl.glTexImage2D(3553, 0, glFormat, texture.getWidth(), texture.getHeight(), 0, internal, datatype, data);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getByteSize() {
        switch (this.pixelFormat) {
            case RGB: {
                return 3;
            }
            case RED: {
                return 1;
            }
            case RED_GREEN: {
                return 2;
            }
            case RGBA: 
            case DEPTH: 
            case DEPTH_STENCIL: {
                return 4;
            }
            case UNSUPPORTED: {
                return -1;
            }
        }
        return -1;
    }

    public PixelFormat getFormat() {
        return this.pixelFormat;
    }

    public int getBuffer() {
        return this.glHandle;
    }

    public int getBindPoint() {
        return this.bindpoint;
    }

    public void setBindPoint(int point, boolean unbind) {
        if (this.bindpoint == point) {
            return;
        }
        if (unbind) {
            this.gl.glGetIntegerv(34016, this.query);
            int orig = this.query.get();
            this.query.clear();
            if (orig != this.bindpoint + 33984) {
                this.gl.glActiveTexture(33984 + this.bindpoint);
            }
            this.gl.glGetIntegerv(32873, this.query);
            int bind = this.query.get();
            this.query.clear();
            if (bind == this.glHandle) {
                this.gl.glBindTexture(3553, 0);
            }
            if (orig != this.bindpoint + 33984) {
                this.gl.glActiveTexture(orig);
            }
            int error = this.gl.glGetError();
            assert (error == 0) : "Texture: " + GLDebug.errorName(error);
        }
        this.bindpoint = point;
    }

    @Override
    public void bind() {
        GL20 gl = Gdx.gl30;
        if (gl == null) {
            gl = Gdx.gl20;
        }
        gl.glActiveTexture(33984 + this.bindpoint);
        gl.glBindTexture(3553, this.glHandle);
    }

    @Override
    public void bind(int bindpoint) {
        if (bindpoint != this.bindpoint) {
            this.bindpoint = bindpoint;
        }
        this.gl.glActiveTexture(33984 + bindpoint);
        this.gl.glBindTexture(3553, this.glHandle);
    }

    public void unbind() {
        this.unbind(false);
    }

    public void unbind(boolean restore) {
        int orig = 0;
        if (restore) {
            this.gl.glGetIntegerv(34016, this.query);
            orig = this.query.get();
            this.query.clear();
        }
        this.gl.glBindTexture(3553, 0);
        if (restore) {
            if (orig != this.bindpoint + 33984) {
                this.gl.glActiveTexture(orig);
            }
        }
    }

    public boolean isBound() {
        this.gl.glGetIntegerv(34016, this.query);
        int orig = this.query.get();
        this.query.clear();
        if (orig != this.bindpoint + 33984) {
            this.gl.glActiveTexture(33984 + this.bindpoint);
        }
        this.gl.glGetIntegerv(32873, this.query);
        int bind = this.query.get();
        this.query.clear();
        boolean result = bind == this.glHandle;
        if (orig != this.bindpoint + 33984) {
            this.gl.glActiveTexture(orig);
        }
        return result;
    }

    public boolean isActive() {
        this.gl.glGetIntegerv(34016, this.query);
        int orig = this.query.get();
        this.query.clear();
        if (orig != this.bindpoint + 33984) {
            return false;
        }
        this.gl.glGetIntegerv(32873, this.query);
        int bind = this.query.get();
        this.query.clear();
        return bind == this.glHandle;
    }

    @Override
    public String toString() {
        Object result = "Texture[";
        result = (String)result + "data: " + this.getName() + ",";
        result = (String)result + "w:" + this.getWidth() + ",";
        result = (String)result + "h:" + this.getWidth();
        result = (String)result + "]";
        return result;
    }

    public static enum PixelFormat {
        RGBA,
        RGB,
        RED,
        RED_GREEN,
        DEPTH,
        DEPTH_STENCIL,
        UNSUPPORTED;


        public int glFormat() {
            switch (this) {
                case RGBA: {
                    return 6408;
                }
                case RGB: {
                    return 6407;
                }
                case RED: {
                    return 6403;
                }
                case DEPTH: {
                    return 6402;
                }
                case DEPTH_STENCIL: {
                    return 34041;
                }
                case UNSUPPORTED: {
                    throw new GdxRuntimeException("Format not supported by GL30");
                }
            }
            return 6408;
        }

        public int internalFormat() {
            switch (this) {
                case RGBA: {
                    return 32856;
                }
                case RGB: {
                    return 32849;
                }
                case RED: {
                    return 33321;
                }
                case RED_GREEN: {
                    return 33323;
                }
                case DEPTH: {
                    return 36012;
                }
                case DEPTH_STENCIL: {
                    return 35056;
                }
                case UNSUPPORTED: {
                    throw new GdxRuntimeException("Format not supported by GL30");
                }
            }
            return 32856;
        }

        public int formatType() {
            switch (this) {
                case RGBA: 
                case RGB: 
                case RED: 
                case RED_GREEN: {
                    return 5121;
                }
                case DEPTH: {
                    return 5126;
                }
                case DEPTH_STENCIL: {
                    return 34042;
                }
                case UNSUPPORTED: {
                    throw new GdxRuntimeException("Format not supported by GL30");
                }
            }
            return 5121;
        }

        public int byteSize() {
            switch (this) {
                case RGB: {
                    return 3;
                }
                case RED: {
                    return 1;
                }
                case RED_GREEN: {
                    return 2;
                }
                case RGBA: 
                case DEPTH: 
                case DEPTH_STENCIL: {
                    return 4;
                }
                case UNSUPPORTED: {
                    return -1;
                }
            }
            return -1;
        }

        public static PixelFormat gl30Format(Pixmap.Format format) {
            switch (format) {
                case Alpha: {
                    return RED;
                }
                case Intensity: {
                    return RED;
                }
                case LuminanceAlpha: {
                    return RED_GREEN;
                }
                case RGB565: 
                case RGBA4444: {
                    return UNSUPPORTED;
                }
                case RGB888: {
                    return RGB;
                }
                case RGBA8888: {
                    return RGBA;
                }
            }
            return RGBA;
        }
    }

    private static class GL30Data
    implements TextureData {
        private int glHandle;
        private Buffer data;
        private int width;
        private int height;
        private boolean mipmaps;
        private PixelFormat format;
        private IntBuffer query = BufferUtils.newByteBuffer(64).asIntBuffer();

        public GL30Data(Buffer data, int width, int height, PixelFormat format, boolean mipMaps) {
            this.data = data;
            this.width = width;
            this.height = height;
            this.format = format;
            this.mipmaps = mipMaps;
            this.glHandle = 0;
        }

        @Override
        public TextureData.TextureDataType getType() {
            return TextureData.TextureDataType.Custom;
        }

        @Override
        public boolean isPrepared() {
            return true;
        }

        @Override
        public void prepare() {
            throw new GdxRuntimeException("Unsupported operation");
        }

        @Override
        public Pixmap consumePixmap() {
            throw new GdxRuntimeException("OpenGLES does not support data from dynamic textures.");
        }

        @Override
        public boolean disposePixmap() {
            return true;
        }

        @Override
        public void consumeCustomData(int target) {
            if (this.width <= 0 || this.height <= 0) {
                throw new GdxRuntimeException(String.format("Texture size %dx%d is not valid", this.width, this.height));
            }
            if (this.glHandle > 0) {
                assert (false) : "Texture is already initialized";
                return;
            }
            GL20 gl = Gdx.gl30;
            if (gl == null) {
                gl = Gdx.gl20;
            }
            gl.glGetIntegerv(32873, this.query);
            this.glHandle = this.query.get();
            this.query.clear();
            int glFormat = this.format.glFormat();
            int internal = this.format.internalFormat();
            int datatype = this.format.formatType();
            gl.glTexImage2D(3553, 0, internal, this.width, this.height, 0, glFormat, datatype, this.data);
            int error = gl.glGetError();
            if (error != 0) {
                Gdx.app.error("OPENGL", String.format("Could not initialize texture. %s", GLDebug.errorName(error)));
                return;
            }
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public Pixmap.Format getFormat() {
            switch (this.format) {
                case RGB: {
                    return Pixmap.Format.RGB888;
                }
                case RED: {
                    return Pixmap.Format.Alpha;
                }
                case RED_GREEN: {
                    return Pixmap.Format.LuminanceAlpha;
                }
            }
            return Pixmap.Format.RGBA8888;
        }

        @Override
        public boolean useMipMaps() {
            return this.mipmaps;
        }

        @Override
        public boolean isManaged() {
            return false;
        }
    }
}

