/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.graphics;

public class TextAlign {
    public static final int center = 1;
    public static final int top = 2;
    public static final int bottom = 4;
    public static final int left = 8;
    public static final int right = 16;
    public static final int middle = 32;
    public static final int baseline = 64;
    public static final int topLeft = 10;
    public static final int topCenter = 3;
    public static final int topRight = 18;
    public static final int bottomLeft = 12;
    public static final int bottomCenter = 5;
    public static final int bottomRight = 20;
    public static final int middleLeft = 40;
    public static final int middleCenter = 33;
    public static final int middleRight = 48;
    public static final int baselineLeft = 72;
    public static final int baselineCenter = 65;
    public static final int baselineRight = 80;

    public static final boolean isLeft(int align) {
        return (align & 8) != 0;
    }

    public static final boolean isRight(int align) {
        return (align & 0x10) != 0;
    }

    public static final boolean isCenter(int align) {
        return (align & 1) != 0 || (align & 8) == 0 && (align & 0x10) == 0;
    }

    public static final boolean isTop(int align) {
        return (align & 2) != 0;
    }

    public static final boolean isBottom(int align) {
        return (align & 4) != 0;
    }

    public static final boolean isMiddle(int align) {
        return (align & 0x20) != 0 || (align & 2) == 0 && (align & 4) == 0 && (align & 0x40) == 0;
    }

    public static final boolean isBaseline(int align) {
        return (align & 0x40) != 0;
    }

    public static final int normalize(int align) {
        int result = 0;
        result = (align & 1) != 0 ? (result |= 1) : ((align & 8) != 0 ? (result |= 8) : ((align & 0x10) != 0 ? (result |= 0x10) : (result |= 1)));
        result = (align & 0x20) != 0 ? (result |= 0x20) : ((align & 0x40) != 0 ? (result |= 0x40) : ((align & 2) != 0 ? (result |= 2) : ((align & 4) != 0 ? (result |= 4) : (result |= 0x20))));
        return result;
    }

    public static String toString(int align) {
        StringBuilder buffer = new StringBuilder(16);
        if ((align & 0x20) != 0) {
            buffer.append("middle,");
        } else if ((align & 2) != 0) {
            buffer.append("top,");
        } else if ((align & 4) != 0) {
            buffer.append("bottom,");
        } else if ((align & 0x40) != 0) {
            buffer.append("baseline,");
        } else {
            buffer.append("middle,");
        }
        if ((align & 1) != 0) {
            buffer.append("center");
        } else if ((align & 8) != 0) {
            buffer.append("left");
        } else if ((align & 0x10) != 0) {
            buffer.append("right");
        } else {
            buffer.append("center");
        }
        return buffer.toString();
    }
}

