/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.graphics;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.FloatArray;
import com.badlogic.gdx.utils.NumberUtils;
import com.badlogic.gdx.utils.ShortArray;
import edu.cornell.gdiac.math.Path2;
import edu.cornell.gdiac.math.Poly2;

public class SpriteMesh {
    public int command;
    public FloatArray vertices;
    public ShortArray indices;
    private int stride;
    private Vector2 temp0 = new Vector2();
    private Vector2 temp1 = new Vector2();
    private Vector2 vectorCache = new Vector2();

    public SpriteMesh() {
        this.vertices = new FloatArray();
        this.indices = new ShortArray();
        this.command = 0;
        this.stride = Gdx.gl30 == null ? 5 : 7;
    }

    public SpriteMesh(float[] vertices) {
        this.vertices = new FloatArray(vertices);
        this.indices = new ShortArray();
        this.command = 0;
        this.stride = Gdx.gl30 == null ? 5 : 7;
    }

    public SpriteMesh(float[] vertices, int voffset, int vlength) {
        this.vertices = new FloatArray(vlength);
        this.vertices.addAll(vertices, voffset, vlength);
        this.indices = new ShortArray();
        this.command = 0;
        this.stride = Gdx.gl30 == null ? 5 : 7;
    }

    public SpriteMesh(float[] vertices, short[] indices) {
        this.vertices = new FloatArray(vertices);
        this.indices = new ShortArray(indices);
        if (indices.length % 3 == 0) {
            this.command = 4;
        } else if (indices.length % 2 == 0) {
            this.command = 1;
        }
        this.stride = Gdx.gl30 == null ? 5 : 7;
    }

    public SpriteMesh(Poly2 poly) {
        this.vertices = new FloatArray();
        this.indices = new ShortArray();
        this.stride = Gdx.gl30 == null ? 5 : 7;
        this.set(poly);
    }

    public SpriteMesh(Poly2 poly, float width, float height) {
        this.vertices = new FloatArray();
        this.indices = new ShortArray();
        this.stride = Gdx.gl30 == null ? 5 : 7;
        this.set(poly, 0.0f, 0.0f, width, height);
    }

    public SpriteMesh(Poly2 poly, float x, float y, float width, float height) {
        this.vertices = new FloatArray();
        this.indices = new ShortArray();
        this.stride = Gdx.gl30 == null ? 5 : 7;
        this.set(poly, x, y, width, height);
    }

    public SpriteMesh(Poly2 poly, Rectangle rect) {
        this.vertices = new FloatArray();
        this.indices = new ShortArray();
        this.stride = Gdx.gl30 == null ? 5 : 7;
        this.set(poly, rect.x, rect.y, rect.width, rect.height);
    }

    public SpriteMesh(Path2 path) {
        this.vertices = new FloatArray();
        this.indices = new ShortArray();
        this.stride = Gdx.gl30 == null ? 5 : 7;
        this.set(path);
    }

    public SpriteMesh(Path2 path, float width, float height) {
        this.vertices = new FloatArray();
        this.indices = new ShortArray();
        this.stride = Gdx.gl30 == null ? 5 : 7;
        this.set(path, 0.0f, 0.0f, width, height);
    }

    public SpriteMesh(Path2 path, float x, float y, float width, float height) {
        this.vertices = new FloatArray();
        this.indices = new ShortArray();
        this.stride = Gdx.gl30 == null ? 5 : 7;
        this.set(path, x, y, width, height);
    }

    public SpriteMesh(Path2 path, Rectangle rect) {
        this.vertices = new FloatArray();
        this.indices = new ShortArray();
        this.stride = Gdx.gl30 == null ? 5 : 7;
        this.set(path, rect.x, rect.y, rect.width, rect.height);
    }

    public SpriteMesh(SpriteMesh mesh) {
        this.vertices = new FloatArray();
        this.indices = new ShortArray();
        this.vertices.addAll(mesh.vertices);
        this.indices.addAll(mesh.indices);
        this.command = mesh.command;
        this.stride = mesh.stride;
    }

    public SpriteMesh(Rectangle rect) {
        this.vertices = new FloatArray();
        this.indices = new ShortArray();
        this.stride = Gdx.gl30 == null ? 5 : 7;
        this.set(rect);
    }

    public SpriteMesh(float x, float y, float width, float height) {
        this.vertices = new FloatArray();
        this.indices = new ShortArray();
        this.stride = Gdx.gl30 == null ? 5 : 7;
        this.set(x, y, width, height);
    }

    public SpriteMesh mul(Matrix4 transform) {
        for (int ii = 0; ii < this.vertexCount(); ++ii) {
            float x = this.vertices.items[ii * this.stride] * transform.val[0] + this.vertices.items[ii * this.stride + 1] * transform.val[4] + transform.val[12];
            float y = this.vertices.items[ii * this.stride] * transform.val[1] + this.vertices.items[ii * this.stride + 1] * transform.val[5] + transform.val[13];
            float w = this.vertices.items[ii * this.stride] * transform.val[3] + this.vertices.items[ii * this.stride + 1] * transform.val[7] + transform.val[15];
            float d = w != 0.0f ? 1.0f / w : 1.0f;
            this.vertices.items[ii * this.stride] = x * d;
            this.vertices.items[ii * this.stride + 1] = y * d;
        }
        return this;
    }

    public int getStride() {
        return this.stride;
    }

    public SpriteMesh set(float[] vertices) {
        this.vertices.clear();
        this.vertices.addAll(vertices);
        this.indices.clear();
        this.command = 0;
        return this;
    }

    public SpriteMesh set(float[] vertices, int voffset, int vlength) {
        this.vertices.clear();
        this.vertices.addAll(vertices, voffset, vlength);
        this.indices.clear();
        this.command = 0;
        return this;
    }

    public SpriteMesh set(Poly2 poly) {
        return this.set(poly, 0.0f, 0.0f);
    }

    public SpriteMesh set(Poly2 poly, float width, float height) {
        float color = Color.WHITE.toFloatBits();
        int vsize = poly.vertices.size / 2;
        this.vertices.clear();
        this.vertices.ensureCapacity(this.stride * vsize);
        for (int ii = 0; ii < vsize; ++ii) {
            float x = poly.vertices.items[2 * ii];
            float y = poly.vertices.items[2 * ii + 1];
            this.vertices.items[ii * this.stride] = x;
            this.vertices.items[ii * this.stride + 1] = y;
            this.vertices.items[ii * this.stride + 2] = color;
            this.vertices.items[ii * this.stride + 3] = width > 0.0f ? x / width : 0.0f;
            float f = this.vertices.items[ii * this.stride + 4] = height > 0.0f ? 1.0f - y / height : 0.0f;
            if (this.stride <= 5) continue;
            this.vertices.items[ii * this.stride + 5] = width > 0.0f ? x / width : 0.0f;
            this.vertices.items[ii * this.stride + 6] = height > 0.0f ? 1.0f - y / height : 0.0f;
        }
        this.vertices.size = this.stride * vsize;
        this.indices.clear();
        this.indices.ensureCapacity(poly.indices.size);
        System.arraycopy(poly.indices.items, 0, this.indices.items, 0, poly.indices.size);
        this.indices.size = poly.indices.size;
        this.command = 4;
        return this;
    }

    public SpriteMesh set(Poly2 poly, float x, float y, float width, float height) {
        float color = Color.WHITE.toFloatBits();
        int vsize = poly.vertices.size / 2;
        this.vertices.clear();
        this.vertices.ensureCapacity(this.stride * vsize);
        for (int ii = 0; ii < vsize; ++ii) {
            float x0 = poly.vertices.items[2 * ii];
            float y0 = poly.vertices.items[2 * ii + 1];
            float s = width > 0.0f ? (x0 - x) / width : 0.0f;
            float t = height > 0.0f ? 1.0f - (y0 - y) / height : 0.0f;
            this.vertices.items[ii * this.stride] = x0;
            this.vertices.items[ii * this.stride + 1] = y0;
            this.vertices.items[ii * this.stride + 2] = color;
            this.vertices.items[ii * this.stride + 3] = s;
            this.vertices.items[ii * this.stride + 4] = t;
            if (this.stride <= 5) continue;
            this.vertices.items[ii * this.stride + 5] = s;
            this.vertices.items[ii * this.stride + 6] = t;
        }
        this.vertices.size = this.stride * vsize;
        this.indices.clear();
        this.indices.ensureCapacity(poly.indices.size);
        System.arraycopy(poly.indices.items, 0, this.indices.items, 0, poly.indices.size);
        this.indices.size = poly.indices.size;
        this.command = 4;
        return this;
    }

    public SpriteMesh set(Poly2 poly, Rectangle rect) {
        return this.set(poly, rect.x, rect.y, rect.width, rect.height);
    }

    public SpriteMesh set(Path2 path) {
        return this.set(path, 0.0f, 0.0f);
    }

    public SpriteMesh set(Path2 path, float width, float height) {
        int ii;
        float color = Color.WHITE.toFloatBits();
        int vsize = path.vertices.size / 2;
        this.vertices.clear();
        this.vertices.ensureCapacity(this.stride * vsize);
        for (ii = 0; ii < vsize; ++ii) {
            float x = path.vertices.items[2 * ii];
            float y = path.vertices.items[2 * ii + 1];
            this.vertices.items[ii * this.stride] = x;
            this.vertices.items[ii * this.stride + 1] = y;
            this.vertices.items[ii * this.stride + 2] = color;
            this.vertices.items[ii * this.stride + 3] = width > 0.0f ? x / width : 0.0f;
            float f = this.vertices.items[ii * this.stride + 4] = height > 0.0f ? 1.0f - y / height : 0.0f;
            if (this.stride <= 5) continue;
            this.vertices.items[ii * this.stride + 5] = width > 0.0f ? x / width : 0.0f;
            this.vertices.items[ii * this.stride + 6] = height > 0.0f ? 1.0f - y / height : 0.0f;
        }
        this.vertices.size = this.stride * vsize;
        this.indices.clear();
        this.indices.ensureCapacity(path.indexSize());
        for (ii = 0; ii < vsize - 1; ++ii) {
            this.indices.items[2 * ii] = (short)ii;
            this.indices.items[2 * ii + 1] = (short)(ii + 1);
        }
        if (path.closed) {
            this.indices.items[2 * vsize - 2] = (short)(vsize - 1);
            this.indices.items[2 * vsize - 1] = 0;
        }
        this.indices.size = path.indexSize();
        this.command = 1;
        return this;
    }

    public SpriteMesh set(Path2 path, float x, float y, float width, float height) {
        int ii;
        float color = Color.WHITE.toFloatBits();
        int vsize = path.vertices.size / 2;
        this.vertices.clear();
        this.vertices.ensureCapacity(this.stride * vsize);
        for (ii = 0; ii < vsize; ++ii) {
            float x0 = path.vertices.items[2 * ii];
            float y0 = path.vertices.items[2 * ii + 1];
            float s = width > 0.0f ? (x0 - x) / width : 0.0f;
            float t = height > 0.0f ? 1.0f - (y0 - y) / width : 0.0f;
            this.vertices.items[ii * this.stride] = x0;
            this.vertices.items[ii * this.stride + 1] = y0;
            this.vertices.items[ii * this.stride + 2] = color;
            this.vertices.items[ii * this.stride + 3] = s;
            this.vertices.items[ii * this.stride + 4] = t;
            if (this.stride <= 5) continue;
            this.vertices.items[ii * this.stride + 5] = s;
            this.vertices.items[ii * this.stride + 6] = t;
        }
        this.vertices.size = this.stride * vsize;
        this.indices.clear();
        this.indices.ensureCapacity(path.indexSize());
        for (ii = 0; ii < vsize - 1; ++ii) {
            this.indices.items[2 * ii] = (short)ii;
            this.indices.items[2 * ii + 1] = (short)(ii + 1);
        }
        if (path.closed) {
            this.indices.items[2 * vsize - 2] = (short)(vsize - 1);
            this.indices.items[2 * vsize - 1] = 0;
        }
        this.indices.size = path.indexSize();
        this.command = 1;
        return this;
    }

    public SpriteMesh set(Path2 path, Rectangle rect) {
        return this.set(path, rect.x, rect.y, rect.width, rect.height);
    }

    public SpriteMesh set(SpriteMesh mesh) {
        this.vertices.clear();
        this.vertices.addAll(mesh.vertices);
        this.indices.clear();
        this.indices.addAll(mesh.indices);
        this.command = mesh.command;
        return this;
    }

    public SpriteMesh set(Rectangle rect) {
        return this.set(rect.x, rect.y, rect.width, rect.height);
    }

    public SpriteMesh set(float x, float y, float width, float height) {
        float color = Color.WHITE.toFloatBits();
        this.vertices.clear();
        this.vertices.ensureCapacity(4 * this.stride);
        this.vertices.size = 4 * this.stride;
        this.vertices.items[0] = x;
        this.vertices.items[1] = y;
        this.vertices.items[2] = color;
        this.vertices.items[3] = 0.0f;
        this.vertices.items[4] = 1.0f;
        this.vertices.items[this.stride] = x + width;
        this.vertices.items[this.stride + 1] = y;
        this.vertices.items[this.stride + 2] = color;
        this.vertices.items[this.stride + 3] = 1.0f;
        this.vertices.items[this.stride + 4] = 1.0f;
        this.vertices.items[2 * this.stride] = x + width;
        this.vertices.items[2 * this.stride + 1] = y + height;
        this.vertices.items[2 * this.stride + 2] = color;
        this.vertices.items[2 * this.stride + 3] = 1.0f;
        this.vertices.items[2 * this.stride + 4] = 0.0f;
        this.vertices.items[3 * this.stride] = x;
        this.vertices.items[3 * this.stride + 1] = y + height;
        this.vertices.items[3 * this.stride + 2] = color;
        this.vertices.items[3 * this.stride + 3] = 0.0f;
        this.vertices.items[3 * this.stride + 4] = 0.0f;
        if (this.stride > 5) {
            for (int ii = 0; ii < 4; ++ii) {
                this.vertices.items[ii * this.stride + 5] = this.vertices.items[ii * this.stride + 3];
                this.vertices.items[ii * this.stride + 6] = this.vertices.items[ii * this.stride + 4];
            }
        }
        this.indices.clear();
        this.indices.ensureCapacity(6);
        this.indices.size = 6;
        this.indices.items[0] = 0;
        this.indices.items[1] = 1;
        this.indices.items[2] = 2;
        this.indices.items[3] = 0;
        this.indices.items[4] = 2;
        this.indices.items[5] = 3;
        this.command = 4;
        return this;
    }

    public SpriteMesh setIndices(short[] indices) {
        this.indices.clear();
        this.indices.addAll(indices);
        return this;
    }

    public SpriteMesh setIndices(short[] indices, int ioffset, int ilength) {
        this.indices.clear();
        this.indices.addAll(indices, ioffset, ilength);
        return this;
    }

    public void clear() {
        this.vertices.clear();
        this.indices.clear();
        this.command = 0;
    }

    public int vertexCount() {
        return this.vertices.size / this.stride;
    }

    public int indexCount() {
        return this.indices.size;
    }

    public float getPositionX(int idx) {
        return this.vertices.items[idx * this.stride];
    }

    public float getPositionY(int idx) {
        return this.vertices.items[idx * this.stride + 1];
    }

    public Vector2 getPosition(int idx) {
        int pos = idx * this.stride;
        return new Vector2(this.vertices.items[pos], this.vertices.items[pos + 1]);
    }

    public Vector2 getPosition(int idx, Vector2 v) {
        int pos = idx * this.stride;
        if (v == null) {
            return new Vector2(this.vertices.items[pos], this.vertices.items[pos + 1]);
        }
        v.set(this.vertices.items[pos], this.vertices.items[pos + 1]);
        return v;
    }

    public void setPosition(int idx, Vector2 v) {
        this.setPosition(idx, v.x, v.y);
    }

    public void setPosition(int idx, float x, float y) {
        int pos = idx * this.stride;
        this.vertices.items[pos] = x;
        this.vertices.items[pos + 1] = y;
    }

    public float getPackedColor(int idx) {
        return this.vertices.items[idx * this.stride + 2];
    }

    public void setPackedColor(int idx, float c) {
        this.vertices.items[idx * this.stride + 2] = c;
    }

    public Color getColor(int idx) {
        int rgba = NumberUtils.floatToIntColor(this.vertices.items[idx * this.stride + 2]);
        return new Color(rgba);
    }

    public Color getColor(int idx, Color c) {
        int rgba = NumberUtils.floatToIntColor(this.vertices.items[idx * this.stride + 2]);
        if (c == null) {
            return new Color(rgba);
        }
        c.set(rgba);
        return c;
    }

    public void setColor(int idx, Color c) {
        this.vertices.items[idx * this.stride + 2] = c.toFloatBits();
    }

    public float getTextureX(int idx) {
        return this.vertices.items[idx * this.stride + 3];
    }

    public float getTextureY(int idx) {
        return this.vertices.items[idx * this.stride + 4];
    }

    public Vector2 getTextureCoord(int idx) {
        int pos = idx * this.stride;
        return new Vector2(this.vertices.items[pos + 3], this.vertices.items[pos + 4]);
    }

    public Vector2 getTextureCoord(int idx, Vector2 v) {
        int pos = idx * this.stride;
        if (v == null) {
            return new Vector2(this.vertices.items[pos + 3], this.vertices.items[pos + 4]);
        }
        v.set(this.vertices.items[pos + 3], this.vertices.items[pos + 4]);
        return v;
    }

    public void setTextureCoord(int idx, Vector2 v) {
        this.setTextureCoord(idx, v.x, v.y);
    }

    public void setTextureCoord(int idx, float x, float y) {
        int pos = idx * this.stride;
        this.vertices.items[pos + 3] = x;
        this.vertices.items[pos + 4] = y;
    }

    public float getGradientX(int idx) {
        if (this.stride < 7) {
            return 0.0f;
        }
        return this.vertices.items[idx * this.stride + 5];
    }

    public float getGradientY(int idx) {
        if (this.stride < 7) {
            return 0.0f;
        }
        return this.vertices.items[idx * this.stride + 6];
    }

    public Vector2 getGradientCoord(int idx) {
        if (this.stride < 7) {
            return new Vector2();
        }
        int pos = idx * this.stride;
        return new Vector2(this.vertices.items[pos + 5], this.vertices.items[pos + 6]);
    }

    public Vector2 getGradientCoord(int idx, Vector2 v) {
        if (this.stride < 7) {
            if (v == null) {
                return new Vector2();
            }
            v.set(0.0f, 0.0f);
            return v;
        }
        int pos = idx * this.stride;
        if (v == null) {
            return new Vector2(this.vertices.items[pos + 5], this.vertices.items[pos + 6]);
        }
        v.set(this.vertices.items[pos + 5], this.vertices.items[pos + 6]);
        return v;
    }

    public void setGradientCoord(int idx, Vector2 v) {
        this.setGradientCoord(idx, v.x, v.y);
    }

    public void setGradientCoord(int idx, float x, float y) {
        if (this.stride < 7) {
            return;
        }
        int pos = idx * this.stride;
        this.vertices.items[pos + 5] = x;
        this.vertices.items[pos + 6] = y;
    }

    public SpriteMesh scl(float scale) {
        for (int ii = 0; ii < this.vertices.size; ii += this.stride) {
            int n = ii;
            this.vertices.items[n] = this.vertices.items[n] * scale;
            int n2 = ii + 1;
            this.vertices.items[n2] = this.vertices.items[n2] * scale;
        }
        return this;
    }

    public SpriteMesh scl(Vector2 scale) {
        for (int ii = 0; ii < this.vertices.size; ii += this.stride) {
            int n = ii;
            this.vertices.items[n] = this.vertices.items[n] * scale.x;
            int n2 = ii + 1;
            this.vertices.items[n2] = this.vertices.items[n2] * scale.y;
        }
        return this;
    }

    public SpriteMesh div(float scale) {
        if (scale == 0.0f) {
            throw new ArithmeticException("Divided by zero operation cannot possible");
        }
        return this.scl(1.0f / scale);
    }

    public SpriteMesh div(Vector2 scale) {
        if (scale.x == 0.0f || scale.y == 0.0f) {
            throw new ArithmeticException("Divided by zero operation cannot possible");
        }
        this.temp1.set(1.0f / scale.x, 1.0f / scale.y);
        return this.scl(this.temp1);
    }

    public SpriteMesh add(float offset) {
        for (int ii = 0; ii < this.vertices.size; ii += this.stride) {
            int n = ii;
            this.vertices.items[n] = this.vertices.items[n] + offset;
            int n2 = ii + 1;
            this.vertices.items[n2] = this.vertices.items[n2] + offset;
        }
        return this;
    }

    public SpriteMesh add(Vector2 offset) {
        for (int ii = 0; ii < this.vertices.size; ii += this.stride) {
            int n = ii;
            this.vertices.items[n] = this.vertices.items[n] + offset.x;
            int n2 = ii + 1;
            this.vertices.items[n2] = this.vertices.items[n2] + offset.y;
        }
        return this;
    }

    public SpriteMesh add(float x, float y) {
        for (int ii = 0; ii < this.vertices.size; ii += this.stride) {
            int n = ii;
            this.vertices.items[n] = this.vertices.items[n] + x;
            int n2 = ii + 1;
            this.vertices.items[n2] = this.vertices.items[n2] + y;
        }
        return this;
    }

    public SpriteMesh sub(float offset) {
        for (int ii = 0; ii < this.vertices.size; ii += this.stride) {
            int n = ii;
            this.vertices.items[n] = this.vertices.items[n] - offset;
            int n2 = ii + 1;
            this.vertices.items[n2] = this.vertices.items[n2] - offset;
        }
        return this;
    }

    public SpriteMesh sub(Vector2 offset) {
        for (int ii = 0; ii < this.vertices.size; ii += this.stride) {
            int n = ii;
            this.vertices.items[n] = this.vertices.items[n] - offset.x;
            int n2 = ii + 1;
            this.vertices.items[n2] = this.vertices.items[n2] - offset.y;
        }
        return this;
    }

    public SpriteMesh sub(float x, float y) {
        for (int ii = 0; ii < this.vertices.size; ii += this.stride) {
            int n = ii;
            this.vertices.items[n] = this.vertices.items[n] - x;
            int n2 = ii + 1;
            this.vertices.items[n2] = this.vertices.items[n2] - y;
        }
        return this;
    }

    public SpriteMesh transform(Affine2 matrix) {
        for (int ii = 0; ii < this.vertices.size; ii += this.stride) {
            this.vectorCache.set(this.vertices.items[ii], this.vertices.items[ii + 1]);
            matrix.applyTo(this.vectorCache);
            this.vertices.items[ii] = this.vectorCache.x;
            this.vertices.items[ii + 1] = this.vectorCache.y;
        }
        return this;
    }

    public SpriteMesh transform(Affine2 matrix, int offset, int count) {
        if (offset + count > this.vertexCount()) {
            throw new IndexOutOfBoundsException("offset+count exceeds number of vertices");
        }
        for (int ii = offset * this.stride; ii < count * this.stride; ii += this.stride) {
            this.vectorCache.set(this.vertices.items[ii], this.vertices.items[ii + 1]);
            matrix.applyTo(this.vectorCache);
            this.vertices.items[ii] = this.vectorCache.x;
            this.vertices.items[ii + 1] = this.vectorCache.y;
        }
        return this;
    }

    public void push(Vector2 position) {
        this.push(position.x, position.y);
    }

    public void push(float x, float y) {
        this.vertices.ensureCapacity(this.stride);
        int idx = this.vertices.size;
        this.vertices.items[idx++] = x;
        this.vertices.items[idx++] = y;
        this.vertices.items[idx++] = Color.WHITE_FLOAT_BITS;
        this.vertices.items[idx++] = 0.0f;
        this.vertices.items[idx++] = 0.0f;
        if (this.stride > 5) {
            this.vertices.items[idx++] = 0.0f;
            this.vertices.items[idx++] = 0.0f;
        }
        this.vertices.size += this.stride;
    }

    public void push(Vector2 position, Vector2 texcoord) {
        this.push(position.x, position.y, texcoord.x, texcoord.y);
    }

    public void push(float x, float y, float tx, float ty) {
        this.vertices.ensureCapacity(this.stride);
        int idx = this.vertices.size;
        this.vertices.items[idx++] = x;
        this.vertices.items[idx++] = y;
        this.vertices.items[idx++] = Color.WHITE_FLOAT_BITS;
        this.vertices.items[idx++] = tx;
        this.vertices.items[idx++] = ty;
        if (this.stride > 5) {
            this.vertices.items[idx++] = tx;
            this.vertices.items[idx++] = ty;
        }
        this.vertices.size += this.stride;
    }

    public void push(Vector2 position, Color color, Vector2 texcoord) {
        this.push(position.x, position.y, color, texcoord.x, texcoord.y, texcoord.x, texcoord.y);
    }

    public void push(float x, float y, Color color, float tx, float ty) {
        this.push(x, y, color, tx, ty, tx, ty);
    }

    public void push(Vector2 position, Color color, Vector2 texcoord, Vector2 gradcoord) {
        this.push(position.x, position.y, color, texcoord.x, texcoord.y, gradcoord.x, gradcoord.y);
    }

    public void push(float x, float y, Color color, float tx, float ty, float gx, float gy) {
        this.vertices.ensureCapacity(this.stride);
        int idx = this.vertices.size;
        this.vertices.items[idx++] = x;
        this.vertices.items[idx++] = y;
        this.vertices.items[idx++] = color.toFloatBits();
        this.vertices.items[idx++] = tx;
        this.vertices.items[idx++] = ty;
        if (this.stride > 5) {
            this.vertices.items[idx++] = gx;
            this.vertices.items[idx++] = gy;
        }
        this.vertices.size += this.stride;
    }

    public Rectangle computeBounds() {
        return this.computeBounds(new Rectangle());
    }

    public Rectangle computeBounds(Rectangle rect) {
        if (rect == null) {
            rect = new Rectangle();
        }
        if (this.vertices.size == 0) {
            rect.set(0.0f, 0.0f, 0.0f, 0.0f);
            return rect;
        }
        rect.x = this.vertices.items[0];
        rect.width = this.vertices.items[0];
        rect.y = this.vertices.items[1];
        rect.height = this.vertices.items[1];
        for (int ii = 0; ii < this.vertices.size; ii += this.stride) {
            float x = this.vertices.items[ii];
            float y = this.vertices.items[ii + 1];
            rect.x = Math.min(rect.x, x);
            rect.y = Math.min(rect.y, y);
            rect.width = Math.max(rect.width, x);
            rect.height = Math.max(rect.height, y);
        }
        rect.width -= rect.x;
        rect.height -= rect.y;
        return rect;
    }
}

