/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.graphics;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.GL30;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.ObjectIntMap;
import com.badlogic.gdx.utils.ObjectMap;
import edu.cornell.gdiac.graphics.UniformBuffer;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Iterator;

public class Shader
extends ShaderProgram
implements Disposable {
    public static final String GRADCOORD_ATTRIBUTE = "a_gradCoords";
    private final ObjectMap<Integer, String> uniblockNames = new ObjectMap();
    private final ObjectIntMap<String> uniblockSizes = new ObjectIntMap();
    private final ObjectMap<Integer, Integer> uniblockFields = new ObjectMap();
    IntBuffer count = BufferUtils.newIntBuffer(1);
    ByteBuffer name = BufferUtils.newByteBuffer(16);
    IntBuffer size = BufferUtils.newIntBuffer(1);

    public Shader() {
        super("", "");
    }

    public Shader(String vertexShader, String fragmentShader) {
        super(vertexShader, fragmentShader);
        GL30 gl = Gdx.gl30;
        if (gl != null) {
            ((Buffer)this.count).clear();
            gl.glGetProgramiv(this.getHandle(), 35382, this.count);
            int numUniformBlocks = this.count.get(0);
            for (int ii = 0; ii < numUniformBlocks; ++ii) {
                ((Buffer)this.count).clear();
                this.count.put(0, 1);
                ((Buffer)this.name).clear();
                gl.glGetActiveUniformBlockName(this.getHandle(), ii, this.count, this.name);
                int error = gl.glGetError();
                if (error != 0) continue;
                String key = this.name.toString();
                ((Buffer)this.size).clear();
                gl.glGetActiveUniformBlockiv(this.getHandle(), ii, 35392, this.size);
                this.uniblockSizes.put(key, this.size.get(0));
                this.uniblockNames.put(ii, key);
                ((Buffer)this.size).clear();
                gl.glGetActiveUniformBlockiv(this.getHandle(), ii, 35394, this.size);
                IntBuffer ans = BufferUtils.newIntBuffer(this.size.get(0));
                gl.glGetActiveUniformBlockiv(this.getHandle(), ii, 35395, ans);
                for (int jj = 0; jj < this.size.get(0); ++jj) {
                    this.uniblockFields.put(ans.get(jj), ii);
                }
                ans.clear();
            }
        }
    }

    public Shader(FileHandle vertexShader, FileHandle fragmentShader) {
        this(vertexShader.readString(), fragmentShader.readString());
    }

    public String[] getUniformBlocks() {
        String[] result = new String[this.uniblockNames.size];
        int count = 0;
        for (Integer in : this.uniblockNames.keys()) {
            result[count] = this.uniblockNames.get(in);
            ++count;
        }
        return result;
    }

    public String[] getUniformsForBlock(int pos) {
        String[] result = new String[this.uniblockFields.size];
        int count = 0;
        Iterator iterator = this.uniblockFields.keys().iterator();
        while (iterator.hasNext()) {
            int in = (Integer)iterator.next();
            if (in != pos) continue;
            result[count] = this.getUniforms()[this.uniblockFields.get(in)];
            ++count;
        }
        String[] cutResult = new String[count];
        System.arraycopy(result, 0, cutResult, 0, count);
        return cutResult;
    }

    public String[] getUniformsForBlock(String name) {
        GL30 gl = Gdx.gl30;
        String[] result = new String[this.uniblockFields.size];
        if (gl != null) {
            int index = gl.glGetUniformBlockIndex(this.getHandle(), name);
            if (index == -1) {
                return result;
            }
            int count = 0;
            Iterator iterator = this.uniblockFields.keys().iterator();
            while (iterator.hasNext()) {
                int in = (Integer)iterator.next();
                if (in != index) continue;
                result[count] = this.getUniforms()[this.uniblockFields.get(in)];
                ++count;
            }
            String[] cutResult = new String[count];
            System.arraycopy(result, 0, cutResult, 0, count);
        }
        return result;
    }

    public void setUniformBlock(int pos, int bindpoint) {
        GL30 gl = Gdx.gl30;
        if (gl == null) {
            throw new UnsupportedOperationException("Uniform blocks require OpenGL 3.0");
        }
        gl.glUniformBlockBinding(this.getHandle(), pos, bindpoint);
    }

    public void setUniformBlock(String name, int bindpoint) {
        GL30 gl = Gdx.gl30;
        if (gl == null) {
            throw new UnsupportedOperationException("Uniform blocks require OpenGL 3.0");
        }
        int index = gl.glGetUniformBlockIndex(this.getHandle(), name);
        if (index != -1) {
            gl.glUniformBlockBinding(this.getHandle(), index, bindpoint);
        }
    }

    public void setUniformBlock(int pos, UniformBuffer buffer) {
        GL30 gl = Gdx.gl30;
        if (gl == null) {
            throw new UnsupportedOperationException("Uniform blocks require OpenGL 3.0");
        }
        int bpoint = buffer == null ? 0 : buffer.getBindPoint();
        Iterator iterator = this.uniblockFields.keys().iterator();
        while (iterator.hasNext()) {
            String name;
            int offset;
            int in = (Integer)iterator.next();
            if (this.uniblockFields.get(in) != pos || (offset = buffer.getOffset(name = this.getUniforms()[in])) != -1) continue;
            Gdx.app.debug("OPENGL", String.format("Uniform buffer is missing variable '%s'.", name));
        }
        String[] names = buffer.getOffsets();
        ObjectMap<String, Boolean> check = new ObjectMap<String, Boolean>();
        for (int i = 0; i < names.length; ++i) {
            check.put(names[i], false);
        }
        Iterator iterator2 = this.uniblockFields.keys().iterator();
        while (iterator2.hasNext()) {
            int in = (Integer)iterator2.next();
            if (this.uniblockFields.get(in) != pos) continue;
            check.put(this.getUniforms()[in], true);
        }
        for (String str : check.keys()) {
            if (((Boolean)check.get(str)).booleanValue()) continue;
            Gdx.app.debug("OPENGL", String.format("Shader is missing variable '%s'.", this.name));
        }
        gl.glUniformBlockBinding(this.getHandle(), pos, bpoint);
    }

    public void setUniformBlock(String name, UniformBuffer buffer) {
        GL30 gl = Gdx.gl30;
        if (gl == null) {
            throw new UnsupportedOperationException("Uniform blocks require OpenGL 3.0");
        }
        int index = gl.glGetUniformBlockIndex(this.getHandle(), name);
        if (index != -1) {
            this.setUniformBlock(index, buffer);
        }
    }

    public int getUniformBlock(int pos) {
        GL30 gl = Gdx.gl30;
        if (gl == null) {
            throw new UnsupportedOperationException("Uniform blocks require OpenGL 3.0");
        }
        IntBuffer block = BufferUtils.newIntBuffer(1);
        gl.glGetActiveUniformBlockiv(this.getHandle(), pos, 35391, block);
        return block.get(0);
    }

    public int getUniformBlock(String name) {
        GL30 gl = Gdx.gl30;
        if (gl == null) {
            throw new UnsupportedOperationException("Uniform blocks require OpenGL 3.0");
        }
        int index = gl.glGetUniformBlockIndex(this.getHandle(), name);
        if (index == -1) {
            return 0;
        }
        IntBuffer block = BufferUtils.newIntBuffer(1);
        gl.glGetActiveUniformBlockiv(this.getHandle(), index, 35391, block);
        return block.get(0);
    }
}

