/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.audio;

import com.badlogic.gdx.utils.ObjectMap;
import edu.cornell.gdiac.audio.SoundEffect;

public class SoundEffectManager
implements SoundEffect.OnCompletionListener {
    private static SoundEffectManager manager;
    private ObjectMap<String, SoundEffect> soundbank = new ObjectMap();
    private ObjectMap<String, ActiveSound> actives = new ObjectMap();
    private ObjectMap<String, String> keyMap = new ObjectMap();

    private SoundEffectManager() {
    }

    public static SoundEffectManager getInstance() {
        if (manager == null) {
            manager = new SoundEffectManager();
        }
        return manager;
    }

    public boolean play(String key, SoundEffect sound) {
        return this.play(key, sound, 1.0f, false);
    }

    public boolean play(String key, SoundEffect sound, float volume) {
        return this.play(key, sound, volume, false);
    }

    public boolean play(String key, SoundEffect sound, float volume, boolean loop) {
        long id;
        this.stop(key);
        String path = sound.getFile().path();
        if (!this.soundbank.containsKey(path)) {
            this.soundbank.put(path, sound);
            sound.setOnCompletionListener(this);
        }
        if ((id = sound.play(volume)) == -1L) {
            return false;
        }
        if (loop) {
            sound.setLooping(id, true);
        }
        ActiveSound act = new ActiveSound(sound, id);
        this.actives.put(key, act);
        this.keyMap.put(act.revkey, key);
        return true;
    }

    public void stop(String key) {
        if (!this.actives.containsKey(key)) {
            return;
        }
        ActiveSound snd = this.actives.get(key);
        snd.sound.stop(snd.id);
        this.actives.remove(key);
        this.keyMap.remove(snd.revkey);
    }

    public boolean isActive(String key) {
        return this.actives.containsKey(key);
    }

    public int size() {
        return this.actives.size;
    }

    @Override
    public void onCompletion(SoundEffect effect, long instance) {
        String revkey = effect.getFile().path() + instance;
        if (this.keyMap.containsKey(revkey)) {
            String key = this.keyMap.get(revkey);
            this.actives.remove(key);
            this.keyMap.remove(revkey);
        }
    }

    private class ActiveSound {
        public SoundEffect sound;
        public long id;
        public String revkey;

        public ActiveSound(SoundEffect s, long n) {
            this.sound = s;
            this.id = n;
            this.revkey = s.getFile().path() + n;
        }
    }
}

