/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonReader;
import edu.cornell.gdiac.assets.WidgetValue;

public class WidgetValueLoader
extends AsynchronousAssetLoader<WidgetValue, WidgetValueParameters> {
    protected WidgetValue cachedData;

    public WidgetValueLoader() {
        this(new InternalFileHandleResolver());
    }

    public WidgetValueLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, FileHandle file, WidgetValueParameters params) {
        JsonReader reader = new JsonReader();
        this.cachedData = new WidgetValue(reader.parse(file));
    }

    @Override
    public WidgetValue loadSync(AssetManager manager, String fileName, FileHandle file, WidgetValueParameters params) {
        WidgetValue json = this.cachedData;
        this.cachedData = null;
        return json;
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, WidgetValueParameters params) {
        return null;
    }

    public static class WidgetValueParameters
    extends AssetLoaderParameters<WidgetValue> {
    }
}

