/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;

public class TextureRegionLoader
extends AsynchronousAssetLoader<TextureRegion, TextureRegionParameters> {
    protected FileHandleResolver resolver;
    private TextureRegion cachedRegion;

    public TextureRegionLoader() {
        this(new InternalFileHandleResolver());
    }

    public TextureRegionLoader(FileHandleResolver resolver) {
        super(resolver);
        this.resolver = resolver;
    }

    protected TextureRegion getLoadedRegion() {
        return this.cachedRegion;
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, FileHandle file, TextureRegionParameters params) {
        Texture texture = (Texture)manager.get(manager.getDependencies(fileName).first());
        this.cachedRegion = this.load(texture, params);
    }

    @Override
    public TextureRegion loadSync(AssetManager manager, String fileName, FileHandle file, TextureRegionParameters params) {
        TextureRegion region = this.cachedRegion;
        this.cachedRegion = null;
        return region;
    }

    @Override
    public FileHandle resolve(String fileName) {
        int suffix = fileName.lastIndexOf(58);
        if (suffix == -1) {
            throw new GdxRuntimeException("Texture region file name must end in ':name'.");
        }
        String prefix = fileName.substring(0, suffix);
        return this.resolver.resolve(prefix);
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, TextureRegionParameters params) {
        if (params == null) {
            int suffix = fileName.lastIndexOf(58);
            String prefix = suffix == -1 ? fileName : fileName.substring(0, suffix);
            params = new TextureRegionParameters(prefix);
        }
        Array<AssetDescriptor> deps = new Array<AssetDescriptor>(1);
        deps.add(new AssetDescriptor<Texture>(params.source, Texture.class));
        return deps;
    }

    public TextureRegion load(Texture texture, TextureRegionParameters params) {
        if (params == null) {
            return new TextureRegion(texture);
        }
        int width = params.width < 0 ? texture.getWidth() - params.x : params.width;
        int height = params.height < 0 ? texture.getHeight() - params.y : params.height;
        return new TextureRegion(texture, params.x, params.y, width, height);
    }

    public static class TextureRegionParameters
    extends AssetLoaderParameters<TextureRegion> {
        public String source;
        public int x = 0;
        public int y = 0;
        public int width = -1;
        public int height = -1;

        public TextureRegionParameters(String fileName) {
            this.source = fileName;
        }

        public TextureRegionParameters(String fileName, int width, int height) {
            this.source = fileName;
        }

        public TextureRegionParameters(String fileName, int x, int y, int width, int height) {
            this.source = fileName;
        }
    }
}

