/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import edu.cornell.gdiac.assets.SpriteSheetParser;
import edu.cornell.gdiac.graphics.SpriteSheet;

public class SpriteSheetLoader
extends AsynchronousAssetLoader<SpriteSheet, SpriteSheetParameters> {
    protected FileHandleResolver resolver;
    private SpriteSheet cachedSprite;

    public SpriteSheetLoader() {
        this(new InternalFileHandleResolver());
    }

    public SpriteSheetLoader(FileHandleResolver resolver) {
        super(resolver);
        this.resolver = resolver;
    }

    protected SpriteSheet getLoadedSprite() {
        return this.cachedSprite;
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, FileHandle file, SpriteSheetParameters params) {
        Texture texture = (Texture)manager.get(manager.getDependencies(fileName).first());
        this.cachedSprite = this.load(texture, params);
    }

    @Override
    public SpriteSheet loadSync(AssetManager manager, String fileName, FileHandle file, SpriteSheetParameters params) {
        SpriteSheet region = this.cachedSprite;
        this.cachedSprite = null;
        return region;
    }

    @Override
    public FileHandle resolve(String fileName) {
        int suffix = fileName.lastIndexOf(SpriteSheetParser.ALIAS_SEP);
        if (suffix == -1) {
            throw new GdxRuntimeException("Texture region file name must end in " + SpriteSheetParser.ALIAS_SEP + "name'.");
        }
        String prefix = fileName.substring(0, suffix);
        return this.resolver.resolve(prefix);
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, SpriteSheetParameters params) {
        if (params == null) {
            int suffix = fileName.lastIndexOf(SpriteSheetParser.ALIAS_SEP);
            String prefix = suffix == -1 ? fileName : fileName.substring(0, suffix);
            params = new SpriteSheetParameters(prefix);
        }
        Array<AssetDescriptor> deps = new Array<AssetDescriptor>(1);
        deps.add(new AssetDescriptor<Texture>(params.source, Texture.class));
        return deps;
    }

    public SpriteSheet load(Texture texture, SpriteSheetParameters params) {
        if (params == null) {
            return new SpriteSheet(texture, 1, 1);
        }
        int w = params.width == -1 ? texture.getWidth() - params.x : params.width;
        int h = params.height == -1 ? texture.getHeight() - params.y : params.height;
        SpriteSheet result = new SpriteSheet(texture, params.rows, params.cols, params.size, params.x, params.y, w, h);
        result.setFrame(params.frame);
        return result;
    }

    public static class SpriteSheetParameters
    extends AssetLoaderParameters<SpriteSheet> {
        public String source;
        public int rows = 1;
        public int cols = 1;
        public int size = 1;
        public int frame = 0;
        public int x = 0;
        public int y = 0;
        public int width = -1;
        public int height = -1;

        public SpriteSheetParameters(String fileName) {
            this.source = fileName;
        }

        public SpriteSheetParameters(String fileName, int rows, int cols) {
            this.source = fileName;
            this.rows = rows;
            this.cols = cols;
            this.size = rows * cols;
        }

        public SpriteSheetParameters(String fileName, int rows, int cols, int size) {
            this.source = fileName;
            this.rows = rows;
            this.cols = cols;
            this.size = size;
        }
    }
}

