/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;

public class SoundLoader
extends AsynchronousAssetLoader<Sound, SoundParameters> {
    protected FileHandleResolver resolver;
    private Sound cachedSound;

    public SoundLoader() {
        this(new InternalFileHandleResolver());
    }

    public SoundLoader(FileHandleResolver resolver) {
        super(resolver);
        this.resolver = resolver;
    }

    protected Sound getLoadedSound() {
        return this.cachedSound;
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, FileHandle file, SoundParameters params) {
        this.cachedSound = Gdx.audio.newSound(file);
    }

    @Override
    public Sound loadSync(AssetManager manager, String fileName, FileHandle file, SoundParameters params) {
        Sound sound = this.cachedSound;
        this.cachedSound = null;
        return sound;
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, SoundParameters params) {
        return null;
    }

    public static class SoundParameters
    extends AssetLoaderParameters<Sound> {
    }
}

