/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ObjectMap;
import edu.cornell.gdiac.assets.AssetParser;
import edu.cornell.gdiac.assets.MaterialLibLoader;
import edu.cornell.gdiac.graphics.obj.MaterialInfo;
import edu.cornell.gdiac.graphics.obj.MaterialLib;

public class MaterialLibParser
implements AssetParser<MaterialLib> {
    private JsonValue root;
    private JsonValue mtl;

    @Override
    public Class<MaterialLib> getType() {
        return MaterialLib.class;
    }

    @Override
    public void reset(JsonValue directory) {
        this.root = directory;
        this.mtl = this.root.getChild("mtls");
    }

    @Override
    public boolean hasNext() {
        return this.mtl != null;
    }

    @Override
    public void processNext(AssetManager manager, ObjectMap<String, String> keymap) {
        MaterialLibLoader.MaterialLibParameters params = new MaterialLibLoader.MaterialLibParameters();
        if (this.mtl.isString()) {
            params.name = this.mtl.name;
            params.source = this.mtl.asString();
        } else {
            params.name = this.mtl.name;
            if (this.mtl.has("file")) {
                params.source = this.mtl.getString("file", null);
                if (this.mtl.hasChild("textures")) {
                    for (JsonValue txt = this.mtl.getChild("textures"); txt != null; txt = txt.next()) {
                        if (!txt.isString()) continue;
                        String key = txt.asString();
                        String path = this.getTexturePath(key);
                        params.textures.put(txt.name, path == null ? key : path);
                    }
                }
            } else if (this.mtl.has("texture")) {
                String key = this.mtl.getString("texture");
                String path = this.getTexturePath(key);
                params.source = key + ":__implicit__";
                params.material = new MaterialInfo();
                params.material.Kd = Color.WHITE;
                params.material.map_Kd = new MaterialInfo.LightMap();
                params.material.map_Kd.name = key;
                params.material.map_Kd.path = path == null ? key : path;
            }
        }
        keymap.put(this.mtl.name(), params.source);
        manager.load(params.source, MaterialLib.class, params);
        this.mtl = this.mtl.next();
    }

    public boolean equals(Object o) {
        return o instanceof MaterialLibParser;
    }

    private String getTexturePath(String key) {
        for (JsonValue txts = this.root.getChild("textures"); txts != null; txts = txts.next()) {
            if (!key.equals(txts.name)) continue;
            if (txts.isString()) {
                return txts.asString();
            }
            return txts.getString("file", null);
        }
        return null;
    }
}

