/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import edu.cornell.gdiac.graphics.obj.Material;
import edu.cornell.gdiac.graphics.obj.MaterialInfo;
import edu.cornell.gdiac.graphics.obj.MaterialLib;
import edu.cornell.gdiac.graphics.obj.ObjParser;

public class MaterialLibLoader
extends AsynchronousAssetLoader<MaterialLib, MaterialLibParameters> {
    protected FileHandleResolver resolver;
    protected ObjParser parser;
    private MaterialLib cachedLib;

    public MaterialLibLoader() {
        this(new InternalFileHandleResolver());
    }

    public MaterialLibLoader(FileHandleResolver resolver) {
        super(resolver);
        this.resolver = resolver;
        this.parser = new ObjParser(resolver);
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, FileHandle file, MaterialLibParameters params) {
        if (params == null) {
            this.cachedLib = this.parser.parseMtl(file.name(), fileName);
            for (ObjectMap.Entry entry : this.cachedLib.infos) {
                Material mat = new Material((MaterialInfo)entry.value, false);
                mat.setAmbientMap(this.getLightMap(((MaterialInfo)entry.value).map_Ka, manager));
                mat.setDiffuseMap(this.getLightMap(((MaterialInfo)entry.value).map_Kd, manager));
                mat.setSpecularMap(this.getLightMap(((MaterialInfo)entry.value).map_Ks, manager));
                mat.setBumpMap(this.getLightMap(((MaterialInfo)entry.value).map_Kn, manager));
                this.cachedLib.setMaterial((String)entry.key, mat);
            }
        } else if (params.material != null) {
            this.cachedLib = new MaterialLib();
            Material mat = new Material(params.material, false);
            mat.setAmbientMap(this.getLightMap(params.material.map_Ka, manager));
            mat.setDiffuseMap(this.getLightMap(params.material.map_Kd, manager));
            mat.setSpecularMap(this.getLightMap(params.material.map_Ks, manager));
            mat.setBumpMap(this.getLightMap(params.material.map_Kn, manager));
            this.cachedLib.name = params.material.name;
            this.cachedLib.path = fileName;
            this.cachedLib.infos.put(params.material.name, params.material);
            this.cachedLib.setMaterial(params.material.name, mat);
        } else {
            this.cachedLib = this.parser.parseMtl(params.name, fileName);
            for (ObjectMap.Entry entry : this.cachedLib.infos) {
                Material mat = new Material((MaterialInfo)entry.value, false);
                mat.setAmbientMap(this.getLightMap(((MaterialInfo)entry.value).map_Ka, manager));
                mat.setDiffuseMap(this.getLightMap(((MaterialInfo)entry.value).map_Kd, manager));
                mat.setSpecularMap(this.getLightMap(((MaterialInfo)entry.value).map_Ks, manager));
                mat.setBumpMap(this.getLightMap(((MaterialInfo)entry.value).map_Kn, manager));
                this.cachedLib.setMaterial((String)entry.key, mat);
            }
        }
    }

    private Texture getLightMap(MaterialInfo.LightMap info, AssetManager manager) {
        if (info == null) {
            return null;
        }
        return manager.get(info.path, Texture.class);
    }

    protected MaterialLib getLoadedLibrary() {
        return this.cachedLib;
    }

    @Override
    public MaterialLib loadSync(AssetManager manager, String fileName, FileHandle file, MaterialLibParameters params) {
        MaterialLib library = this.cachedLib;
        this.cachedLib = null;
        return library;
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, MaterialLibParameters params) {
        if (params == null) {
            MaterialLib early = this.parser.parseMtl(file.name(), fileName);
            Array<AssetDescriptor> deps = new Array<AssetDescriptor>(4 * early.infos.size);
            for (ObjectMap.Entry entry : early.infos) {
                if (((MaterialInfo)entry.value).map_Ka != null) {
                    deps.add(new AssetDescriptor<Texture>(((MaterialInfo)entry.value).map_Ka.path, Texture.class));
                }
                if (((MaterialInfo)entry.value).map_Kd != null) {
                    deps.add(new AssetDescriptor<Texture>(((MaterialInfo)entry.value).map_Kd.path, Texture.class));
                }
                if (((MaterialInfo)entry.value).map_Ks != null) {
                    deps.add(new AssetDescriptor<Texture>(((MaterialInfo)entry.value).map_Ks.path, Texture.class));
                }
                if (((MaterialInfo)entry.value).map_Kn == null) continue;
                deps.add(new AssetDescriptor<Texture>(((MaterialInfo)entry.value).map_Kn.path, Texture.class));
            }
            return deps.size > 0 ? deps : null;
        }
        if (params.material != null) {
            Array<AssetDescriptor> deps = new Array<AssetDescriptor>(4);
            if (params.material.map_Ka != null && !params.textures.containsKey(params.material.map_Ka.name)) {
                deps.add(new AssetDescriptor<Texture>(params.material.map_Ka.path, Texture.class));
            }
            if (params.material.map_Kd != null && !params.textures.containsKey(params.material.map_Kd.name)) {
                deps.add(new AssetDescriptor<Texture>(params.material.map_Kd.path, Texture.class));
            }
            if (params.material.map_Ks != null && !params.textures.containsKey(params.material.map_Ks.name)) {
                deps.add(new AssetDescriptor<Texture>(params.material.map_Ks.path, Texture.class));
            }
            if (params.material.map_Kn != null && !params.textures.containsKey(params.material.map_Kn.name)) {
                deps.add(new AssetDescriptor<Texture>(params.material.map_Kn.path, Texture.class));
            }
            return deps;
        }
        MaterialLib early = this.parser.parseMtl(params.name, fileName);
        Array<AssetDescriptor> deps = new Array<AssetDescriptor>(4 * early.infos.size);
        for (ObjectMap.Entry entry : early.infos) {
            if (((MaterialInfo)entry.value).map_Ka != null && !params.textures.containsKey(((MaterialInfo)entry.value).map_Ka.name)) {
                deps.add(new AssetDescriptor<Texture>(((MaterialInfo)entry.value).map_Ka.path, Texture.class));
            }
            if (((MaterialInfo)entry.value).map_Kd != null && !params.textures.containsKey(((MaterialInfo)entry.value).map_Kd.name)) {
                deps.add(new AssetDescriptor<Texture>(((MaterialInfo)entry.value).map_Kd.path, Texture.class));
            }
            if (((MaterialInfo)entry.value).map_Ks != null && !params.textures.containsKey(((MaterialInfo)entry.value).map_Ks.name)) {
                deps.add(new AssetDescriptor<Texture>(((MaterialInfo)entry.value).map_Ks.path, Texture.class));
            }
            if (((MaterialInfo)entry.value).map_Kn == null || params.textures.containsKey(((MaterialInfo)entry.value).map_Kn.name)) continue;
            deps.add(new AssetDescriptor<Texture>(((MaterialInfo)entry.value).map_Kn.path, Texture.class));
        }
        return deps.size > 0 ? deps : null;
    }

    public static class MaterialLibParameters
    extends AssetLoaderParameters<MaterialLib> {
        public String name;
        public String source;
        public ObjectMap<String, String> textures;
        public MaterialInfo material;

        public MaterialLibParameters() {
            this.name = null;
            this.source = null;
            this.material = null;
            this.textures = new ObjectMap();
        }

        public MaterialLibParameters(String fileName) {
            this.name = fileName;
            this.source = fileName;
            this.material = null;
            this.textures = new ObjectMap();
        }
    }
}

