/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.gdiac.assets;

import com.badlogic.gdx.assets.AssetDescriptor;
import com.badlogic.gdx.assets.AssetLoaderParameters;
import com.badlogic.gdx.assets.AssetManager;
import com.badlogic.gdx.assets.loaders.AsynchronousAssetLoader;
import com.badlogic.gdx.assets.loaders.FileHandleResolver;
import com.badlogic.gdx.assets.loaders.resolvers.InternalFileHandleResolver;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;

public class JsonValueLoader
extends AsynchronousAssetLoader<JsonValue, JsonValueParameters> {
    protected JsonValue cachedData;

    public JsonValueLoader() {
        this(new InternalFileHandleResolver());
    }

    public JsonValueLoader(FileHandleResolver resolver) {
        super(resolver);
    }

    protected JsonValue getLoadedJSON() {
        return this.cachedData;
    }

    @Override
    public void loadAsync(AssetManager manager, String fileName, FileHandle file, JsonValueParameters params) {
        if (params != null && params.data != null) {
            JsonReader reader = new JsonReader();
            this.cachedData = reader.parse(params.data);
        } else {
            JsonReader reader = new JsonReader();
            this.cachedData = reader.parse(file);
        }
    }

    @Override
    public JsonValue loadSync(AssetManager manager, String fileName, FileHandle file, JsonValueParameters params) {
        JsonValue json = this.cachedData;
        this.cachedData = null;
        return json;
    }

    @Override
    public Array<AssetDescriptor> getDependencies(String fileName, FileHandle file, JsonValueParameters params) {
        return null;
    }

    public static class JsonValueParameters
    extends AssetLoaderParameters<JsonValue> {
        public String data;
    }
}

