/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.physics.rocket;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.physics.box2d.ContactImpulse;
import com.badlogic.gdx.physics.box2d.ContactListener;
import com.badlogic.gdx.physics.box2d.Manifold;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.physics.box2d.WorldManifold;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.cis3152.physics.InputController;
import edu.cornell.cis3152.physics.PhysicsScene;
import edu.cornell.cis3152.physics.rocket.Box;
import edu.cornell.cis3152.physics.rocket.Rocket;
import edu.cornell.cis3152.physics.rocket.Surface;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.audio.SoundEffect;
import edu.cornell.gdiac.audio.SoundEffectManager;
import edu.cornell.gdiac.graphics.SpriteSheet;
import edu.cornell.gdiac.physics2.Obstacle;
import edu.cornell.gdiac.physics2.ObstacleSprite;
import edu.cornell.gdiac.util.RandomGenerator;

public class RocketScene
extends PhysicsScene
implements ContactListener {
    private Box goalDoor;
    private Rocket rocket;
    private SoundEffect bumpSound;
    private int maxBumps;
    private int bumpIndx;
    private float bumpVol;
    private float bumpThresh;
    private final Vector2 cache = new Vector2();

    public RocketScene(AssetDirectory directory) {
        super(directory, "rocket");
        this.world.setContactListener(this);
        this.bumpSound = directory.getEntry("rocket-bump", SoundEffect.class);
        this.bumpVol = this.constants.get("collisions").getFloat("volume", 1.0f);
        this.maxBumps = this.constants.get("collisions").getInt("maximum", 1);
        this.bumpThresh = this.constants.get("collisions").getFloat("threshold", 0.0f);
        this.bumpIndx = 0;
    }

    @Override
    public void reset() {
        JsonValue values = this.constants.get("world");
        Vector2 gravity = new Vector2(0.0f, values.getFloat("gravity"));
        for (ObstacleSprite sprite : this.sprites) {
            Obstacle obj = sprite.getObstacle();
            sprite.getObstacle().deactivatePhysics(this.world);
        }
        this.sprites.clear();
        this.addQueue.clear();
        if (this.world != null) {
            this.world.dispose();
        }
        this.world = new World(gravity, false);
        this.world.setContactListener(this);
        this.setComplete(false);
        this.setFailure(false);
        this.populateLevel();
    }

    private void populateLevel() {
        float units = this.height / this.bounds.height;
        Texture texture = this.directory.getEntry("shared-goal", Texture.class);
        JsonValue goal = this.constants.get("goal");
        JsonValue goalpos = goal.get("pos");
        this.goalDoor = new Box(goalpos.getFloat(0), goalpos.getFloat(1), units, goal);
        this.goalDoor.setTexture(texture);
        Obstacle obj = this.goalDoor.getObstacle();
        obj.setName("goal");
        obj.setBodyType(BodyDef.BodyType.StaticBody);
        obj.setSensor(true);
        this.addSprite(this.goalDoor);
        texture = this.directory.getEntry("shared-earth", Texture.class);
        JsonValue walls = this.constants.get("walls");
        JsonValue walljv = walls.get("positions");
        Surface wall = new Surface(walljv.get(0).asFloatArray(), units, walls);
        wall.getObstacle().setName("wall1");
        wall.setTexture(texture);
        this.addSprite(wall);
        wall = new Surface(walljv.get(1).asFloatArray(), units, walls);
        wall.getObstacle().setName("wall2");
        wall.setTexture(texture);
        this.addSprite(wall);
        wall = new Surface(walljv.get(2).asFloatArray(), units, walls);
        wall.getObstacle().setName("wall3");
        wall.setTexture(texture);
        this.addSprite(wall);
        JsonValue crates = this.constants.get("boxes");
        JsonValue boxjv = crates.get("positions");
        for (int ii = 0; ii < boxjv.size; ii += 2) {
            int id = RandomGenerator.getInt(0, 1) + 1;
            texture = this.directory.getEntry("rocket-crate0" + id, Texture.class);
            float sz = crates.getFloat("size");
            Box box = new Box(boxjv.getFloat(ii), boxjv.getFloat(ii + 1), units, crates);
            box.getObstacle().setName("crate" + id);
            box.setTexture(texture);
            this.addSprite(box);
        }
        texture = this.directory.getEntry("rocket-rocket", Texture.class);
        JsonValue rockjv = this.constants.get("rocket");
        this.rocket = new Rocket(units, rockjv);
        this.rocket.setTexture(texture);
        SpriteSheet sprite = this.directory.getEntry("rocket-main.fire", SpriteSheet.class);
        SoundEffect effect = this.directory.getEntry("rocket-mainburn", SoundEffect.class);
        this.rocket.setBurnerSheet(Rocket.Burner.MAIN, sprite);
        this.rocket.setBurnerSound(Rocket.Burner.MAIN, effect);
        sprite = this.directory.getEntry("rocket-left.fire", SpriteSheet.class);
        effect = this.directory.getEntry("rocket-leftburn", SoundEffect.class);
        this.rocket.setBurnerSheet(Rocket.Burner.LEFT, sprite);
        this.rocket.setBurnerSound(Rocket.Burner.LEFT, effect);
        sprite = this.directory.getEntry("rocket-right.fire", SpriteSheet.class);
        effect = this.directory.getEntry("rocket-rightburn", SoundEffect.class);
        this.rocket.setBurnerSheet(Rocket.Burner.RIGHT, sprite);
        this.rocket.setBurnerSound(Rocket.Burner.RIGHT, effect);
        this.addSprite(this.rocket);
    }

    @Override
    public void update(float dt) {
        this.rocket.setFX(InputController.getInstance().getHorizontal() * this.rocket.getThrust());
        this.rocket.setFY(InputController.getInstance().getVertical() * this.rocket.getThrust());
        this.rocket.applyForce();
        this.rocket.updateBurners();
    }

    @Override
    public void beginContact(Contact contact) {
        Body body1 = contact.getFixtureA().getBody();
        Body body2 = contact.getFixtureB().getBody();
        ObstacleSprite sprite1 = (ObstacleSprite)body1.getUserData();
        ObstacleSprite sprite2 = (ObstacleSprite)body2.getUserData();
        if ((sprite1.getName() == "rocket" && sprite2.getName() == "goal" || sprite1.getName() == "goal" && sprite2.getName() == "rocket") && !this.isComplete()) {
            this.setComplete(true);
        }
    }

    @Override
    public void endContact(Contact contact) {
    }

    @Override
    public void postSolve(Contact contact, ContactImpulse impulse) {
    }

    @Override
    public void preSolve(Contact contact, Manifold oldManifold) {
        float speed = 0.0f;
        Body body1 = contact.getFixtureA().getBody();
        Body body2 = contact.getFixtureB().getBody();
        WorldManifold worldManifold = contact.getWorldManifold();
        Vector2 wp = worldManifold.getPoints()[0];
        this.cache.set(body1.getLinearVelocityFromWorldPoint(wp));
        this.cache.sub(body2.getLinearVelocityFromWorldPoint(wp));
        speed = this.cache.dot(worldManifold.getNormal());
        if (speed > this.constants.get("collisions").getFloat("threshold")) {
            SoundEffectManager sounds = SoundEffectManager.getInstance();
            sounds.play("bump" + this.bumpIndx, this.bumpSound);
            this.bumpIndx = (this.bumpIndx + 1) % this.maxBumps;
        }
    }

    @Override
    public void pause() {
        this.rocket.stopSounds();
    }
}

