/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.physics.rocket;

import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.assets.ParserUtils;
import edu.cornell.gdiac.audio.SoundEffect;
import edu.cornell.gdiac.audio.SoundEffectManager;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.graphics.SpriteSheet;
import edu.cornell.gdiac.physics2.BoxObstacle;
import edu.cornell.gdiac.physics2.ObstacleSprite;

public class Rocket
extends ObstacleSprite {
    private final JsonValue data;
    private final float thrust;
    private Vector2 size;
    private SpriteSheet mainBurner;
    private SoundEffect mainSound;
    private boolean mainCycle = true;
    private SpriteSheet leftBurner;
    private SoundEffect leftSound;
    private boolean leftCycle = true;
    private SpriteSheet rghtBurner;
    private SoundEffect rghtSound;
    private boolean rghtCycle = true;
    private float burnVol;
    private final Vector2 force = new Vector2();
    private final Affine2 affineCache = new Affine2();

    public Vector2 getForce() {
        return this.force;
    }

    public float getFX() {
        return this.force.x;
    }

    public void setFX(float value) {
        this.force.x = value;
    }

    public float getFY() {
        return this.force.y;
    }

    public void setFY(float value) {
        this.force.y = value;
    }

    public float getThrust() {
        return this.thrust;
    }

    public Rocket(float units, JsonValue constants) {
        this.data = constants;
        float x = this.data.get("pos").getFloat(0);
        float y = this.data.get("pos").getFloat(1);
        float sx = this.data.get("size").getFloat(0);
        float sy = this.data.get("size").getFloat(1);
        this.size = new Vector2(sx * units, sy * units);
        this.obstacle = new BoxObstacle(x, y, sx, sy);
        this.obstacle.setDensity(this.data.getFloat("density", 0.0f));
        this.obstacle.setFriction(this.data.getFloat("friction", 0.0f));
        this.obstacle.setRestitution(this.data.getFloat("restitution", 0.0f));
        this.obstacle.setPhysicsUnits(units);
        this.obstacle.setUserData(this);
        this.thrust = this.data.getFloat("thrust", 0.0f);
        this.debug = ParserUtils.parseColor(this.data.get("debug"), Color.WHITE);
        this.mesh.set(-this.size.x / 2.0f, -this.size.y / 2.0f, this.size.x, this.size.y);
        this.obstacle.setName("rocket");
        this.obstacle.setFixedRotation(true);
        this.burnVol = this.data.getFloat("volume", 1.0f);
    }

    public void applyForce() {
        if (!this.obstacle.isActive()) {
            return;
        }
        this.affineCache.setToRotationRad(this.obstacle.getAngle());
        this.affineCache.applyTo(this.force);
        Body body = this.obstacle.getBody();
        body.applyForceToCenter(this.force, true);
    }

    public SpriteSheet getBurnerSheet(Burner burner) {
        switch (burner) {
            case MAIN: {
                return this.mainBurner;
            }
            case LEFT: {
                return this.leftBurner;
            }
            case RIGHT: {
                return this.rghtBurner;
            }
        }
        assert (false) : "Invalid burner enumeration";
        return null;
    }

    public void setBurnerSheet(Burner burner, SpriteSheet strip) {
        switch (burner) {
            case MAIN: {
                this.mainBurner = strip;
                break;
            }
            case LEFT: {
                this.leftBurner = strip;
                break;
            }
            case RIGHT: {
                this.rghtBurner = strip;
                break;
            }
            default: {
                assert (false) : "Invalid burner enumeration";
                break;
            }
        }
    }

    public Sound getBurnerSound(Burner burner) {
        switch (burner) {
            case MAIN: {
                return this.mainSound;
            }
            case LEFT: {
                return this.leftSound;
            }
            case RIGHT: {
                return this.rghtSound;
            }
        }
        assert (false) : "Invalid burner enumeration";
        return null;
    }

    public void setBurnerSound(Burner burner, SoundEffect sound) {
        switch (burner) {
            case MAIN: {
                this.mainSound = sound;
                break;
            }
            case LEFT: {
                this.leftSound = sound;
                break;
            }
            case RIGHT: {
                this.rghtSound = sound;
                break;
            }
            default: {
                assert (false) : "Invalid burner enumeration";
                break;
            }
        }
    }

    public void updateBurners() {
        this.updateBurner(Burner.MAIN, this.getFY() > 1.0f);
        this.updateBurner(Burner.LEFT, this.getFX() > 1.0f);
        this.updateBurner(Burner.RIGHT, this.getFX() < -1.0f);
    }

    private void updateBurner(Burner burner, boolean on) {
        SoundEffectManager sounds = SoundEffectManager.getInstance();
        SoundEffect effect = null;
        String key = "";
        switch (burner) {
            case MAIN: {
                effect = this.mainSound;
                key = "mainburner";
                break;
            }
            case LEFT: {
                effect = this.leftSound;
                key = "leftburner";
                break;
            }
            case RIGHT: {
                effect = this.rghtSound;
                key = "rightburner";
                break;
            }
            default: {
                assert (false) : "Invalid burner enumeration";
                break;
            }
        }
        if (on) {
            this.animateBurner(burner, true);
            if (effect != null && !sounds.isActive(key)) {
                sounds.play(key, effect, this.burnVol, true);
            }
        } else {
            this.animateBurner(burner, false);
            if (sounds.isActive(key)) {
                sounds.stop(key);
            }
        }
    }

    private void animateBurner(Burner burner, boolean on) {
        SpriteSheet node = null;
        boolean cycle = true;
        switch (burner) {
            case MAIN: {
                node = this.mainBurner;
                cycle = this.mainCycle;
                break;
            }
            case LEFT: {
                node = this.leftBurner;
                cycle = this.leftCycle;
                break;
            }
            case RIGHT: {
                node = this.rghtBurner;
                cycle = this.rghtCycle;
                break;
            }
            default: {
                assert (false) : "Invalid burner enumeration";
                break;
            }
        }
        if (node == null) {
            return;
        }
        if (on) {
            if (node.getFrame() == 0 || node.getFrame() == 1) {
                cycle = true;
            } else if (node.getFrame() == node.getSize() - 1) {
                cycle = false;
            }
            if (cycle) {
                node.setFrame(node.getFrame() + 1);
            } else {
                node.setFrame(node.getFrame() - 1);
            }
        } else {
            node.setFrame(0);
        }
        switch (burner) {
            case MAIN: {
                this.mainCycle = cycle;
                break;
            }
            case LEFT: {
                this.leftCycle = cycle;
                break;
            }
            case RIGHT: {
                this.rghtCycle = cycle;
                break;
            }
            default: {
                assert (false) : "Invalid burner enumeration";
                break;
            }
        }
    }

    @Override
    public void draw(SpriteBatch batch) {
        float fy;
        float fx;
        super.draw(batch);
        float x = this.obstacle.getX();
        float y = this.obstacle.getY();
        float a = this.obstacle.getAngle();
        float u = this.obstacle.getPhysicsUnits();
        batch.setColor(Color.WHITE);
        if (this.mainBurner != null) {
            float offsety = this.size.y / 2.0f - (float)this.mainBurner.getRegionHeight();
            this.transform.idt();
            this.transform.preTranslate(-this.size.x / 2.0f, offsety);
            this.transform.preRotate((float)((double)(a * 180.0f) / Math.PI));
            this.transform.preTranslate(x * u, y * u);
            batch.draw(this.mainBurner, this.transform);
        }
        if (this.leftBurner != null) {
            fx = (float)(-this.leftBurner.getRegionWidth()) / 2.0f;
            fy = (float)(-this.leftBurner.getRegionHeight()) / 2.0f;
            this.transform.idt();
            this.transform.preTranslate(fx, fy);
            this.transform.preRotate((float)((double)(a * 180.0f) / Math.PI));
            this.transform.preTranslate(x * u, y * u);
            batch.draw(this.leftBurner, this.transform);
        }
        if (this.rghtBurner != null) {
            fx = (float)(-this.rghtBurner.getRegionWidth()) / 2.0f;
            fy = (float)(-this.rghtBurner.getRegionHeight()) / 2.0f;
            this.transform.idt();
            this.transform.preTranslate(fx, fy);
            this.transform.preRotate((float)((double)(a * 180.0f) / Math.PI));
            this.transform.preTranslate(x * u, y * u);
            batch.draw(this.rghtBurner, this.transform);
        }
    }

    public void stopSounds() {
        SoundEffectManager sounds = SoundEffectManager.getInstance();
        sounds.stop("mainburner");
        sounds.stop("leftburner");
        sounds.stop("rightburner");
    }

    public static enum Burner {
        MAIN,
        LEFT,
        RIGHT;

    }
}

