/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.physics.rocket;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.assets.ParserUtils;
import edu.cornell.gdiac.physics2.BoxObstacle;
import edu.cornell.gdiac.physics2.ObstacleSprite;

public class Box
extends ObstacleSprite {
    public Box(float x, float y, float units, JsonValue settings) {
        float s = settings.getFloat("size");
        float size = s * units;
        this.obstacle = new BoxObstacle(x, y, s, s);
        this.obstacle.setDensity(settings.getFloat("density", 0.0f));
        this.obstacle.setFriction(settings.getFloat("friction", 0.0f));
        this.obstacle.setRestitution(settings.getFloat("restitution", 0.0f));
        this.obstacle.setPhysicsUnits(units);
        this.obstacle.setUserData(this);
        this.debug = ParserUtils.parseColor(settings.get("debug"), Color.WHITE);
        this.mesh.set(-size / 2.0f, -size / 2.0f, size, size);
    }
}

