/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.physics.ragdoll;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ScreenUtils;
import edu.cornell.cis3152.physics.InputController;
import edu.cornell.cis3152.physics.PhysicsScene;
import edu.cornell.cis3152.physics.ragdoll.Ragdoll;
import edu.cornell.cis3152.physics.ragdoll.Wall;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.assets.ParserUtils;
import edu.cornell.gdiac.physics2.Obstacle;
import edu.cornell.gdiac.physics2.ObstacleSelector;
import edu.cornell.gdiac.physics2.ObstacleSprite;

public class RagdollScene
extends PhysicsScene {
    private TextureRegion crosshairTexture;
    private TextureRegion backgroundTexture;
    private TextureRegion foregroundTexture;
    private Color foregroundColor;
    private Ragdoll ragdoll;
    private ObstacleSelector selector;

    public RagdollScene(AssetDirectory directory) {
        super(directory, "ragdoll");
        this.crosshairTexture = new TextureRegion(directory.getEntry("ragdoll-crosshair", Texture.class));
        this.backgroundTexture = new TextureRegion(directory.getEntry("ragdoll-background", Texture.class));
        this.foregroundTexture = new TextureRegion(directory.getEntry("ragdoll-foreground", Texture.class));
        this.foregroundColor = ParserUtils.parseColor(this.constants.get("world").get("forecolor"), Color.WHITE);
    }

    @Override
    public void reset() {
        JsonValue values = this.constants.get("world");
        Vector2 gravity = new Vector2(0.0f, values.getFloat("gravity"));
        for (ObstacleSprite sprite : this.sprites) {
            Obstacle obj = sprite.getObstacle();
            sprite.getObstacle().deactivatePhysics(this.world);
        }
        this.sprites.clear();
        this.addQueue.clear();
        if (this.world != null) {
            this.world.dispose();
        }
        this.world = new World(gravity, false);
        this.setComplete(false);
        this.setFailure(false);
        this.populateLevel();
    }

    private void populateLevel() {
        float units = this.height / this.bounds.height;
        this.ragdoll = new Ragdoll(units, this.constants);
        this.ragdoll.setAssets(this.directory);
        this.ragdoll.getBubbleGenerator().setAssets(this.directory);
        this.addSpriteGroup(this.ragdoll);
        Texture texture = this.directory.getEntry("shared-earth", Texture.class);
        JsonValue walls = this.constants.get("walls");
        JsonValue walljv = walls.get("positions");
        Wall wall = new Wall(walljv.get(0).asFloatArray(), units, walls);
        wall.getObstacle().setName("wall1");
        wall.setTexture(texture);
        this.addSprite(wall);
        wall = new Wall(walljv.get(1).asFloatArray(), units, walls);
        wall.getObstacle().setName("wall2");
        wall.setTexture(texture);
        this.addSprite(wall);
        this.selector = new ObstacleSelector(this.world);
        this.selector.setTexture(this.directory.getEntry("ragdoll-crosshair", Texture.class));
        this.selector.setPhysicsUnits(units);
    }

    @Override
    public void update(float dt) {
        InputController input = InputController.getInstance();
        if (input.didTertiary() && !this.selector.isSelected()) {
            this.selector.select(input.getCrossHair().x, input.getCrossHair().y);
        } else if (!input.didTertiary() && this.selector.isSelected()) {
            this.selector.deselect();
        } else {
            this.selector.moveTo(input.getCrossHair().x, input.getCrossHair().y);
        }
    }

    @Override
    public void draw(float dt) {
        float units = this.height / this.bounds.height;
        ScreenUtils.clear(Color.BLACK);
        this.batch.begin(this.camera);
        this.batch.setColor(Color.WHITE);
        this.batch.draw(this.backgroundTexture, 0.0f, 0.0f, this.width, this.height);
        for (ObstacleSprite obj : this.sprites) {
            obj.draw(this.batch);
        }
        if (this.debug) {
            for (ObstacleSprite obj : this.sprites) {
                obj.drawDebug(this.batch);
            }
        }
        InputController input = InputController.getInstance();
        float x = input.getCrossHair().x * units - units / 2.0f;
        float y = input.getCrossHair().y * units - units / 2.0f;
        this.batch.draw(this.crosshairTexture, x, y, units, units);
        this.batch.setColor(this.foregroundColor);
        this.batch.draw(this.foregroundTexture, 0.0f, 0.0f, this.width, this.height);
        this.batch.end();
    }
}

