/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.physics.ragdoll;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.Joint;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.physics.box2d.joints.RevoluteJointDef;
import com.badlogic.gdx.physics.box2d.joints.WeldJointDef;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.cis3152.physics.ObstacleGroup;
import edu.cornell.cis3152.physics.ragdoll.BubbleGenerator;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.physics2.BoxObstacle;
import edu.cornell.gdiac.physics2.ObstacleSprite;

public class Ragdoll
extends ObstacleGroup {
    public static final String[] BODY_PARTS = new String[]{"torso", "head", "arm", "forearm", "thigh", "shin"};
    private static final int PART_NONE = -1;
    private static final int PART_BODY = 0;
    private static final int PART_HEAD = 1;
    private static final int PART_LEFT_ARM = 2;
    private static final int PART_RIGHT_ARM = 3;
    private static final int PART_LEFT_FOREARM = 4;
    private static final int PART_RIGHT_FOREARM = 5;
    private static final int PART_LEFT_THIGH = 6;
    private static final int PART_RIGHT_THIGH = 7;
    private static final int PART_LEFT_SHIN = 8;
    private static final int PART_RIGHT_SHIN = 9;
    private final JsonValue data;
    private final float units;
    private final BubbleGenerator bubbler;
    private Texture[] partTextures;
    private final Vector2 partCache = new Vector2();

    private static int partToAsset(int part) {
        switch (part) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: 
            case 3: {
                return 2;
            }
            case 4: 
            case 5: {
                return 3;
            }
            case 6: 
            case 7: {
                return 4;
            }
            case 8: 
            case 9: {
                return 5;
            }
        }
        return -1;
    }

    private static boolean partOnLeft(int part) {
        switch (part) {
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public BubbleGenerator getBubbleGenerator() {
        return this.bubbler;
    }

    public Ragdoll(float units, JsonValue data) {
        this.data = data.get("doll");
        this.units = units;
        BoxObstacle part = this.makePart(0, -1);
        part.setFixedRotation(true);
        this.makePart(1, 0);
        this.makePart(2, 0);
        part = this.makePart(3, 0);
        part.setAngle((float)Math.PI);
        this.makePart(4, 2);
        part = this.makePart(5, 3);
        part.setAngle((float)Math.PI);
        this.makePart(6, 0);
        this.makePart(7, 0);
        this.makePart(8, 6);
        this.makePart(9, 7);
        this.bubbler = new BubbleGenerator(units, data);
        this.sprites.add(this.bubbler);
    }

    public void setAssets(AssetDirectory directory) {
        int ii;
        Texture[] partTextures = new Texture[BODY_PARTS.length];
        for (ii = 0; ii < BODY_PARTS.length; ++ii) {
            partTextures[ii] = directory.getEntry("ragdoll-" + BODY_PARTS[ii], Texture.class);
        }
        for (ii = 0; ii <= 9; ++ii) {
            ((ObstacleSprite)this.sprites.get(ii)).setTexture(partTextures[Ragdoll.partToAsset(ii)]);
        }
    }

    private BoxObstacle makePart(int part, int connect) {
        String name = BODY_PARTS[Ragdoll.partToAsset(part)];
        JsonValue pos = part == 0 ? this.data.get(name).get("position") : this.data.get(name).get("offset");
        JsonValue size = this.data.get(name).get("size");
        float x = pos.getFloat(0);
        float y = pos.getFloat(1);
        if (Ragdoll.partOnLeft(part)) {
            x = -x;
        }
        this.partCache.set(x, y);
        if (connect != -1) {
            this.partCache.add(((ObstacleSprite)this.sprites.get(connect)).getObstacle().getPosition());
        }
        float w = size.getFloat(0);
        float h = size.getFloat(1);
        BoxObstacle obstacle = new BoxObstacle(this.partCache.x, this.partCache.y, w, h);
        obstacle.setDensity(this.data.getFloat("density", 0.0f));
        obstacle.setPhysicsUnits(this.units);
        ObstacleSprite sprite = new ObstacleSprite(obstacle);
        this.sprites.add(sprite);
        return obstacle;
    }

    private Body getBody(int part) {
        return ((ObstacleSprite)this.sprites.get(part)).getObstacle().getBody();
    }

    @Override
    protected boolean createJoints(World world) {
        assert (this.sprites.size > 0);
        RevoluteJointDef jointDef = new RevoluteJointDef();
        JsonValue position = this.data.get(BODY_PARTS[Ragdoll.partToAsset(1)]).get("offset");
        float torso_offset = position.getFloat(1);
        jointDef.bodyA = this.getBody(1);
        jointDef.bodyB = this.getBody(0);
        jointDef.localAnchorA.set(0.0f, -torso_offset / 2.0f);
        jointDef.localAnchorB.set(0.0f, torso_offset / 2.0f);
        jointDef.enableLimit = true;
        jointDef.upperAngle = 1.5707964f;
        jointDef.lowerAngle = -1.5707964f;
        Joint joint = world.createJoint(jointDef);
        this.joints.add(joint);
        position = this.data.get(BODY_PARTS[Ragdoll.partToAsset(2)]).get("offset");
        float arm_xoffset = position.getFloat(0);
        float arm_yoffset = position.getFloat(1);
        jointDef.bodyA = this.getBody(2);
        jointDef.bodyB = this.getBody(0);
        jointDef.localAnchorA.set(arm_xoffset / 2.0f, 0.0f);
        jointDef.localAnchorB.set(-arm_xoffset / 2.0f, arm_yoffset);
        jointDef.enableLimit = true;
        jointDef.upperAngle = 1.5707964f;
        jointDef.lowerAngle = -1.5707964f;
        joint = world.createJoint(jointDef);
        this.joints.add(joint);
        jointDef.bodyA = this.getBody(3);
        jointDef.bodyB = this.getBody(0);
        jointDef.localAnchorA.set(arm_xoffset / 2.0f, 0.0f);
        jointDef.localAnchorB.set(arm_xoffset / 2.0f, arm_yoffset);
        jointDef.enableLimit = true;
        jointDef.upperAngle = -1.5707964f;
        jointDef.lowerAngle = -4.712389f;
        joint = world.createJoint(jointDef);
        this.joints.add(joint);
        position = this.data.get(BODY_PARTS[Ragdoll.partToAsset(4)]).get("offset");
        float forearm_offset = position.getFloat(0);
        jointDef.bodyA = this.getBody(4);
        jointDef.bodyB = this.getBody(2);
        jointDef.localAnchorA.set(forearm_offset / 2.0f, 0.0f);
        jointDef.localAnchorB.set(-forearm_offset / 2.0f, 0.0f);
        jointDef.enableLimit = true;
        jointDef.upperAngle = 1.5707964f;
        jointDef.lowerAngle = -1.5707964f;
        joint = world.createJoint(jointDef);
        this.joints.add(joint);
        jointDef.bodyA = this.getBody(5);
        jointDef.bodyB = this.getBody(3);
        jointDef.localAnchorA.set(forearm_offset / 2.0f, 0.0f);
        jointDef.localAnchorB.set(-forearm_offset / 2.0f, 0.0f);
        jointDef.enableLimit = true;
        jointDef.upperAngle = 1.5707964f;
        jointDef.lowerAngle = -1.5707964f;
        joint = world.createJoint(jointDef);
        this.joints.add(joint);
        position = this.data.get(BODY_PARTS[Ragdoll.partToAsset(6)]).get("offset");
        float thigh_xoffset = position.getFloat(0);
        float thigh_yoffset = position.getFloat(1);
        jointDef.bodyA = this.getBody(6);
        jointDef.bodyB = this.getBody(0);
        jointDef.localAnchorA.set(0.0f, -thigh_yoffset / 2.0f);
        jointDef.localAnchorB.set(-thigh_xoffset, thigh_yoffset / 2.0f);
        jointDef.enableLimit = true;
        jointDef.upperAngle = 1.5707964f;
        jointDef.lowerAngle = -1.5707964f;
        joint = world.createJoint(jointDef);
        this.joints.add(joint);
        jointDef.bodyA = this.getBody(7);
        jointDef.bodyB = this.getBody(0);
        jointDef.localAnchorA.set(0.0f, -thigh_yoffset / 2.0f);
        jointDef.localAnchorB.set(thigh_xoffset, thigh_yoffset / 2.0f);
        jointDef.enableLimit = true;
        jointDef.upperAngle = 1.5707964f;
        jointDef.lowerAngle = -1.5707964f;
        joint = world.createJoint(jointDef);
        this.joints.add(joint);
        position = this.data.get(BODY_PARTS[Ragdoll.partToAsset(8)]).get("offset");
        float shin_offset = position.getFloat(1);
        jointDef.bodyA = this.getBody(6);
        jointDef.bodyB = this.getBody(8);
        jointDef.localAnchorA.set(0.0f, shin_offset / 2.0f);
        jointDef.localAnchorB.set(0.0f, -shin_offset / 2.0f);
        jointDef.enableLimit = true;
        jointDef.upperAngle = 1.5707964f;
        jointDef.lowerAngle = -1.5707964f;
        joint = world.createJoint(jointDef);
        this.joints.add(joint);
        jointDef.bodyA = this.getBody(7);
        jointDef.bodyB = this.getBody(9);
        jointDef.localAnchorA.set(0.0f, shin_offset / 2.0f);
        jointDef.localAnchorB.set(0.0f, -shin_offset / 2.0f);
        jointDef.enableLimit = true;
        jointDef.upperAngle = 1.5707964f;
        jointDef.lowerAngle = -1.5707964f;
        joint = world.createJoint(jointDef);
        this.joints.add(joint);
        WeldJointDef weldDef = new WeldJointDef();
        weldDef.bodyA = this.getBody(1);
        weldDef.bodyB = this.bubbler.getObstacle().getBody();
        weldDef.localAnchorA.set(this.bubbler.getOffset());
        weldDef.localAnchorB.set(0.0f, 0.0f);
        Joint wjoint = world.createJoint(weldDef);
        this.joints.add(wjoint);
        return true;
    }
}

