/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.physics.ragdoll;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.Pool;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.assets.ParserUtils;
import edu.cornell.gdiac.audio.SoundEffect;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.physics2.ObstacleSprite;
import edu.cornell.gdiac.physics2.WheelObstacle;
import edu.cornell.gdiac.util.RandomGenerator;

public class BubbleGenerator
extends ObstacleSprite {
    private final JsonValue data;
    private ParticlePool memory;
    private Vector2 offset;
    private Vector2 dimension;
    private int lifespan;
    private int timelimit;
    private int cooldown;
    private boolean bubbled;
    private SoundEffect[] bubbleSounds;

    public Vector2 getOffset() {
        return this.offset;
    }

    public BubbleGenerator(float units, JsonValue data) {
        JsonValue bodyPos = data.get("doll").get("torso").get("position");
        JsonValue headPos = data.get("doll").get("head").get("offset");
        JsonValue bubbPos = data.get("bubbles").get("offset");
        this.offset = new Vector2(bubbPos.getFloat(0), bubbPos.getFloat(1));
        float x = bodyPos.getFloat(0) + headPos.getFloat(0) + this.offset.x;
        float y = bodyPos.getFloat(1) + headPos.getFloat(1) + this.offset.y;
        float radius = data.get("bubbles").getFloat("size", 0.0f);
        this.data = data.get("bubbles");
        this.debug = ParserUtils.parseColor(this.data.get("debug"), Color.WHITE);
        this.obstacle = new WheelObstacle(x, y, radius);
        this.obstacle.setDensity(this.data.getFloat("density", 0.0f));
        this.obstacle.setPhysicsUnits(units);
        this.obstacle.setName("bubbler");
        this.obstacle.setUserData(this);
        this.mesh.set(-radius * units, -radius * units, 2.0f * radius * units, 2.0f * radius * units);
        this.lifespan = this.data.getInt("lifespan", 0);
        this.timelimit = this.data.getInt("cooldown", 0);
        this.cooldown = 0;
        this.bubbled = false;
        this.memory = new ParticlePool();
    }

    public void setAssets(AssetDirectory directory) {
        this.setTexture(directory.getEntry("ragdoll-bubble", Texture.class));
        this.bubbleSounds = new SoundEffect[this.data.getInt("sounds", 0)];
        for (int ii = 0; ii < this.bubbleSounds.length; ++ii) {
            this.bubbleSounds[ii] = directory.getEntry("ragdoll-glub" + (ii + 1), SoundEffect.class);
        }
    }

    private void bubble() {
        Particle p = (Particle)this.memory.obtain();
        if (p != null) {
            p.position.set(this.obstacle.getPosition());
            p.life = this.lifespan;
            int indx = RandomGenerator.getInt(0, this.bubbleSounds.length - 1);
            this.bubbleSounds[indx].play();
        }
    }

    @Override
    public void update(float dt) {
        float x = this.obstacle.getX();
        float y = this.obstacle.getY();
        float u = this.obstacle.getPhysicsUnits();
        for (Particle p : this.memory.getPool()) {
            if (p.life <= 0) continue;
            p.position.y += 1.0f / u;
            --p.life;
            if (p.life != 0) continue;
            this.memory.free(p);
        }
        if (this.cooldown == 0) {
            this.bubbled = true;
            this.bubble();
            this.cooldown = this.timelimit;
        } else {
            this.bubbled = false;
            --this.cooldown;
        }
    }

    @Override
    public void draw(SpriteBatch batch) {
        if (this.sprite.getTexture() == null) {
            return;
        }
        float w = this.sprite.getRegionWidth();
        float h = this.sprite.getRegionHeight();
        float u = this.obstacle.getPhysicsUnits();
        batch.setColor(Color.WHITE);
        batch.setTextureRegion(this.sprite);
        for (Particle p : this.memory.getPool()) {
            if (p.life <= 0) continue;
            float x = p.position.x * u;
            float y = p.position.y * u;
            this.transform.idt();
            this.transform.translate(x, y);
            batch.drawMesh(this.mesh, this.transform, false);
        }
    }

    private class ParticlePool
    extends Pool<Particle> {
        private static final int MAX_PARTICLES = 6;
        private Particle[] particles = new Particle[6];
        private int offset;

        public ParticlePool() {
            for (int ii = 0; ii < 6; ++ii) {
                this.particles[ii] = new Particle();
            }
            this.offset = 0;
        }

        public Particle[] getPool() {
            return this.particles;
        }

        @Override
        protected Particle newObject() {
            if (this.offset < this.particles.length) {
                ++this.offset;
                return this.particles[this.offset - 1];
            }
            return null;
        }
    }

    private class Particle
    implements Pool.Poolable {
        public Vector2 position = new Vector2();
        public int life = -1;

        @Override
        public void reset() {
            this.position.set(0.0f, 0.0f);
            this.life = -1;
        }
    }
}

