/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.physics.platform;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Affine2;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.assets.ParserUtils;
import edu.cornell.gdiac.graphics.SpriteBatch;
import edu.cornell.gdiac.graphics.Texture2D;
import edu.cornell.gdiac.math.Path2;
import edu.cornell.gdiac.math.PathFactory;
import edu.cornell.gdiac.physics2.CapsuleObstacle;
import edu.cornell.gdiac.physics2.ObstacleSprite;

public class Traci
extends ObstacleSprite {
    private final JsonValue data;
    private float width;
    private float height;
    private float force;
    private float damping;
    private float maxspeed;
    private float jump_force;
    private int jumpLimit;
    private int shotLimit;
    private float movement;
    private boolean faceRight;
    private int jumpCooldown;
    private boolean isJumping;
    private int shootCooldown;
    private boolean isGrounded;
    private boolean isShooting;
    private Path2 sensorOutline;
    private Color sensorColor;
    private String sensorName;
    private final Vector2 forceCache = new Vector2();
    private final Affine2 flipCache = new Affine2();

    public float getMovement() {
        return this.movement;
    }

    public void setMovement(float value) {
        this.movement = value;
        if (this.movement < 0.0f) {
            this.faceRight = false;
        } else if (this.movement > 0.0f) {
            this.faceRight = true;
        }
    }

    public boolean isShooting() {
        return this.isShooting && this.shootCooldown <= 0;
    }

    public void setShooting(boolean value) {
        this.isShooting = value;
    }

    public boolean isJumping() {
        return this.isJumping && this.isGrounded && this.jumpCooldown <= 0;
    }

    public void setJumping(boolean value) {
        this.isJumping = value;
    }

    public boolean isGrounded() {
        return this.isGrounded;
    }

    public void setGrounded(boolean value) {
        this.isGrounded = value;
    }

    public float getForce() {
        return this.force;
    }

    public float getDamping() {
        return this.damping;
    }

    public float getMaxSpeed() {
        return this.maxspeed;
    }

    public String getSensorName() {
        return this.sensorName;
    }

    public boolean isFacingRight() {
        return this.faceRight;
    }

    public Traci(float units, JsonValue data) {
        this.data = data;
        JsonValue debugInfo = data.get("debug");
        float x = data.get("pos").getFloat(0);
        float y = data.get("pos").getFloat(1);
        float s = data.getFloat("size");
        float size = s * units;
        this.width = s * data.get("inner").getFloat(0);
        this.height = s * data.get("inner").getFloat(1);
        this.obstacle = new CapsuleObstacle(x, y, this.width, this.height);
        ((CapsuleObstacle)this.obstacle).setTolerance(debugInfo.getFloat("tolerance", 0.5f));
        this.obstacle.setDensity(data.getFloat("density", 0.0f));
        this.obstacle.setFriction(data.getFloat("friction", 0.0f));
        this.obstacle.setRestitution(data.getFloat("restitution", 0.0f));
        this.obstacle.setFixedRotation(true);
        this.obstacle.setPhysicsUnits(units);
        this.obstacle.setUserData(this);
        this.obstacle.setName("traci");
        this.debug = ParserUtils.parseColor(debugInfo.get("avatar"), Color.WHITE);
        this.sensorColor = ParserUtils.parseColor(debugInfo.get("sensor"), Color.WHITE);
        this.maxspeed = data.getFloat("maxspeed", 0.0f);
        this.damping = data.getFloat("damping", 0.0f);
        this.force = data.getFloat("force", 0.0f);
        this.jump_force = data.getFloat("jump_force", 0.0f);
        this.jumpLimit = data.getInt("jump_cool", 0);
        this.shotLimit = data.getInt("shot_cool", 0);
        this.isGrounded = false;
        this.isShooting = false;
        this.isJumping = false;
        this.faceRight = true;
        this.shootCooldown = 0;
        this.jumpCooldown = 0;
        this.mesh.set(-size / 2.0f, -size / 2.0f, size, size);
    }

    public void createSensor() {
        Vector2 sensorCenter = new Vector2(0.0f, -this.height / 2.0f);
        FixtureDef sensorDef = new FixtureDef();
        sensorDef.density = this.data.getFloat("density", 0.0f);
        sensorDef.isSensor = true;
        JsonValue sensorjv = this.data.get("sensor");
        float w = sensorjv.getFloat("shrink", 0.0f) * this.width / 2.0f;
        float h = sensorjv.getFloat("height", 0.0f);
        PolygonShape sensorShape = new PolygonShape();
        sensorShape.setAsBox(w, h, sensorCenter, 0.0f);
        sensorDef.shape = sensorShape;
        Body body = this.obstacle.getBody();
        Fixture sensorFixture = body.createFixture(sensorDef);
        this.sensorName = "traci_sensor";
        sensorFixture.setUserData(this.sensorName);
        float u = this.obstacle.getPhysicsUnits();
        PathFactory factory = new PathFactory();
        this.sensorOutline = new Path2();
        factory.makeRect((sensorCenter.x - w / 2.0f) * u, (sensorCenter.y - h / 2.0f) * u, w * u, h * u, this.sensorOutline);
    }

    public void applyForce() {
        if (!this.obstacle.isActive()) {
            return;
        }
        Vector2 pos = this.obstacle.getPosition();
        float vx = this.obstacle.getVX();
        Body body = this.obstacle.getBody();
        if (this.getMovement() == 0.0f) {
            this.forceCache.set(-this.getDamping() * vx, 0.0f);
            body.applyForce(this.forceCache, pos, true);
        }
        if (Math.abs(vx) >= this.getMaxSpeed()) {
            this.obstacle.setVX(Math.signum(vx) * this.getMaxSpeed());
        } else {
            this.forceCache.set(this.getMovement(), 0.0f);
            body.applyForce(this.forceCache, pos, true);
        }
        if (this.isJumping()) {
            this.forceCache.set(0.0f, this.jump_force);
            body.applyLinearImpulse(this.forceCache, pos, true);
        }
    }

    @Override
    public void update(float dt) {
        this.jumpCooldown = this.isJumping() ? this.jumpLimit : Math.max(0, this.jumpCooldown - 1);
        this.shootCooldown = this.isShooting() ? this.shotLimit : Math.max(0, this.shootCooldown - 1);
        super.update(dt);
    }

    @Override
    public void draw(SpriteBatch batch) {
        if (this.faceRight) {
            this.flipCache.setToScaling(1.0f, 1.0f);
        } else {
            this.flipCache.setToScaling(-1.0f, 1.0f);
        }
        super.draw(batch, this.flipCache);
    }

    @Override
    public void drawDebug(SpriteBatch batch) {
        super.drawDebug(batch);
        if (this.sensorOutline != null) {
            batch.setTexture(Texture2D.getBlank());
            batch.setColor(this.sensorColor);
            Vector2 p = this.obstacle.getPosition();
            float a = this.obstacle.getAngle();
            float u = this.obstacle.getPhysicsUnits();
            this.transform.idt();
            this.transform.preRotate((float)((double)(a * 180.0f) / Math.PI));
            this.transform.preTranslate(p.x * u, p.y * u);
            batch.outline(this.sensorOutline, this.transform);
        }
    }
}

