/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.physics.platform;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.gdiac.assets.ParserUtils;
import edu.cornell.gdiac.math.Poly2;
import edu.cornell.gdiac.math.PolyTriangulator;
import edu.cornell.gdiac.physics2.ObstacleSprite;
import edu.cornell.gdiac.physics2.PolygonObstacle;

public class Surface
extends ObstacleSprite {
    public Surface(float[] points, float units, JsonValue settings) {
        float tile = settings.getFloat("tile");
        Poly2 poly = new Poly2();
        PolyTriangulator triangulator = new PolyTriangulator();
        triangulator.set(points);
        triangulator.calculate();
        triangulator.getPolygon(poly);
        this.obstacle = new PolygonObstacle(points);
        this.obstacle.setBodyType(BodyDef.BodyType.StaticBody);
        this.obstacle.setDensity(settings.getFloat("density", 0.0f));
        this.obstacle.setFriction(settings.getFloat("friction", 0.0f));
        this.obstacle.setRestitution(settings.getFloat("restitution", 0.0f));
        this.obstacle.setPhysicsUnits(units);
        this.obstacle.setUserData(this);
        this.debug = ParserUtils.parseColor(settings.get("debug"), Color.WHITE);
        poly.scl(units);
        this.mesh.set(poly, tile, tile);
    }
}

