/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.physics.platform;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Joint;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.physics.box2d.joints.RevoluteJointDef;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.cis3152.physics.ObstacleGroup;
import edu.cornell.gdiac.physics2.BoxObstacle;
import edu.cornell.gdiac.physics2.Obstacle;
import edu.cornell.gdiac.physics2.ObstacleSprite;
import edu.cornell.gdiac.physics2.WheelObstacle;

public class Spinner
extends ObstacleGroup {
    private JsonValue data;
    private ObstacleSprite barrier;

    public Spinner(float units, JsonValue data) {
        this.data = data;
        float x = data.get("pos").getFloat(0);
        float y = data.get("pos").getFloat(1);
        float w = data.get("size").getFloat(0);
        float h = data.get("size").getFloat(1);
        BoxObstacle obstacle = new BoxObstacle(x, y, w, h);
        obstacle.setName("barrier");
        obstacle.setDensity(data.getFloat("high density", 0.0f));
        obstacle.setPhysicsUnits(units);
        this.barrier = new ObstacleSprite(obstacle);
        this.barrier.setObstacle(obstacle);
        this.sprites.add(this.barrier);
        WheelObstacle pin = new WheelObstacle(x, y, data.getFloat("radius", 0.0f));
        pin.setName("pin");
        pin.setDensity(data.getFloat("low density", 0.0f));
        pin.setBodyType(BodyDef.BodyType.StaticBody);
        pin.setPhysicsUnits(units);
        ObstacleSprite sprite = new ObstacleSprite(pin);
        sprite.getMesh().clear();
        this.sprites.add(sprite);
    }

    @Override
    protected boolean createJoints(World world) {
        assert (this.sprites.size > 0);
        Obstacle obsA = ((ObstacleSprite)this.sprites.get(0)).getObstacle();
        Obstacle obsB = ((ObstacleSprite)this.sprites.get(1)).getObstacle();
        RevoluteJointDef jointDef = new RevoluteJointDef();
        jointDef.bodyA = obsA.getBody();
        jointDef.bodyB = obsB.getBody();
        jointDef.localAnchorA.set(0.0f, 0.0f);
        jointDef.localAnchorB.set(0.0f, 0.0f);
        Joint joint = world.createJoint(jointDef);
        this.joints.add(joint);
        return true;
    }

    public void setTexture(Texture texture) {
        this.barrier.setTexture(texture);
    }
}

