/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.physics.platform;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Joint;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.physics.box2d.joints.RevoluteJointDef;
import com.badlogic.gdx.utils.JsonValue;
import edu.cornell.cis3152.physics.ObstacleGroup;
import edu.cornell.gdiac.assets.ParserUtils;
import edu.cornell.gdiac.physics2.BoxObstacle;
import edu.cornell.gdiac.physics2.Obstacle;
import edu.cornell.gdiac.physics2.ObstacleSprite;
import edu.cornell.gdiac.physics2.WheelObstacle;

public class RopeBridge
extends ObstacleGroup {
    private JsonValue data;
    private WheelObstacle start = null;
    private WheelObstacle finish = null;
    protected Vector2 dimension;
    protected Vector2 planksize;
    protected float linksize = 1.0f;
    protected float spacing = 0.0f;

    public RopeBridge(float units, JsonValue data) {
        this.data = data;
        float x0 = data.get("pos").getFloat(0);
        float y0 = data.get("pos").getFloat(1);
        float lw = data.get("size").getFloat(0);
        float lh = data.get("size").getFloat(1);
        this.planksize = new Vector2(lw, lh);
        this.linksize = this.planksize.x;
        float extent = data.getFloat("extent", 0.0f);
        this.dimension = new Vector2(extent, 0.0f);
        float length = this.dimension.len();
        Vector2 norm = new Vector2(this.dimension);
        norm.nor();
        int nLinks = (int)(length / this.linksize);
        if (nLinks <= 1) {
            nLinks = 1;
            this.linksize = length;
            this.spacing = 0.0f;
        } else {
            this.spacing = length - (float)nLinks * this.linksize;
            this.spacing /= (float)(nLinks - 1);
        }
        Color color = ParserUtils.parseColor(data.get("debug"), Color.WHITE);
        float density = data.getFloat("density", 0.0f);
        this.planksize.x = this.linksize;
        Vector2 pos = new Vector2();
        for (int ii = 0; ii < nLinks; ++ii) {
            float t = (float)ii * (this.linksize + this.spacing) + this.linksize / 2.0f;
            pos.set(norm);
            pos.scl(t);
            pos.add(x0, y0);
            BoxObstacle plank = new BoxObstacle(pos.x, pos.y, this.planksize.x, this.planksize.y);
            plank.setName("plank" + ii);
            plank.setDensity(density);
            plank.setPhysicsUnits(units);
            ObstacleSprite sprite = new ObstacleSprite(plank);
            sprite.setDebugColor(color);
            this.sprites.add(sprite);
        }
    }

    @Override
    protected boolean createJoints(World world) {
        assert (this.sprites.size > 0);
        Vector2 anchor1 = new Vector2();
        Vector2 anchor2 = new Vector2(-this.linksize / 2.0f, 0.0f);
        Obstacle obs = ((ObstacleSprite)this.sprites.get(0)).getObstacle();
        Vector2 pos = obs.getPosition();
        pos.x -= this.linksize / 2.0f;
        this.start = new WheelObstacle(pos.x, pos.y, this.data.getFloat("pin_radius", 1.0f));
        this.start.setName("pin0");
        this.start.setDensity(this.data.getFloat("density", 0.0f));
        this.start.setBodyType(BodyDef.BodyType.StaticBody);
        this.start.activatePhysics(world);
        RevoluteJointDef jointDef = new RevoluteJointDef();
        jointDef.bodyA = this.start.getBody();
        jointDef.bodyB = obs.getBody();
        jointDef.localAnchorA.set(anchor1);
        jointDef.localAnchorB.set(anchor2);
        jointDef.collideConnected = false;
        Joint joint = world.createJoint(jointDef);
        this.joints.add(joint);
        anchor1.x = this.linksize / 2.0f;
        for (int ii = 0; ii < this.sprites.size - 1; ++ii) {
            Obstacle obsA = ((ObstacleSprite)this.sprites.get(ii)).getObstacle();
            Obstacle obsB = ((ObstacleSprite)this.sprites.get(ii + 1)).getObstacle();
            jointDef.bodyA = obsA.getBody();
            jointDef.bodyB = obsB.getBody();
            jointDef.localAnchorA.set(anchor1);
            jointDef.localAnchorB.set(anchor2);
            joint = world.createJoint(jointDef);
            jointDef.collideConnected = false;
            this.joints.add(joint);
        }
        Obstacle last = ((ObstacleSprite)this.sprites.get(this.sprites.size - 1)).getObstacle();
        pos = last.getPosition();
        pos.x += this.linksize / 2.0f;
        this.finish = new WheelObstacle(pos.x, pos.y, this.data.getFloat("pin_radius", 1.0f));
        this.finish.setName("pin1");
        this.finish.setDensity(this.data.getFloat("density", 0.0f));
        this.finish.setBodyType(BodyDef.BodyType.StaticBody);
        this.finish.activatePhysics(world);
        anchor2.x = 0.0f;
        jointDef.bodyA = last.getBody();
        jointDef.bodyB = this.finish.getBody();
        jointDef.localAnchorA.set(anchor1);
        jointDef.localAnchorB.set(anchor2);
        joint = world.createJoint(jointDef);
        this.joints.add(joint);
        return true;
    }

    @Override
    public void deactivatePhysics(World world) {
        super.deactivatePhysics(world);
        if (this.start != null) {
            this.start.deactivatePhysics(world);
        }
        if (this.finish != null) {
            this.finish.deactivatePhysics(world);
        }
    }

    public void setTexture(Texture texture) {
        for (ObstacleSprite sprite : this.sprites) {
            sprite.setTexture(texture);
        }
    }
}

