/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.cis3152.physics.platform;

import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.physics.box2d.ContactImpulse;
import com.badlogic.gdx.physics.box2d.ContactListener;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.Manifold;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ObjectSet;
import edu.cornell.cis3152.physics.InputController;
import edu.cornell.cis3152.physics.PhysicsScene;
import edu.cornell.cis3152.physics.platform.Bullet;
import edu.cornell.cis3152.physics.platform.Door;
import edu.cornell.cis3152.physics.platform.RopeBridge;
import edu.cornell.cis3152.physics.platform.Spinner;
import edu.cornell.cis3152.physics.platform.Surface;
import edu.cornell.cis3152.physics.platform.Traci;
import edu.cornell.gdiac.assets.AssetDirectory;
import edu.cornell.gdiac.audio.SoundEffect;
import edu.cornell.gdiac.audio.SoundEffectManager;
import edu.cornell.gdiac.physics2.Obstacle;
import edu.cornell.gdiac.physics2.ObstacleSprite;

public class PlatformScene
extends PhysicsScene
implements ContactListener {
    private TextureRegion avatarTexture;
    private TextureRegion barrierTexture;
    private TextureRegion bulletTexture;
    private TextureRegion bridgeTexture;
    private SoundEffect jumpSound;
    private SoundEffect fireSound;
    private SoundEffect plopSound;
    private float volume;
    private Traci avatar;
    private Door goalDoor;
    protected ObjectSet<Fixture> sensorFixtures;

    public PlatformScene(AssetDirectory directory) {
        super(directory, "platform");
        this.world.setContactListener(this);
        this.sensorFixtures = new ObjectSet();
        this.jumpSound = directory.getEntry("platform-jump", SoundEffect.class);
        this.fireSound = directory.getEntry("platform-pew", SoundEffect.class);
        this.plopSound = directory.getEntry("platform-plop", SoundEffect.class);
        this.volume = this.constants.getFloat("volume", 1.0f);
    }

    @Override
    public void reset() {
        JsonValue values = this.constants.get("world");
        Vector2 gravity = new Vector2(0.0f, values.getFloat("gravity"));
        for (ObstacleSprite sprite : this.sprites) {
            Obstacle obj = sprite.getObstacle();
            sprite.getObstacle().deactivatePhysics(this.world);
        }
        this.sprites.clear();
        this.addQueue.clear();
        if (this.world != null) {
            this.world.dispose();
        }
        this.world = new World(gravity, false);
        this.world.setContactListener(this);
        this.setComplete(false);
        this.setFailure(false);
        this.populateLevel();
    }

    private void populateLevel() {
        float units = this.height / this.bounds.height;
        Texture texture = this.directory.getEntry("shared-goal", Texture.class);
        JsonValue goal = this.constants.get("goal");
        JsonValue goalpos = goal.get("pos");
        this.goalDoor = new Door(units, goal);
        this.goalDoor.setTexture(texture);
        this.goalDoor.getObstacle().setName("goal");
        this.addSprite(this.goalDoor);
        texture = this.directory.getEntry("shared-earth", Texture.class);
        String wname = "wall";
        JsonValue walls = this.constants.get("walls");
        JsonValue walljv = walls.get("positions");
        for (int ii = 0; ii < walljv.size; ++ii) {
            Surface wall = new Surface(walljv.get(ii).asFloatArray(), units, walls);
            wall.getObstacle().setName(wname + ii);
            wall.setTexture(texture);
            this.addSprite(wall);
        }
        String pname = "platform";
        JsonValue plats = this.constants.get("platforms");
        JsonValue platjv = plats.get("positions");
        for (int ii = 0; ii < platjv.size; ++ii) {
            Surface platform = new Surface(platjv.get(ii).asFloatArray(), units, walls);
            platform.getObstacle().setName(pname + ii);
            platform.setTexture(texture);
            this.addSprite(platform);
        }
        texture = this.directory.getEntry("platform-traci", Texture.class);
        this.avatar = new Traci(units, this.constants.get("traci"));
        this.avatar.setTexture(texture);
        this.addSprite(this.avatar);
        this.avatar.createSensor();
        texture = this.directory.getEntry("platform-rope", Texture.class);
        RopeBridge bridge = new RopeBridge(units, this.constants.get("bridge"));
        bridge.setTexture(texture);
        this.addSpriteGroup(bridge);
        texture = this.directory.getEntry("platform-barrier", Texture.class);
        Spinner spinPlatform = new Spinner(units, this.constants.get("spinner"));
        spinPlatform.setTexture(texture);
        this.addSpriteGroup(spinPlatform);
    }

    @Override
    public boolean preUpdate(float dt) {
        if (!super.preUpdate(dt)) {
            return false;
        }
        if (!this.isFailure() && this.avatar.getObstacle().getY() < -1.0f) {
            this.setFailure(true);
            return false;
        }
        return true;
    }

    @Override
    public void update(float dt) {
        InputController input = InputController.getInstance();
        this.avatar.setMovement(input.getHorizontal() * this.avatar.getForce());
        this.avatar.setJumping(input.didPrimary());
        this.avatar.setShooting(input.didSecondary());
        if (this.avatar.isShooting()) {
            this.createBullet();
        }
        this.avatar.applyForce();
        if (this.avatar.isJumping()) {
            SoundEffectManager sounds = SoundEffectManager.getInstance();
            sounds.play("jump", this.jumpSound, this.volume);
        }
    }

    private void createBullet() {
        float units = this.height / this.bounds.height;
        JsonValue bulletjv = this.constants.get("bullet");
        Obstacle traci = this.avatar.getObstacle();
        Texture texture = this.directory.getEntry("platform-bullet", Texture.class);
        Bullet bullet = new Bullet(units, bulletjv, traci.getPosition(), this.avatar.isFacingRight());
        bullet.setTexture(texture);
        this.addQueuedObject(bullet);
        SoundEffectManager sounds = SoundEffectManager.getInstance();
        sounds.play("fire", this.fireSound, this.volume);
    }

    public void removeBullet(ObstacleSprite bullet) {
        bullet.getObstacle().markRemoved(true);
        SoundEffectManager sounds = SoundEffectManager.getInstance();
        sounds.play("plop", this.plopSound, this.volume);
    }

    @Override
    public void beginContact(Contact contact) {
        Fixture fix1 = contact.getFixtureA();
        Fixture fix2 = contact.getFixtureB();
        Body body1 = fix1.getBody();
        Body body2 = fix2.getBody();
        Object fd1 = fix1.getUserData();
        Object fd2 = fix2.getUserData();
        try {
            ObstacleSprite bd1 = (ObstacleSprite)body1.getUserData();
            ObstacleSprite bd2 = (ObstacleSprite)body2.getUserData();
            if (bd1.getName().equals("bullet") && bd2 != this.avatar && !bd2.getName().equals("goal")) {
                this.removeBullet(bd1);
            }
            if (bd2.getName().equals("bullet") && bd1 != this.avatar && !bd1.getName().equals("goal")) {
                this.removeBullet(bd2);
            }
            if (this.avatar.getSensorName().equals(fd2) && this.avatar != bd1 || this.avatar.getSensorName().equals(fd1) && this.avatar != bd2) {
                this.avatar.setGrounded(true);
                this.sensorFixtures.add(this.avatar == bd1 ? fix2 : fix1);
            }
            if (bd1 == this.avatar && bd2.getName().equals("goal") || bd1.getName().equals("goal") && bd2 == this.avatar) {
                this.setComplete(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void endContact(Contact contact) {
        Fixture fix1 = contact.getFixtureA();
        Fixture fix2 = contact.getFixtureB();
        Body body1 = fix1.getBody();
        Body body2 = fix2.getBody();
        Object fd1 = fix1.getUserData();
        Object fd2 = fix2.getUserData();
        Object bd1 = body1.getUserData();
        Object bd2 = body2.getUserData();
        if (this.avatar.getSensorName().equals(fd2) && this.avatar != bd1 || this.avatar.getSensorName().equals(fd1) && this.avatar != bd2) {
            this.sensorFixtures.remove(this.avatar == bd1 ? fix2 : fix1);
            if (this.sensorFixtures.size == 0) {
                this.avatar.setGrounded(false);
            }
        }
    }

    @Override
    public void postSolve(Contact contact, ContactImpulse impulse) {
    }

    @Override
    public void preSolve(Contact contact, Manifold oldManifold) {
    }

    @Override
    public void pause() {
        SoundEffectManager sounds = SoundEffectManager.getInstance();
        sounds.stop("plop");
        sounds.stop("fire");
        sounds.stop("jump");
    }
}

